/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.project.ProjectBuilderDefinition;

public class ProjectBuilderDefinitionFactory {
    public static final String BUILDERS_EXTENSION_POINT = "org.springframework.ide.eclipse.core.builders";

    public static List<ProjectBuilderDefinition> getProjectBuilderDefinitions() {
        ArrayList<ProjectBuilderDefinition> builderDefinitions = new ArrayList<ProjectBuilderDefinition>();
        IExtension[] iExtensionArray = Platform.getExtensionRegistry().getExtensionPoint(BUILDERS_EXTENSION_POINT).getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    ProjectBuilderDefinition builderDefinition = new ProjectBuilderDefinition(element);
                    builderDefinitions.add(builderDefinition);
                }
                catch (CoreException e) {
                    SpringCore.log(e);
                }
                catch (Exception exception) {}
                ++n4;
            }
            ++n2;
        }
        Collections.sort(builderDefinitions, new Comparator<ProjectBuilderDefinition>(){

            @Override
            public int compare(ProjectBuilderDefinition o1, ProjectBuilderDefinition o2) {
                return o1.getOrder().compareTo(o2.getOrder());
            }
        });
        return builderDefinitions;
    }
}

