/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.model.java;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.beans.factory.parsing.SourceExtractor;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.java.JavaModelSourceLocation;
import org.springframework.ide.eclipse.core.type.asm.CachingClassReaderFactory;
import org.springframework.ide.eclipse.core.type.asm.ClassMetadataReadingVisitor;
import org.springframework.ide.eclipse.core.type.asm.ClassReaderFactory;

public class JavaSourceExtractor
implements SourceExtractor {
    private final IProject project;
    private final ClassReaderFactory classReaderFactory = new CachingClassReaderFactory();

    public JavaSourceExtractor(IProject project) {
        this.project = project;
    }

    public Object extractSource(Object sourceCandidate, Resource definingResource) {
        if (sourceCandidate instanceof FileSystemResource) {
            try {
                ClassReader reader = this.classReaderFactory.getClassReader((Resource)((FileSystemResource)sourceCandidate));
                ClassMetadataReadingVisitor v = new ClassMetadataReadingVisitor();
                reader.accept((ClassVisitor)v, 2);
                String className = v.getClassName();
                IType type = JdtUtils.getJavaType(this.project, className);
                if (type != null) {
                    return new JavaModelSourceLocation((IJavaElement)type);
                }
            }
            catch (IOException iOException) {
            }
            catch (JavaModelException javaModelException) {}
        }
        return sourceCandidate;
    }
}

