/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.io.InputStreamUtils;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.util.ObjectUtils;

public class ZipEntryStorage
implements IStorage,
IAdaptable {
    public static final String DELIMITER = "!";
    private String fullName;
    private IFile file;
    private String entryName;
    private IPath entryPath;
    private IResourceModelElement parentModelElement;

    public ZipEntryStorage(IProject project, String fullName) {
        int pos = fullName.indexOf(DELIMITER);
        if (pos == -1 || pos == fullName.length() - DELIMITER.length()) {
            throw new IllegalArgumentException("Illegal JAR entry name '" + fullName + "'");
        }
        IResource member = project.findMember(fullName.substring(0, pos));
        if (member == null || !(member instanceof IFile)) {
            throw new IllegalArgumentException("Missing or wrong zip file: " + this.file);
        }
        this.fullName = fullName;
        this.file = (IFile)member;
        this.entryName = fullName.substring(pos + DELIMITER.length());
        this.entryPath = new Path(this.entryName);
    }

    public ZipEntryStorage(IFile file, String entryName) {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException("Missing or wrong zip file: " + file);
        }
        this.fullName = file.getProjectRelativePath() + DELIMITER + entryName;
        this.file = file;
        this.entryName = entryName;
        this.entryPath = new Path(entryName);
    }

    public ZipEntryStorage(IResourceModelElement element) {
        if (element == null || !element.isElementArchived() || !(element.getElementResource() instanceof IFile)) {
            throw new IllegalArgumentException("Missing or wrong model element: " + element);
        }
        this.fullName = element.getElementName();
        this.file = (IFile)element.getElementResource();
        this.entryName = this.fullName.substring(this.fullName.indexOf(DELIMITER) + DELIMITER.length());
        this.entryPath = new Path(this.entryName);
        this.parentModelElement = element;
    }

    public IFile getFile() {
        return this.file;
    }

    public InputStream getContents() throws CoreException {
        try {
            ZipEntry entry;
            ZipFile file = new ZipFile(this.file.getLocation().toFile());
            String cleanedEntryName = this.entryName;
            if (cleanedEntryName.length() > 1 && cleanedEntryName.charAt(0) == '/') {
                cleanedEntryName = cleanedEntryName.substring(1);
            }
            if ((entry = file.getEntry(cleanedEntryName)) == null) {
                throw new CoreException(SpringCore.createErrorStatus("Invalid path '" + cleanedEntryName + "'", null));
            }
            return InputStreamUtils.getWrappedInputStream(file, entry);
        }
        catch (IOException e) {
            throw new CoreException(SpringCore.createErrorStatus(e.getMessage(), e));
        }
    }

    public IPath getFullPath() {
        return this.entryPath;
    }

    public String getName() {
        return this.entryPath.lastSegment();
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public String getAbsoluteName() {
        return this.file.getProject().getFullPath().append(this.fullName).toString();
    }

    public boolean isReadOnly() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        if (this.file != null) {
            if (adapter.equals(IFile.class)) {
                return this.file;
            }
            if (adapter.equals(File.class)) {
                return this.file.getFullPath().toFile();
            }
            if (adapter.equals(ZipFile.class)) {
                try {
                    return new ZipFile(this.file.getFullPath().toFile());
                }
                catch (IOException e) {
                    SpringCore.log(e);
                }
            }
        }
        if (IResourceModelElement.class.equals((Object)adapter)) {
            return this.parentModelElement;
        }
        return null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ZipEntryStorage)) {
            return false;
        }
        ZipEntryStorage that = (ZipEntryStorage)other;
        if (!ObjectUtils.nullSafeEquals((Object)this.fullName, (Object)that.fullName)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.file, (Object)that.file);
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode((Object)this.fullName);
        return 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.file);
    }

    public String toString() {
        return "ZipEntryStorage[" + this.file.toString() + " - " + this.entryPath + "]";
    }
}

