/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.maven.internal.legacyconversion;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.springframework.ide.eclipse.maven.MavenCorePlugin;
import org.springframework.ide.eclipse.maven.internal.legacyconversion.IM2EConstants;

public class ListMessageDialog
extends MessageDialogWithToggle
implements IM2EConstants {
    private static final String PREFERENCE_QUESTION = "Don't show this dialog again.";
    private static final String TITLE = "Should convert legacy Maven projects?";
    private static final String DIALOG_TEXT = "The following legacy Maven projects have been found.\nDo you want them to be automatically upgraded to the new version of M2E (Maven-Eclipse integration)?\n** These projects will not compile until they are upgraded to M2E version 1.0. **You can choose to upgrade later by going to:\nProject -> Configure -> Convert legacy Maven projects...";
    private final IProject[] legacyProjects;
    private IProject[] checkedLegacyProjects;
    private CheckboxTableViewer viewer;

    public static IProject[] openViewer(Shell shell, IProject[] legacyProjects) {
        ListMessageDialog dialog = new ListMessageDialog(shell, legacyProjects);
        int res = dialog.open();
        MavenCorePlugin.getDefault().getPreferenceStore().setValue("dont.auto.check.for.legacy", dialog.getToggleState());
        if (res == 2) {
            return dialog.getAllChecked();
        }
        return null;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 2) {
            Object[] checkedElements = this.viewer.getCheckedElements();
            this.checkedLegacyProjects = new IProject[checkedElements.length];
            System.arraycopy(checkedElements, 0, this.checkedLegacyProjects, 0, checkedElements.length);
        }
        super.buttonPressed(buttonId);
    }

    protected boolean isResizable() {
        return true;
    }

    public ListMessageDialog(Shell shell, IProject[] legacyProjects) {
        super(shell, TITLE, null, DIALOG_TEXT, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0, PREFERENCE_QUESTION, MavenCorePlugin.getDefault().getPreferenceStore().getBoolean("dont.auto.check.for.legacy"));
        this.legacyProjects = legacyProjects;
    }

    protected Control createCustomArea(Composite parent) {
        ((GridLayout)parent.getLayout()).numColumns = 2;
        ((GridLayout)parent.getLayout()).makeColumnsEqualWidth = false;
        this.viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        gd.verticalSpan = 2;
        this.viewer.getTable().setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.setInput((Object)this.legacyProjects);
        this.viewer.setAllChecked(true);
        ListMessageDialog.applyDialogFont((Control)this.viewer.getControl());
        this.createButton(parent, "Select all", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListMessageDialog.this.viewer.setAllChecked(true);
            }
        });
        this.createButton(parent, "Select none", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListMessageDialog.this.viewer.setAllChecked(false);
            }
        });
        return this.viewer.getControl();
    }

    protected Button createButton(Composite parent, String label, SelectionListener listener) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        button.addSelectionListener(listener);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.verticalAlignment = 1;
        gd.widthHint = 100;
        button.setLayoutData((Object)gd);
        return button;
    }

    IProject[] getAllChecked() {
        return this.checkedLegacyProjects;
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IProject[]) {
                return (IProject[])inputElement;
            }
            return null;
        }
    }
}

