/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.ui.navigator.model;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.ui.IEditorPart;
import org.springframework.ide.eclipse.aop.ui.navigator.model.IRevealableReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.util.AopReferenceModelNavigatorUtils;

public class JavaElementReferenceNode
implements IRevealableReferenceNode {
    private IJavaElement method;
    private boolean isRoot = false;

    public JavaElementReferenceNode(IJavaElement elem, boolean isRoot) {
        this.method = elem;
        this.isRoot = isRoot;
    }

    public IJavaElement getJavaElement() {
        return this.method;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    @Override
    public void openAndReveal() {
        try {
            IEditorPart p = JavaUI.openInEditor((IJavaElement)this.method);
            JavaUI.revealInEditor((IEditorPart)p, (IJavaElement)this.method);
        }
        catch (Exception exception) {}
    }

    @Override
    public int getLineNumber() {
        if (this.method instanceof IMember) {
            return AopReferenceModelNavigatorUtils.getLineNumber((IMember)this.method);
        }
        return -1;
    }

    @Override
    public IResource getResource() {
        return this.method.getResource();
    }

    public Object getReferenceParticipant() {
        return this.method;
    }
}

