/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.crucible.api.model;

import com.atlassian.theplugin.commons.crucible.api.model.BasicReview;
import com.atlassian.theplugin.commons.crucible.api.model.Comment;
import com.atlassian.theplugin.commons.crucible.api.model.CrucibleFileInfo;
import com.atlassian.theplugin.commons.crucible.api.model.PermId;
import com.atlassian.theplugin.commons.crucible.api.model.ReviewType;
import com.atlassian.theplugin.commons.crucible.api.model.User;
import com.atlassian.theplugin.commons.crucible.api.model.VersionedComment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Review
extends BasicReview {
    private Set<CrucibleFileInfo> files = Collections.emptySet();
    private List<Comment> generalComments = Collections.emptyList();

    public Review(@NotNull String serverUrl, @NotNull String projectKey, @NotNull User author, @Nullable User moderator) {
        this(ReviewType.REVIEW, serverUrl, projectKey, author, moderator);
    }

    public Review(@NotNull ReviewType type, @NotNull String serverUrl, @NotNull String projectKey, @NotNull User author, @Nullable User moderator) {
        super(type, serverUrl, projectKey, author, moderator);
    }

    public void setGeneralComments(@NotNull List<Comment> generalComments) {
        this.generalComments = generalComments;
    }

    @NotNull
    public List<Comment> getGeneralComments() {
        return this.generalComments;
    }

    public void removeGeneralComment(Comment generalComment) {
        if (!generalComment.isReply()) {
            this.generalComments.remove(generalComment);
        } else {
            for (Comment comment : this.generalComments) {
                if (!comment.getReplies().remove(generalComment)) continue;
                return;
            }
        }
    }

    public void removeVersionedComment(VersionedComment comment, CrucibleFileInfo file) {
        CrucibleFileInfo f = this.getFileByPermId(file.getPermId());
        if (!comment.isReply()) {
            if (f != null) {
                f.getVersionedComments().remove(comment);
            }
        } else if (f != null) {
            for (VersionedComment versionedComment : f.getVersionedComments()) {
                if (!versionedComment.getReplies().remove(comment)) continue;
                return;
            }
        }
    }

    public void setFilesAndVersionedComments(Collection<CrucibleFileInfo> aFiles, List<VersionedComment> commentList) {
        HashSet<CrucibleFileInfo> hashSet = this.files = aFiles != null ? new HashSet<CrucibleFileInfo>(aFiles) : null;
        if (this.files != null && commentList != null) {
            for (VersionedComment comment : commentList) {
                comment.getCrucibleFileInfo().addComment(comment);
            }
        }
    }

    @Nullable
    public CrucibleFileInfo getFileByPermId(PermId id) {
        for (CrucibleFileInfo f : this.getFiles()) {
            if (!f.getPermId().equals(id)) continue;
            return f;
        }
        return null;
    }

    public Set<CrucibleFileInfo> getFiles() {
        return this.files;
    }

    public void setFiles(@NotNull Set<CrucibleFileInfo> files) {
        this.files = files;
    }

    public int getNumberOfGeneralCommentsDrafts() {
        int num = 0;
        for (Comment comment : this.getGeneralComments()) {
            if (comment.isDraft()) {
                ++num;
            }
            num += comment.getNumberOfDraftReplies();
        }
        return num;
    }

    @Deprecated
    public int getNumberOfGeneralCommentsDrafts(String userName) {
        int num = 0;
        for (Comment comment : this.getGeneralComments()) {
            if (comment.isDraft() && comment.getAuthor().getUsername().equals(userName)) {
                ++num;
            }
            num += comment.getNumberOfDraftReplies();
            for (Comment reply : comment.getReplies()) {
                if (!reply.isDraft() || !reply.getAuthor().getUsername().equals(userName)) continue;
                ++num;
            }
        }
        return num;
    }

    public int getNumberOfGeneralCommentsDefects() {
        int num = 0;
        for (Comment comment : this.getGeneralComments()) {
            if (comment.isDefectRaised()) {
                ++num;
            }
            for (Comment reply : comment.getReplies()) {
                if (!reply.isDefectRaised()) continue;
                ++num;
            }
        }
        return num;
    }

    public int getNumberOfGeneralCommentsDefects(String userName) {
        int num = 0;
        for (Comment comment : this.getGeneralComments()) {
            if (comment.isDefectRaised() && comment.getAuthor().getUsername().equals(userName)) {
                ++num;
            }
            for (Comment reply : comment.getReplies()) {
                if (!reply.isDefectRaised() || !reply.getAuthor().getUsername().equals(userName)) continue;
                ++num;
            }
        }
        return num;
    }

    public int getNumberOfGeneralComments() {
        int num = this.getGeneralComments().size();
        for (Comment comment : this.getGeneralComments()) {
            num += comment.getReplies().size();
        }
        return num;
    }

    public int getNumberOfVersionedComments() {
        int num = 0;
        for (CrucibleFileInfo file : this.getFiles()) {
            num += file.getNumberOfComments();
        }
        return num;
    }

    public int getNumberOfVersionedComments(String userName) {
        int num = 0;
        for (CrucibleFileInfo file : this.getFiles()) {
            num += file.getNumberOfComments(userName);
        }
        return num;
    }

    public int getNumberOfUnreadComments() {
        ArrayList<Comment> allComments = new ArrayList<Comment>();
        allComments.addAll(this.getGeneralComments());
        for (CrucibleFileInfo file : this.getFiles()) {
            allComments.addAll(file.getVersionedComments());
        }
        int result = 0;
        for (Comment comment : allComments) {
            if (comment.getReadState() == Comment.ReadState.UNREAD || comment.getReadState() == Comment.ReadState.LEAVE_UNREAD) {
                ++result;
            }
            for (Comment reply : comment.getReplies()) {
                if (reply.getReadState() != Comment.ReadState.UNREAD && reply.getReadState() != Comment.ReadState.LEAVE_UNREAD) continue;
                ++result;
            }
        }
        return result;
    }

    public int getNumberOfVersionedCommentsDefects() {
        int num = 0;
        for (CrucibleFileInfo file : this.getFiles()) {
            num += file.getNumberOfCommentsDefects();
        }
        return num;
    }

    public int getNumberOfVersionedCommentsDefects(String userName) {
        int num = 0;
        for (CrucibleFileInfo file : this.getFiles()) {
            num += file.getNumberOfCommentsDefects(userName);
        }
        return num;
    }

    public int getNumberOfVersionedCommentsDrafts() {
        int num = 0;
        for (CrucibleFileInfo file : this.getFiles()) {
            num += file.getNumberOfCommentsDrafts();
        }
        return num;
    }

    @Deprecated
    public int getNumberOfVersionedCommentsDrafts(String userName) {
        int num = 0;
        for (CrucibleFileInfo file : this.getFiles()) {
            num += file.getNumberOfCommentsDrafts(userName);
        }
        return num;
    }

    public int getNumberOfGeneralComments(String userName) {
        int num = 0;
        for (Comment comment : this.getGeneralComments()) {
            if (comment.getAuthor().getUsername().equals(userName)) {
                ++num;
            }
            for (Comment reply : comment.getReplies()) {
                if (!reply.getAuthor().getUsername().equals(userName)) continue;
                ++num;
            }
        }
        return num;
    }
}

