/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.bamboo;

import com.atlassian.theplugin.commons.bamboo.BambooJob;
import com.atlassian.theplugin.commons.bamboo.TestDetails;
import com.atlassian.theplugin.commons.bamboo.TestDetailsInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BambooJobImpl
implements BambooJob {
    private final String key;
    private final String shortKey;
    private final String name;
    private final String shortName;
    private boolean enabled;
    private final List<TestDetails> successfulTests;
    private final List<TestDetails> failedTests;

    public BambooJobImpl(String key, String shortKey, String name, String shortName) {
        this.key = key;
        this.shortKey = shortKey;
        this.name = name;
        this.shortName = shortName;
        this.successfulTests = new ArrayList<TestDetails>();
        this.failedTests = new ArrayList<TestDetails>();
    }

    public void addFailedTest(TestDetailsInfo tInfo) {
        this.getFailedTests().add(tInfo);
    }

    public void addSuccessfulTest(TestDetailsInfo tInfo) {
        this.getSuccessfulTests().add(tInfo);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getShortKey() {
        return this.shortKey != null && this.shortKey.length() > 0 ? this.shortKey : StringUtils.substringAfterLast((String)this.key, (String)"-");
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public List<TestDetails> getSuccessfulTests() {
        return this.successfulTests;
    }

    @Override
    public List<TestDetails> getFailedTests() {
        return this.failedTests;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }
}

