/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.commons.jira.beans;

import com.atlassian.connector.commons.jira.beans.JIRAQueryFragment;
import java.util.ArrayList;
import java.util.List;

public final class JiraQueryUrl {
    private static final int NOT_INITIALIZED = -10;
    private static final String ISSUE_NAVIGATOR = "/secure/IssueNavigator.jspa?refreshFilter=false&reset=update&show=View+%3E%3E";
    private static final String ISSUE_RSS = "/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?";
    private static final String ISSUES_SAVED_FILTER = "/sr/jira.issueviews:searchrequest-xml/";
    private String serverUrl = null;
    private List<JIRAQueryFragment> queryFragments = null;
    private String sortBy = null;
    private String sortOrder = null;
    private int start = -10;
    private int max = -10;
    private String userName = null;
    private String password;

    public String buildRssSearchUrl() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.buildQueryFragment());
        sb.append("&").append(this.buildOptions());
        if (this.serverUrl != null) {
            sb.insert(0, ISSUE_RSS);
            sb.insert(0, this.serverUrl);
        }
        return sb.toString();
    }

    public String buildIssueNavigatorUrl() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.buildQueryFragment());
        sb.append("&").append(this.buildOptions());
        if (this.serverUrl != null) {
            sb.insert(0, ISSUE_NAVIGATOR);
            sb.insert(0, this.serverUrl);
        }
        return sb.toString();
    }

    public String buildSavedFilterUrl() {
        JIRAQueryFragment query = this.queryFragments != null && this.queryFragments.size() > 0 ? this.queryFragments.get(0) : null;
        StringBuffer sb = new StringBuffer();
        if (this.serverUrl != null) {
            sb.append(this.serverUrl);
            sb.append(ISSUES_SAVED_FILTER);
        }
        if (query != null) {
            sb.append(query.getQueryStringFragment()).append("/SearchRequest-").append(query.getQueryStringFragment()).append(".xml");
        }
        sb.append("?");
        sb.append(this.buildOptions());
        return sb.toString();
    }

    private String buildQueryFragment() {
        StringBuilder sb = new StringBuilder();
        ArrayList<JIRAQueryFragment> fragmentsWithoutAnys = new ArrayList<JIRAQueryFragment>();
        for (JIRAQueryFragment jiraQueryFragment : this.queryFragments) {
            if (jiraQueryFragment.getId() == -1000L) continue;
            fragmentsWithoutAnys.add(jiraQueryFragment);
        }
        for (JIRAQueryFragment fragment : fragmentsWithoutAnys) {
            if (fragment.getQueryStringFragment() == null) continue;
            sb.append("&");
            sb.append(fragment.getQueryStringFragment());
        }
        return sb.toString();
    }

    private String buildOptions() {
        StringBuffer sb = new StringBuffer();
        if (this.sortBy != null) {
            sb.append("&sorter/field=").append(this.sortBy);
        }
        if (this.sortOrder != null) {
            sb.append("&sorter/order=").append(this.sortOrder);
        }
        if (this.start != -10) {
            sb.append("&pager/start=").append(this.start);
        }
        if (this.max != -10) {
            sb.append("&tempMax=").append(this.max);
        }
        if (this.userName != null) {
            sb.append(JiraQueryUrl.appendAuthentication(false, this.userName, this.password));
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    private static String appendAuthentication(boolean firstItem, String userName, String password) {
        return "";
    }

    private JiraQueryUrl(Builder builder) {
        this.queryFragments = builder.queryFragments;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.start = builder.start;
        this.max = builder.max;
        this.userName = builder.userName;
        this.serverUrl = builder.serverUrl;
        this.password = builder.password;
    }

    /* synthetic */ JiraQueryUrl(Builder builder, JiraQueryUrl jiraQueryUrl) {
        this(builder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private List<JIRAQueryFragment> queryFragments = null;
        private String sortBy = null;
        private String sortOrder = null;
        private int start = -1;
        private int max = -1;
        private String userName = null;
        private String serverUrl;
        private String password;

        public Builder serverUrl(String server) {
            this.serverUrl = server;
            return this;
        }

        public Builder queryFragments(List<JIRAQueryFragment> fragmentList) {
            this.queryFragments = fragmentList;
            return this;
        }

        public Builder sortBy(String sort) {
            this.sortBy = sort;
            return this;
        }

        public Builder sortOrder(String sortOdr) {
            this.sortOrder = sortOdr;
            return this;
        }

        public Builder start(int strt) {
            this.start = strt;
            return this;
        }

        public Builder max(int mx) {
            this.max = mx;
            return this;
        }

        public Builder userName(String username) {
            this.userName = username;
            return this;
        }

        public Builder password(String passw) {
            this.password = passw;
            return this;
        }

        public JiraQueryUrl build() {
            return new JiraQueryUrl(this, null);
        }

        public Builder queryFragment(JIRAQueryFragment fragment) {
            if (this.queryFragments == null) {
                this.queryFragments = new ArrayList<JIRAQueryFragment>();
            }
            this.queryFragments.add(fragment);
            return this;
        }
    }
}

