/*
 * Decompiled with CFR 0.152.
 */
package org.dadacoalition.yedit;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dadacoalition.yedit.Activator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class YEditLog {
    public static Logger logger;
    public static String DEFAULT_TRACE_LEVEL;
    public static String TRACE_LEVEL_OPTION;
    public static HashMap<String, Level> VALID_LEVELS;

    static {
        DEFAULT_TRACE_LEVEL = "INFO";
        TRACE_LEVEL_OPTION = "org.dadacoalition.yedit/debug/trace_level";
        VALID_LEVELS = new HashMap();
        VALID_LEVELS.put("FINEST", Level.FINEST);
        VALID_LEVELS.put("FINER", Level.FINER);
        VALID_LEVELS.put("FINE", Level.FINE);
        VALID_LEVELS.put("CONFIG", Level.CONFIG);
        VALID_LEVELS.put("INFO", Level.INFO);
        VALID_LEVELS.put("WARNING", Level.WARNING);
        VALID_LEVELS.put("SEVERE", Level.SEVERE);
    }

    public static void initializeTraceLogger() {
        Level traceLevel;
        logger = Logger.getLogger("org.dadacoalition.yedit");
        if (!Activator.getDefault().isDebugging()) {
            logger.setLevel(Level.OFF);
            return;
        }
        String traceLevelString = Platform.getDebugOption((String)TRACE_LEVEL_OPTION);
        if (traceLevelString == null) {
            traceLevelString = DEFAULT_TRACE_LEVEL;
        }
        if (!VALID_LEVELS.containsKey(traceLevelString = traceLevelString.toUpperCase())) {
            YEditLog.logError("The traceLevel '" + traceLevelString + "' is not valid. Trace level set to SEVERE");
            traceLevel = Level.SEVERE;
        } else {
            traceLevel = VALID_LEVELS.get(traceLevelString);
            logger.info("Setting trace level to " + traceLevel);
        }
        logger.setLevel(traceLevel);
    }

    public static void logException(Throwable exception) {
        YEditLog.logException(exception, "Unexpected exception: ");
    }

    public static void logException(Throwable exception, String message) {
        Status status = new Status(4, "org.dadacoalition.yedit", 0, message, exception);
        Activator.getDefault().getLog().log((IStatus)status);
    }

    public static void logError(String message) {
        Status status = new Status(4, "org.dadacoalition.yedit", message);
        Activator.getDefault().getLog().log((IStatus)status);
    }
}

