/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.ast;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.Parser;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ParseException;
import net.sourceforge.pmd.lang.rule.XPathRule;

public class XPathEvaluator {
    public static final XPathEvaluator instance = new XPathEvaluator();

    private XPathEvaluator() {
    }

    public Node getCompilationUnit(String source) {
        LanguageVersionHandler languageVersionHandler = this.getLanguageVersionHandler();
        Parser parser = languageVersionHandler.getParser(languageVersionHandler.getDefaultParserOptions());
        Node node = parser.parse(null, (Reader)new StringReader(source));
        languageVersionHandler.getSymbolFacade().start(node);
        languageVersionHandler.getTypeResolutionFacade(null).start(node);
        return node;
    }

    private LanguageVersionHandler getLanguageVersionHandler() {
        LanguageVersion languageVersion = this.getLanguageVersion();
        return languageVersion.getLanguageVersionHandler();
    }

    private LanguageVersion getLanguageVersion() {
        return LanguageRegistry.getLanguage((String)"Java").getDefaultVersion();
    }

    public List<Node> evaluate(String source, String xpathQuery, String xpathVersion) throws ParseException {
        Node c = this.getCompilationUnit(source);
        final ArrayList<Node> results = new ArrayList<Node>();
        XPathRule xpathRule = new XPathRule(){

            public void addViolation(Object data, Node node, String arg) {
                results.add(node);
            }
        };
        xpathRule.setMessage("");
        xpathRule.setLanguage(this.getLanguageVersion().getLanguage());
        xpathRule.setProperty((PropertyDescriptor)XPathRule.XPATH_DESCRIPTOR, (Object)xpathQuery);
        xpathRule.setProperty((PropertyDescriptor)XPathRule.VERSION_DESCRIPTOR, (Object)xpathVersion);
        RuleSet ruleSet = new RuleSet();
        ruleSet.addRule((Rule)xpathRule);
        RuleSets ruleSets = new RuleSets(ruleSet);
        RuleContext ruleContext = new RuleContext();
        ruleContext.setLanguageVersion(this.getLanguageVersion());
        ArrayList<Node> nodes = new ArrayList<Node>(1);
        nodes.add(c);
        ruleSets.apply(nodes, ruleContext, xpathRule.getLanguage());
        return results;
    }
}

