/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.properties;

import name.herlin.command.CommandException;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.BuildProjectCommand;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import net.sourceforge.pmd.eclipse.ui.properties.PMDPropertyPageBean;
import net.sourceforge.pmd.eclipse.ui.properties.UpdateProjectPropertiesCmd;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public class PMDPropertyPageController {
    private static final Logger log = Logger.getLogger(PMDPropertyPageController.class);
    private final Shell shell;
    private IProject project;
    private PMDPropertyPageBean propertyPageBean;
    private boolean pmdAlreadyActivated;

    public PMDPropertyPageController(Shell shell) {
        this.shell = shell;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        if (project.isAccessible()) {
            this.project = project;
        } else {
            log.warn((Object)"Couldn't accept project because it is not accessible.");
        }
    }

    public PMDPropertyPageBean getPropertyPageBean() {
        if (this.propertyPageBean == null) {
            log.debug((Object)"Building a property page bean");
            try {
                IProjectProperties properties = PMDPlugin.getDefault().loadProjectProperties(this.project);
                this.propertyPageBean = new PMDPropertyPageBean();
                this.propertyPageBean.setPmdEnabled(properties.isPmdEnabled());
                this.propertyPageBean.setProjectWorkingSet(properties.getProjectWorkingSet());
                this.propertyPageBean.setProjectRuleSet(properties.getProjectRuleSet());
                this.propertyPageBean.setRuleSetStoredInProject(properties.isRuleSetStoredInProject());
                this.propertyPageBean.setRuleSetFile(properties.getRuleSetFile());
                this.propertyPageBean.setIncludeDerivedFiles(properties.isIncludeDerivedFiles());
                this.propertyPageBean.setFullBuildEnabled(properties.isFullBuildEnabled());
                this.propertyPageBean.setViolationsAsErrors(properties.violationsAsErrors());
                this.pmdAlreadyActivated = properties.isPmdEnabled();
            }
            catch (PropertiesException e) {
                PMDPlugin.getDefault().showError(e.getMessage(), e);
            }
        }
        return this.propertyPageBean;
    }

    public RuleSet getAvailableRules() {
        return PMDPlugin.getDefault().getPreferencesManager().getRuleSet();
    }

    public boolean performOk() {
        try {
            this.checkProjectRuleSetFile();
            UpdateProjectPropertiesCmd cmd = new UpdateProjectPropertiesCmd();
            cmd.setProject(this.project);
            cmd.setPmdEnabled(this.propertyPageBean.isPmdEnabled());
            cmd.setProjectWorkingSet(this.propertyPageBean.getProjectWorkingSet());
            cmd.setProjectRuleSet(this.propertyPageBean.getProjectRuleSet());
            cmd.setRuleSetStoredInProject(this.propertyPageBean.isRuleSetStoredInProject());
            cmd.setRuleSetFile(this.propertyPageBean.getRuleSetFile());
            cmd.setIncludeDerivedFiles(this.propertyPageBean.isIncludeDerivedFiles());
            cmd.setFullBuildEnabled(this.propertyPageBean.isFullBuildEnabled());
            cmd.setViolationsAsErrors(this.propertyPageBean.violationsAsErrors());
            cmd.setUserInitiated(true);
            cmd.performExecute();
            log.debug((Object)"Updating command terminated, checking whether the project need to be rebuilt");
            if (this.pmdAlreadyActivated && cmd.isNeedRebuild()) {
                this.rebuildProject();
            }
        }
        catch (PropertiesException e) {
            PMDPlugin.getDefault().showError(e.getMessage(), e);
        }
        catch (CommandException e) {
            PMDPlugin.getDefault().showError(e.getMessage(), e);
        }
        return true;
    }

    public IWorkingSet selectWorkingSet(IWorkingSet currentWorkingSet) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkingSetManager workingSetManager = workbench.getWorkingSetManager();
        IWorkingSetSelectionDialog selectionDialog = workingSetManager.createWorkingSetSelectionDialog(this.shell, false);
        IWorkingSet selectedWorkingSet = null;
        if (currentWorkingSet != null) {
            selectionDialog.setSelection(new IWorkingSet[]{currentWorkingSet});
        }
        if (selectionDialog.open() == 0) {
            if (selectionDialog.getSelection().length == 0) {
                log.info((Object)"Deselect working set");
            } else {
                selectedWorkingSet = selectionDialog.getSelection()[0];
                log.info((Object)("Working set " + selectedWorkingSet.getName() + " selected"));
            }
        }
        return selectedWorkingSet;
    }

    private void rebuildProject() {
        boolean rebuild = MessageDialog.openQuestion((Shell)this.shell, (String)this.getMessage("message.question.title"), (String)this.getMessage("message.question.rebuild_project"));
        if (rebuild) {
            log.info((Object)("Full rebuild of the project " + this.project.getName()));
            try {
                BuildProjectCommand cmd = new BuildProjectCommand();
                cmd.setProject(this.project);
                cmd.setUserInitiated(true);
                cmd.performExecute();
            }
            catch (CommandException e) {
                PMDPlugin.getDefault().showError(e.getMessage(), e);
            }
        }
    }

    private void checkProjectRuleSetFile() throws PropertiesException {
        IProjectProperties properties;
        if (this.propertyPageBean.isRuleSetStoredInProject() && !(properties = PMDPlugin.getDefault().loadProjectProperties(this.project)).isRuleSetFileExist()) {
            this.createDefaultRuleSetFile();
        }
    }

    private void createDefaultRuleSetFile() throws PropertiesException {
        boolean create = MessageDialog.openQuestion((Shell)this.shell, (String)this.getMessage("message.question.title"), (String)this.getMessage("message.question.create_ruleset_file"));
        if (create) {
            IProjectProperties properties = PMDPlugin.getDefault().loadProjectProperties(this.project);
            properties.createDefaultRuleSetFile();
        } else {
            this.propertyPageBean.setRuleSetStoredInProject(false);
        }
    }

    protected String getMessage(String key) {
        return PMDPlugin.getDefault().getStringTable().getString(key);
    }
}

