/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.eclipse.ui.editors.SyntaxManager;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.SWTUtil;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.AbstractRulePanelManager;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.EditorUsageMode;
import net.sourceforge.pmd.eclipse.util.ColourManager;
import net.sourceforge.pmd.lang.rule.properties.StringProperty;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExclusionPanelManager
extends AbstractRulePanelManager {
    private Text excludeWidget;
    private StyledText xpathWidget;
    private Composite excludeColour;
    private Composite xPathColour;
    private ColourManager colourManager;
    private boolean showColourBoxes;
    private List<Control> miscControls = new ArrayList<Control>();
    public static final String ID = "exclusion";

    public ExclusionPanelManager(String theTitle, EditorUsageMode theMode, ValueChangeListener theListener, boolean showColourBoxesFlag) {
        super(ID, theTitle, theMode, theListener);
        this.showColourBoxes = showColourBoxesFlag;
    }

    @Override
    protected boolean canManageMultipleRules() {
        return true;
    }

    @Override
    protected void clearControls() {
        this.excludeWidget.setText("");
        this.xpathWidget.setText("");
    }

    @Override
    public void showControls(boolean flag) {
        for (Control control : this.miscControls) {
            control.setVisible(flag);
        }
    }

    @Override
    protected List<String> fieldErrors() {
        return Collections.emptyList();
    }

    private void addListeners(final Text control, final StringProperty desc, final Control colourWindow) {
        this.addTextListeners(control, desc);
        control.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newText = control.getText();
                if (colourWindow != null) {
                    colourWindow.setBackground(ExclusionPanelManager.this.colourManager.colourFor(newText));
                }
                ExclusionPanelManager.this.changed(desc, newText);
            }
        });
    }

    private void addListeners(final StyledText control, final StringProperty desc, final Control colourWindow) {
        this.addTextListeners(control, desc);
        control.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newText = control.getText();
                if (colourWindow != null) {
                    colourWindow.setBackground(ExclusionPanelManager.this.colourManager.colourFor(newText));
                }
                ExclusionPanelManager.this.changed(desc, newText);
            }
        });
    }

    private Composite newColourPanel(Composite parent, String label) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        Label labelWidget = new Label(panel, 0);
        labelWidget.setText(label);
        Composite clrPanel = new Composite(panel, 2048);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.heightHint = 15;
        gridData.widthHint = 15;
        gridData.grabExcessHorizontalSpace = false;
        clrPanel.setLayoutData((Object)gridData);
        this.miscControls.add((Control)clrPanel);
        this.miscControls.add((Control)labelWidget);
        return clrPanel;
    }

    @Override
    public Control setupOn(Composite parent) {
        String regexExclusionLabel = SWTUtil.stringFor("preference.ruleedit.label.exclusion_regex");
        String xpathExclusionLabel = SWTUtil.stringFor("preference.ruleedit.label.xpath_exclusion");
        String colourBoxLabel = SWTUtil.stringFor("preference.ruleedit.label.colour_code");
        this.colourManager = ColourManager.managerFor(parent.getDisplay());
        GridData gridData = new GridData(768);
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        panel.setLayout((Layout)layout);
        Label labelA = new Label(panel, 0);
        labelA.setText(regexExclusionLabel);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        labelA.setLayoutData((Object)gridData);
        if (this.showColourBoxes) {
            this.excludeColour = this.newColourPanel(panel, colourBoxLabel);
        }
        this.excludeWidget = this.newTextField(panel);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.excludeWidget.setLayoutData((Object)gridData);
        this.addListeners(this.excludeWidget, Rule.VIOLATION_SUPPRESS_REGEX_DESCRIPTOR, (Control)this.excludeColour);
        Label labelB = new Label(panel, 0);
        labelB.setText(xpathExclusionLabel);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        labelB.setLayoutData((Object)gridData);
        if (this.showColourBoxes) {
            this.xPathColour = this.newColourPanel(panel, colourBoxLabel);
        }
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        this.xpathWidget = this.newCodeField(panel);
        this.xpathWidget.setLayoutData((Object)gridData);
        SyntaxManager.adapt(this.xpathWidget, "xpath", null);
        this.addListeners(this.xpathWidget, Rule.VIOLATION_SUPPRESS_XPATH_DESCRIPTOR, (Control)this.xPathColour);
        this.miscControls.add((Control)labelA);
        this.miscControls.add((Control)labelB);
        this.miscControls.add((Control)this.excludeWidget);
        this.miscControls.add((Control)this.xpathWidget);
        panel.pack();
        return panel;
    }

    @Override
    protected void adapt() {
        if (this.rules == null) {
            this.shutdown(this.excludeWidget);
            this.shutdown(this.xpathWidget);
            return;
        }
        this.show(this.excludeWidget, this.rules.commonStringValue(Rule.VIOLATION_SUPPRESS_REGEX_DESCRIPTOR));
        this.show(this.xpathWidget, this.rules.commonStringValue(Rule.VIOLATION_SUPPRESS_XPATH_DESCRIPTOR));
    }
}

