/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.model;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.util.StringUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;

public class DataflowMethodRecord {
    private final IMethod method;
    private final Node node;

    public DataflowMethodRecord(IMethod javaMethod, Node pmdMethod) {
        if (javaMethod == null) {
            throw new IllegalArgumentException("javaMethod cannot be null");
        }
        if (pmdMethod == null) {
            throw new IllegalArgumentException("pmdMethod cannot be null");
        }
        this.method = javaMethod;
        this.node = pmdMethod;
    }

    public Node getPMDMethod() {
        return this.node;
    }

    public IMethod getJavaMethod() {
        return this.method;
    }

    public IResource getResource() {
        return this.method.getResource();
    }

    public IMarker[] getMarkers() {
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        try {
            if (this.method.getResource().isAccessible()) {
                IMarker[] allMarkers;
                IMarker[] iMarkerArray = allMarkers = MarkerUtil.findMarkers(this.method.getResource(), "net.sourceforge.pmd.eclipse.plugin.pmdDFAMarker");
                int n = allMarkers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    if (this.markerIsValid(marker) && !this.markerIsInList(marker, markers)) {
                        markers.add(marker);
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException ce) {
            PMDPlugin.getDefault().logError("message.error.find_marker" + this.toString(), ce);
        }
        IMarker[] markerArray = new IMarker[markers.size()];
        markers.toArray(markerArray);
        return markerArray;
    }

    private Object[] getMarkerAttributes(IMarker marker) {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(marker.getAttribute("message", ""));
        int line1 = marker.getAttribute("lineNumber", 0);
        int line2 = marker.getAttribute("line2", 0);
        if (line2 < line1) {
            int temp = line1;
            line1 = line2;
            line2 = temp;
        }
        values.add(line1);
        values.add(line2);
        values.add(marker.getAttribute("variable", ""));
        return values.toArray();
    }

    private boolean markerIsValid(IMarker marker) {
        boolean isValid = false;
        Object[] values = this.getMarkerAttributes(marker);
        int line1 = (Integer)values[1];
        int line2 = (Integer)values[2];
        if (line1 >= this.node.getBeginLine() && line2 <= this.node.getEndLine()) {
            isValid = true;
            int k = 0;
            while (k < values.length && isValid) {
                if (values[k] instanceof String && StringUtil.isEmpty((String)((String)values[k]))) {
                    isValid = false;
                } else if (values[k] instanceof Number && ((Number)values[k]).intValue() == 0) {
                    isValid = false;
                }
                ++k;
            }
        }
        return isValid;
    }

    private boolean markerIsInList(IMarker marker, List<IMarker> list) {
        boolean inList = false;
        if (list != null && !list.isEmpty()) {
            Object[] markerAttr = this.getMarkerAttributes(marker);
            int i = 0;
            while (i < list.size() && !inList) {
                Object[] listAttr = this.getMarkerAttributes(list.get(i));
                boolean markersAreEqual = true;
                int j = 0;
                while (j < listAttr.length) {
                    if (markerAttr[j] instanceof String && !((String)markerAttr[j]).equalsIgnoreCase((String)listAttr[j])) {
                        markersAreEqual = false;
                    } else if (markerAttr[j] instanceof Integer && !((Integer)markerAttr[j]).equals(listAttr[j])) {
                        markersAreEqual = false;
                    }
                    ++j;
                }
                if (markersAreEqual) {
                    inList = true;
                }
                ++i;
            }
        }
        return inList;
    }
}

