/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.PMDRuntimeConstants;
import net.sourceforge.pmd.eclipse.runtime.cmd.MarkerInfo2;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import net.sourceforge.pmd.eclipse.util.IOUtil;
import net.sourceforge.pmd.util.NumericConstants;
import net.sourceforge.pmd.util.StringUtil;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.ResourceWorkingSetFilter;

public class BaseVisitor {
    private static final Logger log = Logger.getLogger(BaseVisitor.class);
    private IProgressMonitor monitor;
    private boolean useTaskMarker = false;
    private Map<IFile, Set<MarkerInfo2>> accumulator;
    private RuleSet ruleSet;
    private int fileCount;
    private long pmdDuration;
    private IProjectProperties projectProperties;
    protected RuleSet hiddenRules = new RuleSet();
    private PMDConfiguration configuration;

    protected PMDConfiguration configuration() {
        if (this.configuration == null) {
            this.configuration = new PMDConfiguration();
        }
        return this.configuration;
    }

    protected BaseVisitor() {
    }

    public boolean isUseTaskMarker() {
        return this.useTaskMarker;
    }

    public void setUseTaskMarker(boolean useTaskMarker) {
        this.useTaskMarker = useTaskMarker;
    }

    public Map<IFile, Set<MarkerInfo2>> getAccumulator() {
        return this.accumulator;
    }

    public void setAccumulator(Map<IFile, Set<MarkerInfo2>> accumulator) {
        this.accumulator = accumulator;
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public boolean isCanceled() {
        return this.getMonitor() == null ? false : this.getMonitor().isCanceled();
    }

    public void subTask(String name) {
        if (this.getMonitor() != null) {
            this.getMonitor().subTask(name);
        }
    }

    public void worked(int work) {
        if (this.getMonitor() != null) {
            this.getMonitor().worked(work);
        }
    }

    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    public void setRuleSet(RuleSet ruleSet) {
        ruleSet.addRuleSet(this.hiddenRules);
        this.ruleSet = ruleSet;
    }

    public int getProcessedFilesCount() {
        return this.fileCount;
    }

    public long getActualPmdDuration() {
        return this.pmdDuration;
    }

    public void setProjectProperties(IProjectProperties projectProperties) {
        this.projectProperties = projectProperties;
    }

    private boolean isIncluded(IFile file) throws PropertiesException {
        return this.projectProperties.isIncludeDerivedFiles() || !this.projectProperties.isIncludeDerivedFiles() && !file.isDerived();
    }

    /*
     * Exception decompiling
     */
    protected final void reviewResource(IResource resource) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isFileInWorkingSet(IFile file) throws PropertiesException {
        boolean fileInWorkingSet = true;
        IWorkingSet workingSet = this.projectProperties.getProjectWorkingSet();
        if (workingSet != null) {
            ResourceWorkingSetFilter filter = new ResourceWorkingSetFilter();
            filter.setWorkingSet(workingSet);
            fileInWorkingSet = filter.select(null, null, (Object)file);
        }
        return fileInWorkingSet;
    }

    private int maxAllowableViolationsFor(Rule rule) {
        return rule.hasDescriptor((PropertyDescriptor)PMDRuntimeConstants.MAX_VIOLATIONS_DESCRIPTOR) ? (Integer)rule.getProperty((PropertyDescriptor)PMDRuntimeConstants.MAX_VIOLATIONS_DESCRIPTOR) : (Integer)PMDRuntimeConstants.MAX_VIOLATIONS_DESCRIPTOR.defaultValue();
    }

    public static String markerTypeFor(RuleViolation violation) {
        int priorityId = violation.getRule().getPriority().getPriority();
        switch (priorityId) {
            case 1: {
                return "net.sourceforge.pmd.eclipse.plugin.pmdMarker1";
            }
            case 2: {
                return "net.sourceforge.pmd.eclipse.plugin.pmdMarker2";
            }
            case 3: {
                return "net.sourceforge.pmd.eclipse.plugin.pmdMarker3";
            }
            case 4: {
                return "net.sourceforge.pmd.eclipse.plugin.pmdMarker4";
            }
            case 5: {
                return "net.sourceforge.pmd.eclipse.plugin.pmdMarker5";
            }
        }
        return "net.sourceforge.pmd.eclipse.plugin.pmdMarker";
    }

    private void prepareMarkerAccumulator(IFile file) {
        Map<IFile, Set<MarkerInfo2>> accumulator = this.getAccumulator();
        if (accumulator != null) {
            accumulator.put(file, new HashSet());
        }
    }

    private void updateMarkers(IFile file, RuleContext context, boolean fTask) throws CoreException, PropertiesException {
        Map<IFile, Set<MarkerInfo2>> accumulator = this.getAccumulator();
        HashSet<MarkerInfo2> markerSet = new HashSet<MarkerInfo2>();
        List<Review> reviewsList = this.findReviewedViolations(file);
        Review review = new Review();
        Iterator iter = context.getReport().iterator();
        HashMap<Rule, Integer> violationsByRule = new HashMap<Rule, Integer>();
        Rule rule = null;
        while (iter.hasNext()) {
            RuleViolation violation = (RuleViolation)iter.next();
            rule = violation.getRule();
            review.ruleName = rule.getName();
            review.lineNumber = violation.getBeginLine();
            if (reviewsList.contains(review)) {
                log.debug((Object)("Ignoring violation of rule " + rule.getName() + " at line " + violation.getBeginLine() + " because of a review."));
                continue;
            }
            Integer count = (Integer)violationsByRule.get(rule);
            if (count == null) {
                count = NumericConstants.ZERO;
                violationsByRule.put(rule, count);
            }
            int maxViolations = this.maxAllowableViolationsFor(rule);
            if (count < maxViolations) {
                markerSet.add(this.getMarkerInfo(violation, BaseVisitor.markerTypeFor(violation)));
                violationsByRule.put(rule, count + 1);
                log.debug((Object)("Adding a violation for rule " + rule.getName() + " at line " + violation.getBeginLine()));
                continue;
            }
            log.debug((Object)("Ignoring violation of rule " + rule.getName() + " at line " + violation.getBeginLine() + " because maximum violations has been reached for file " + file.getName()));
        }
        if (accumulator != null) {
            log.debug((Object)("Adding markerSet to accumulator for file " + file.getName()));
            accumulator.put(file, markerSet);
        }
    }

    private List<Review> findReviewedViolations(IFile file) {
        ArrayList<Review> reviews;
        block12: {
            reviews = new ArrayList<Review>();
            BufferedReader reader = null;
            try {
                int lineNumber = 0;
                boolean findLine = false;
                boolean comment = false;
                Stack<String> pendingReviews = new Stack<String>();
                reader = new BufferedReader(new InputStreamReader(file.getContents()));
                while (reader.ready()) {
                    String line = reader.readLine();
                    if (line == null) continue;
                    line = line.trim();
                    ++lineNumber;
                    if (line.startsWith("/*")) {
                        comment = line.indexOf("*/") == -1;
                        continue;
                    }
                    if (comment && line.indexOf("*/") != -1) {
                        comment = false;
                        continue;
                    }
                    if (!comment && line.startsWith("// @PMD:REVIEWED:")) {
                        String tail = line.substring("// @PMD:REVIEWED:".length());
                        String ruleName = tail.substring(0, tail.indexOf(58));
                        pendingReviews.push(ruleName);
                        findLine = true;
                        continue;
                    }
                    if (comment || !findLine || !StringUtil.isNotEmpty((String)line) || line.startsWith("//")) continue;
                    findLine = false;
                    while (!pendingReviews.empty()) {
                        Review review = new Review();
                        review.ruleName = (String)pendingReviews.pop();
                        review.lineNumber = lineNumber;
                        reviews.add(review);
                    }
                }
            }
            catch (CoreException e) {
                PMDPlugin.getDefault().logError("Core Exception when searching reviewed violations", e);
                IOUtil.closeQuietly(reader);
                break block12;
            }
            catch (IOException e) {
                try {
                    PMDPlugin.getDefault().logError("IO Exception when searching reviewed violations", e);
                    break block12;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    IOUtil.closeQuietly(reader);
                }
            }
            IOUtil.closeQuietly(reader);
        }
        return reviews;
    }

    private MarkerInfo2 getMarkerInfo(RuleViolation violation, String type) throws PropertiesException {
        Rule rule = violation.getRule();
        MarkerInfo2 info = new MarkerInfo2(type, 7);
        info.add("message", violation.getDescription());
        info.add("lineNumber", violation.getBeginLine());
        info.add("line2", violation.getEndLine());
        info.add("rulename", rule.getName());
        info.add("pmd_priority", rule.getPriority().getPriority());
        switch (rule.getPriority().getPriority()) {
            case 1: {
                info.add("priority", 2);
                info.add("severity", this.projectProperties.violationsAsErrors() ? 2 : 1);
                break;
            }
            case 2: {
                if (this.projectProperties.violationsAsErrors()) {
                    info.add("severity", 2);
                    break;
                }
                info.add("severity", 1);
                info.add("priority", 2);
                break;
            }
            case 5: {
                info.add("severity", 0);
                break;
            }
            case 3: {
                info.add("priority", 2);
            }
            default: {
                info.add("severity", 1);
            }
        }
        return info;
    }

    private class Review {
        public String ruleName;
        public int lineNumber;

        private Review() {
        }

        public boolean equals(Object obj) {
            boolean result = false;
            if (obj instanceof Review) {
                Review reviewObj = (Review)obj;
                result = this.ruleName.equals(reviewObj.ruleName) && this.lineNumber == reviewObj.lineNumber;
            }
            return result;
        }

        public int hashCode() {
            return this.ruleName.hashCode() + this.lineNumber * this.lineNumber;
        }
    }
}

