/*
 * Decompiled with CFR 0.152.
 */
package name.herlin.command;

import name.herlin.command.AbstractProcessableCommand;
import name.herlin.command.CommandException;
import name.herlin.command.CommandProcessor;
import name.herlin.command.Timer;
import name.herlin.command.UnsetInputPropertiesException;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import org.apache.log4j.Logger;

public class DefaultCommandProcessor
implements CommandProcessor {
    private static final Logger log = Logger.getLogger(DefaultCommandProcessor.class);

    @Override
    public void processCommand(AbstractProcessableCommand aCommand) throws CommandException {
        log.debug((Object)("Beginning command " + aCommand.getName()));
        if (!aCommand.isReadyToExecute()) {
            throw new UnsetInputPropertiesException();
        }
        Timer timer = new Timer();
        aCommand.execute();
        timer.stop();
        PMDPlugin.getDefault().logInformation("Command " + aCommand.getName() + " excecuted in " + timer.getDuration() + "ms");
        log.debug((Object)("Ending command " + aCommand.getName()));
    }

    @Override
    public void waitCommandToFinish(AbstractProcessableCommand aCommand) throws CommandException {
    }
}

