/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.github.sevntu.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class EitherLogOrThrowCheck
extends Check {
    public static final String MSG_KEY = "either.log.or.throw";
    private String loggerFullyQualifiedClassName = "org.slf4j.Logger";
    private String loggerSimpleClassName = "Logger";
    private List<String> loggingMethodNames = Arrays.asList("error", "warn", "info", "debug");
    private List<String> loggerFieldNames = new LinkedList<String>();
    private boolean hasLoggerClassInImports;
    private static final Pattern PRINT_STACK_TRACE_METHOD_PATTERN = Pattern.compile(".+\\.printStackTrace");
    private DetailAST currentClassDefAst;
    private DetailAST currentMethodDefAst;
    private List<String> currentLocalLoggerVariableNames = new ArrayList<String>();

    public void setLoggerFullyQualifiedClassName(String loggerFullyQualifiedClassName) {
        this.loggerFullyQualifiedClassName = loggerFullyQualifiedClassName;
        this.loggerSimpleClassName = loggerFullyQualifiedClassName;
        int lastDotIndex = this.loggerFullyQualifiedClassName.lastIndexOf(46);
        if (lastDotIndex != -1) {
            this.loggerSimpleClassName = this.loggerFullyQualifiedClassName.substring(lastDotIndex + 1);
        }
    }

    public void setLoggingMethodNames(String[] loggingMethodNames) {
        this.loggingMethodNames = Arrays.asList(loggingMethodNames);
    }

    public int[] getDefaultTokens() {
        return new int[]{30, 14, 96, 10, 9};
    }

    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 30: {
                if (this.hasLoggerClassInImports || !this.isLoggerImport(ast)) break;
                this.hasLoggerClassInImports = true;
                break;
            }
            case 14: {
                if (this.isInnerClass(ast)) break;
                this.currentClassDefAst = ast;
                this.collectLoggerFieldNames(ast);
                break;
            }
            case 9: {
                if (!this.isMethodOfCurrentClass(ast)) break;
                this.currentMethodDefAst = ast;
                this.currentLocalLoggerVariableNames.clear();
                DetailAST parametersAst = this.currentMethodDefAst.findFirstToken(20);
                this.collectLoggersFromParameters(parametersAst);
                break;
            }
            case 10: {
                DetailAST methodDefAst = ast.getParent().getParent();
                if (methodDefAst.getType() != 9 || methodDefAst != this.currentMethodDefAst || !this.isLoggerVariableDefinition(ast)) break;
                this.currentLocalLoggerVariableNames.add(EitherLogOrThrowCheck.getIdentifier(ast));
                break;
            }
            case 96: {
                this.processCatchNode(ast);
                break;
            }
            default: {
                Utils.reportInvalidToken(ast.getType());
            }
        }
    }

    private boolean isLoggerImport(DetailAST importAst) {
        String importIdentifier = FullIdent.createFullIdent((DetailAST)importAst.getFirstChild()).getText();
        return this.loggerFullyQualifiedClassName.equals(importIdentifier);
    }

    private boolean isInnerClass(DetailAST classDefAst) {
        boolean result = false;
        for (DetailAST parentAst = classDefAst.getParent(); parentAst != null; parentAst = parentAst.getParent()) {
            if (parentAst != this.currentClassDefAst) continue;
            result = true;
            break;
        }
        return result;
    }

    private void collectLoggersFromParameters(DetailAST parametersAst) {
        for (DetailAST currentParameterAst = parametersAst.findFirstToken(21); currentParameterAst != null; currentParameterAst = currentParameterAst.getNextSibling()) {
            DetailAST parameterTypeAst = currentParameterAst.findFirstToken(13);
            String className = EitherLogOrThrowCheck.getIdentifier(parameterTypeAst);
            if (className == null || !this.isLoggerClassName(className)) continue;
            this.currentLocalLoggerVariableNames.add(EitherLogOrThrowCheck.getIdentifier(currentParameterAst));
        }
    }

    private boolean isMethodOfCurrentClass(DetailAST methodDefAst) {
        DetailAST classDefAst = methodDefAst.getParent().getParent();
        return classDefAst == this.currentClassDefAst;
    }

    private void collectLoggerFieldNames(DetailAST classDefAst) {
        DetailAST objBlockAst = classDefAst.findFirstToken(6);
        for (DetailAST variableDefAst = objBlockAst.findFirstToken(10); variableDefAst != null; variableDefAst = variableDefAst.getNextSibling()) {
            if (variableDefAst.getType() != 10 || !this.isLoggerVariableDefinition(variableDefAst)) continue;
            this.loggerFieldNames.add(EitherLogOrThrowCheck.getIdentifier(variableDefAst));
        }
    }

    private void processCatchNode(DetailAST catchAst) {
        boolean isLoggingExceptionFound = false;
        int loggingExceptionLineNumber = 0;
        LinkedList<String> exceptionVariableNames = new LinkedList<String>();
        String catchParameterName = EitherLogOrThrowCheck.getCatchParameterName(catchAst);
        DetailAST statementsAst = catchAst.findFirstToken(7);
        block5: for (DetailAST currentStatementAst = statementsAst.getFirstChild(); currentStatementAst != null; currentStatementAst = currentStatementAst.getNextSibling()) {
            switch (currentStatementAst.getType()) {
                case 10: {
                    if (this.isLoggerVariableDefinition(currentStatementAst)) {
                        this.currentLocalLoggerVariableNames.add(EitherLogOrThrowCheck.getIdentifier(currentStatementAst));
                        continue block5;
                    }
                    DetailAST assignAst = currentStatementAst.findFirstToken(80);
                    if (assignAst == null || !EitherLogOrThrowCheck.isInstanceCreationBasedOnException(assignAst.getFirstChild(), catchParameterName)) continue block5;
                    exceptionVariableNames.add(EitherLogOrThrowCheck.getIdentifier(currentStatementAst));
                    continue block5;
                }
                case 28: {
                    if (isLoggingExceptionFound || !this.isLoggingExceptionArgument(currentStatementAst, catchParameterName) && !EitherLogOrThrowCheck.isPrintStackTrace(currentStatementAst, catchParameterName)) continue block5;
                    isLoggingExceptionFound = true;
                    loggingExceptionLineNumber = currentStatementAst.getLineNo();
                    continue block5;
                }
                case 90: {
                    if (!isLoggingExceptionFound) continue block5;
                    exceptionVariableNames.add(catchParameterName);
                    DetailAST thrownExceptionAst = currentStatementAst.getFirstChild();
                    if (!exceptionVariableNames.contains(EitherLogOrThrowCheck.getIdentifier(thrownExceptionAst)) && !EitherLogOrThrowCheck.isInstanceCreationBasedOnException(thrownExceptionAst, catchParameterName)) continue block5;
                    this.log(loggingExceptionLineNumber, MSG_KEY, new Object[0]);
                    continue block5;
                }
            }
        }
    }

    private boolean isLoggerVariableDefinition(DetailAST variableDefAst) {
        DetailAST variableTypeAst = variableDefAst.findFirstToken(13).getFirstChild();
        String variableTypeName = FullIdent.createFullIdent((DetailAST)variableTypeAst).getText();
        return this.isLoggerClassName(variableTypeName);
    }

    private boolean isLoggerClassName(String className) {
        return this.hasLoggerClassInImports && className.equals(this.loggerSimpleClassName) || className.equals(this.loggerFullyQualifiedClassName);
    }

    private static String getCatchParameterName(DetailAST catchAst) {
        DetailAST parameterDefAst = catchAst.findFirstToken(21);
        return EitherLogOrThrowCheck.getIdentifier(parameterDefAst);
    }

    private static String getIdentifier(DetailAST ast) {
        DetailAST identAst;
        String result = null;
        if (ast != null && (identAst = ast.findFirstToken(58)) != null) {
            result = identAst.getText();
        }
        return result;
    }

    private static boolean isInstanceCreationBasedOnException(DetailAST expressionAst, String exceptionArgumentName) {
        DetailAST parametersAst;
        boolean result = false;
        DetailAST literalNewAst = expressionAst.findFirstToken(136);
        if (literalNewAst != null && (parametersAst = literalNewAst.findFirstToken(34)) != null) {
            result = EitherLogOrThrowCheck.containsExceptionParameter(parametersAst, exceptionArgumentName);
        }
        return result;
    }

    private boolean isLoggingExceptionArgument(DetailAST expressionAst, String exceptionVariableName) {
        boolean result = false;
        if (this.isLoggingExpression(expressionAst)) {
            DetailAST loggingMethodCallAst = expressionAst.getFirstChild();
            DetailAST loggerParametersAst = loggingMethodCallAst.findFirstToken(34);
            result = EitherLogOrThrowCheck.containsExceptionParameter(loggerParametersAst, exceptionVariableName);
        }
        return result;
    }

    private boolean isLoggingExpression(DetailAST expressionAst) {
        boolean result = false;
        DetailAST methodCallAst = expressionAst.getFirstChild();
        if (methodCallAst.getType() == 27 && EitherLogOrThrowCheck.hasChildToken(methodCallAst, 59)) {
            DetailAST dotAst = methodCallAst.getFirstChild();
            DetailAST loggerObjectAst = dotAst.getFirstChild();
            DetailAST invokedMethodAst = loggerObjectAst.getNextSibling();
            String loggerObjectIdentifier = FullIdent.createFullIdent((DetailAST)loggerObjectAst).getText();
            String invokedMethodIdentifier = invokedMethodAst.getText();
            result = (this.currentLocalLoggerVariableNames.contains(loggerObjectIdentifier) || this.loggerFieldNames.contains(loggerObjectIdentifier)) && this.loggingMethodNames.contains(invokedMethodIdentifier);
        }
        return result;
    }

    private static boolean containsExceptionParameter(DetailAST parametersAst, String exceptionVariableName) {
        boolean result = false;
        for (DetailAST parameterAst = parametersAst.getFirstChild(); parameterAst != null; parameterAst = parameterAst.getNextSibling()) {
            if (exceptionVariableName.equals(EitherLogOrThrowCheck.getIdentifier(parameterAst))) {
                result = true;
                break;
            }
            DetailAST methodCallAst = parameterAst.getFirstChild();
            if (!EitherLogOrThrowCheck.isInstanceMethodCall(exceptionVariableName, methodCallAst)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean isPrintStackTrace(DetailAST expressionAst, String exceptionVariableName) {
        String methodCallStr;
        boolean result = false;
        DetailAST methodCallAst = expressionAst.getFirstChild();
        if (EitherLogOrThrowCheck.isInstanceMethodCall(exceptionVariableName, methodCallAst) && PRINT_STACK_TRACE_METHOD_PATTERN.matcher(methodCallStr = FullIdent.createFullIdentBelow((DetailAST)methodCallAst).getText()).matches()) {
            result = true;
        }
        return result;
    }

    private static boolean isInstanceMethodCall(String usedInstanseName, DetailAST methodCallAst) {
        String usedObjectName;
        String methodCallIdent;
        int firstDotIndex;
        boolean result = false;
        if (methodCallAst != null && methodCallAst.getType() == 27 && (firstDotIndex = (methodCallIdent = FullIdent.createFullIdentBelow((DetailAST)methodCallAst).getText()).indexOf(46)) != -1 && (usedObjectName = methodCallIdent.substring(0, firstDotIndex)).equals(usedInstanseName)) {
            result = true;
        }
        return result;
    }

    private static boolean hasChildToken(DetailAST ast, int tokenType) {
        return ast.findFirstToken(tokenType) != null;
    }
}

