/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.metadata.internal.model;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.ide.eclipse.beans.core.metadata.internal.model.BeanMetadataHolder;
import org.springframework.ide.eclipse.beans.core.metadata.internal.model.BeanMetadataPersistence;
import org.springframework.ide.eclipse.beans.core.metadata.internal.model.BeanPropertyDataHolder;
import org.springframework.ide.eclipse.beans.core.metadata.model.IBeanMetadata;
import org.springframework.ide.eclipse.beans.core.metadata.model.IBeanMetadataModel;
import org.springframework.ide.eclipse.beans.core.metadata.model.IMethodMetadata;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.core.SpringCore;

public class BeanMetadataModel
implements IBeanMetadataModel {
    public static final String DEBUG_OPTION = "org.springframework.ide.eclipse.beans.core/model/metadata/debug";
    public static final boolean DEBUG = SpringCore.isDebug((String)"org.springframework.ide.eclipse.beans.core/model/metadata/debug");
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    private Map<String, BeanMetadataHolder> beanMetadata = new ConcurrentHashMap<String, BeanMetadataHolder>();
    private Map<String, BeanPropertyDataHolder> beanPropertyData = new ConcurrentHashMap<String, BeanPropertyDataHolder>();

    @Override
    public Set<IBeanMetadata> getBeanMetadata(IBean bean) {
        try {
            this.r.lock();
            if (this.beanMetadata.containsKey(bean.getElementID())) {
                Set<IBeanMetadata> set = this.beanMetadata.get(bean.getElementID()).getBeanMetaData();
                return set;
            }
            Set<IBeanMetadata> set = Collections.emptySet();
            return set;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public void setBeanMetadata(IBean bean, Set<IBeanMetadata> bMetaData, Set<IMethodMetadata> methodMetaData) {
        try {
            this.w.lock();
            BeanMetadataHolder holder = new BeanMetadataHolder();
            holder.setElemenetId(bean.getElementID());
            holder.setBeanMetaData(bMetaData);
            holder.setMethodMetaData(methodMetaData);
            holder.setLastModified(System.currentTimeMillis());
            this.beanMetadata.put(bean.getElementID(), holder);
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public void clearBeanMetadata(IBean bean) {
        try {
            this.w.lock();
            this.beanMetadata.remove(bean.getElementID());
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public Set<IBeanProperty> getBeanProperties(IBean bean) {
        try {
            this.r.lock();
            if (this.beanPropertyData.containsKey(bean.getElementID())) {
                Set<IBeanProperty> set = this.beanPropertyData.get(bean.getElementID()).getBeanProperties();
                return set;
            }
            Set<IBeanProperty> set = Collections.emptySet();
            return set;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public void setBeanProperties(IBean bean, Set<IBeanProperty> beanProperties) {
        try {
            this.w.lock();
            BeanPropertyDataHolder holder = new BeanPropertyDataHolder();
            holder.setElemenetId(bean.getElementID());
            holder.setBeanProperties(beanProperties);
            holder.setLastModified(System.currentTimeMillis());
            this.beanPropertyData.put(bean.getElementID(), holder);
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public void clearBeanProperties(IBean bean) {
        try {
            this.w.lock();
            this.beanPropertyData.remove(bean.getElementID());
        }
        finally {
            this.w.unlock();
        }
    }

    public void start() {
        Map<String, BeanMetadataHolder> storedBeanMetadata = BeanMetadataPersistence.loadMetadata();
        Map<String, BeanPropertyDataHolder> storedProperties = BeanMetadataPersistence.loadProperties();
        try {
            try {
                this.w.lock();
                this.beanMetadata = storedBeanMetadata;
                this.beanPropertyData = storedProperties;
            }
            catch (Exception exception) {
                this.beanMetadata = new ConcurrentHashMap<String, BeanMetadataHolder>();
                this.beanPropertyData = new ConcurrentHashMap<String, BeanPropertyDataHolder>();
                this.w.unlock();
            }
        }
        finally {
            this.w.unlock();
        }
    }

    public void stop() {
        BeanMetadataPersistence.storeMetadata(this.beanMetadata);
        BeanMetadataPersistence.storeProperties(this.beanPropertyData);
    }
}

