/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.yaml.completions;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.completions.YamlDocument;

public class IndentUtil {
    public static final int INDENT_BY = 2;
    public final String NEWLINE;

    public IndentUtil(String newline) {
        this.NEWLINE = newline;
    }

    public IndentUtil(YamlDocument doc) {
        IDocument d = doc.getDocument();
        this.NEWLINE = d instanceof IDocumentExtension4 ? ((IDocumentExtension4)d).getDefaultLineDelimiter() : "\n";
    }

    public static int minIndent(int a, int b) {
        if (a == -1) {
            return b;
        }
        if (b == -1) {
            return a;
        }
        return Math.min(a, b);
    }

    public static void addIndent(int indent, StringBuilder buf) {
        int i = 0;
        while (i < indent) {
            buf.append(' ');
            ++i;
        }
    }

    public void addNewlineWithIndent(int indent, StringBuilder buf) {
        buf.append(this.NEWLINE);
        IndentUtil.addIndent(indent, buf);
    }

    public String newlineWithIndent(int indent) {
        StringBuilder buf = new StringBuilder();
        this.addNewlineWithIndent(indent, buf);
        return buf.toString();
    }

    public String applyIndentation(String text, int indentBy) {
        return text.replaceAll("\\n", this.newlineWithIndent(indentBy));
    }

    public static int addToOffset(int offset, int indent) {
        if (indent == -1) {
            return offset;
        }
        return offset + indent;
    }
}

