/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.data.jdt.core;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.jdt.core.compiler.ReconcileContext;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.data.jdt.core.InvalidDerivedQueryProblem;
import org.springframework.ide.eclipse.data.jdt.core.RepositoryInformation;
import org.springsource.ide.eclipse.commons.core.SpringCoreUtils;

public class SpringDataCompilationParticipant
extends CompilationParticipant {
    public boolean isActive(IJavaProject project) {
        return SpringCoreUtils.isSpringProject((IResource)project.getResource());
    }

    public void reconcile(ReconcileContext context) {
        try {
            CompilationUnit compilationUnit = context.getAST3();
            ITypeRoot typeRoot = compilationUnit.getTypeRoot();
            IType type = typeRoot.findPrimaryType();
            if (type == null || !type.isInterface() || type.isAnnotation()) {
                super.reconcile(context);
                return;
            }
            if (!RepositoryInformation.isSpringDataRepository(type)) {
                super.reconcile(context);
                return;
            }
            RepositoryInformation information = new RepositoryInformation(type);
            Class<?> domainClass = information.getManagedDomainClass();
            if (domainClass == null) {
                super.reconcile(context);
                return;
            }
            ArrayList<InvalidDerivedQueryProblem> problems = new ArrayList<InvalidDerivedQueryProblem>();
            for (IMethod method : information.getMethodsToValidate()) {
                String methodName = method.getElementName();
                try {
                    new PartTree(methodName, domainClass);
                }
                catch (PropertyReferenceException e) {
                    problems.add(new InvalidDerivedQueryProblem(method, e.getMessage()));
                }
            }
            context.putProblems("org.eclipse.jdt.core.problem", problems.toArray(new CategorizedProblem[problems.size()]));
        }
        catch (JavaModelException e) {
            SpringCore.log((Throwable)e);
        }
        catch (Exception e) {
            SpringCore.log((Throwable)e);
        }
        catch (Error e) {
            SpringCore.log((Throwable)e);
        }
        super.reconcile(context);
    }
}

