/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.data.beans.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansTypedString;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.namespaces.DefaultNamespaceLabelProvider;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.ide.eclipse.data.SpringDataUtils;

public class RepositoriesNamespaceLabelProvider
extends DefaultNamespaceLabelProvider {
    private static final Map<String, Object> DEFAULTS = new HashMap<String, Object>();

    static {
        DEFAULTS.put("queryLookupStrategy", QueryLookupStrategy.Key.CREATE_IF_NOT_FOUND);
    }

    public String getText(ISourceModelElement element, IModelElement context, boolean isDecorating) {
        if (element instanceof IBean) {
            return SpringDataUtils.asText((IBean)element);
        }
        if (element instanceof IBeansTypedString) {
            String name = element.getElementParent().getElementName();
            String text = super.getText(element, context, isDecorating);
            boolean hasDefault = DEFAULTS.containsKey(name);
            boolean isNull = "null".equals(text);
            return hasDefault && isNull ? DEFAULTS.get(name).toString() : text;
        }
        return super.getText(element, context, isDecorating);
    }

    public Image getImage(ISourceModelElement element, IModelElement context, boolean isDecorating) {
        if (element instanceof IBean) {
            return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.bean_obj.gif");
        }
        return super.getImage(element, context, isDecorating);
    }
}

