/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class BadgedImageDescriptor
extends CompositeImageDescriptor {
    private final ImageData base;
    private final ImageData badge;
    private final boolean top;
    private final boolean left;

    public BadgedImageDescriptor(ImageDescriptor descriptor, ImageDescriptor badgeDescriptor, boolean top, boolean left) {
        this.top = top;
        this.left = left;
        this.base = this.getImageData(descriptor);
        this.badge = this.getImageData(badgeDescriptor);
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.base, 0, 0);
        int x = 0;
        int y = 0;
        if (!this.left) {
            x = this.base.width - this.badge.width;
        }
        if (!this.top) {
            y = this.base.height - this.badge.height;
        }
        this.drawImage(this.badge, x, y);
    }

    private ImageData getImageData(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        if (data == null) {
            data = DEFAULT_IMAGE_DATA;
        }
        return data;
    }

    protected Point getSize() {
        return new Point(this.base.width, this.base.height);
    }
}

