/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.ui.notifications;

import com.atlassian.connector.eclipse.internal.bamboo.core.BambooCorePlugin;
import com.atlassian.connector.eclipse.internal.bamboo.core.BambooUtil;
import com.atlassian.connector.eclipse.internal.bamboo.core.BuildsChangedEvent;
import com.atlassian.connector.eclipse.internal.bamboo.core.BuildsChangedListener;
import com.atlassian.connector.eclipse.internal.bamboo.ui.notifications.BambooNotification;
import com.atlassian.theplugin.commons.bamboo.BambooBuild;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.mylyn.commons.notifications.ui.AbstractUiNotification;
import org.eclipse.mylyn.internal.tasks.ui.ITaskListNotificationProvider;
import org.eclipse.mylyn.internal.tasks.ui.TaskListNotificationManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.TaskRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BambooNotificationProvider
implements ITaskListNotificationProvider,
BuildsChangedListener {
    private final Set<BambooNotification> notifications;

    public BambooNotificationProvider() {
        BambooCorePlugin.getBuildPlanManager().addBuildsChangedListener((BuildsChangedListener)this);
        this.notifications = new HashSet<BambooNotification>();
        TaskListNotificationManager taskListNotificationManager = TasksUiPlugin.getTaskListNotificationManager();
        taskListNotificationManager.addNotificationProvider((ITaskListNotificationProvider)this);
    }

    public void dispose() {
        BambooCorePlugin.getBuildPlanManager().removeBuildsChangedListener((BuildsChangedListener)this);
    }

    public Set<AbstractUiNotification> getNotifications() {
        HashSet<AbstractUiNotification> toReturn = new HashSet<AbstractUiNotification>(this.notifications);
        this.notifications.clear();
        return toReturn;
    }

    public void buildsUpdated(BuildsChangedEvent event) {
        BambooUtil.runActionForChangedBuild((BuildsChangedEvent)event, (BambooUtil.BuildChangeAction)new BambooUtil.BuildChangeAction(){

            public void run(BambooBuild build, TaskRepository repository) {
                BambooNotificationProvider.this.notifications.add(new BambooNotification(build, repository, BambooNotification.CHANGE.CHANGED));
            }
        });
    }
}

