/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.navigator.actions;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanAlias;
import org.springframework.ide.eclipse.beans.core.model.IBeanReference;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.ui.BeansUIUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.ui.navigator.actions.AbstractNavigatorAction;

public class OpenReferenceAction
extends AbstractNavigatorAction {
    private IBean bean;

    public OpenReferenceAction(ICommonActionExtensionSite site) {
        super(site);
        this.setText("Open &Reference");
    }

    public boolean isEnabled(IStructuredSelection selection) {
        if (selection.size() == 1) {
            Object element = selection.getFirstElement();
            String beanName = null;
            IBeansConfig config = null;
            if (element instanceof IBeanAlias) {
                IBeanAlias alias = (IBeanAlias)element;
                beanName = alias.getBeanName();
                config = BeansModelUtils.getConfig((IModelElement)alias);
            } else if (element instanceof IBeanReference) {
                IBeanReference reference = (IBeanReference)element;
                beanName = reference.getBeanName();
                config = BeansModelUtils.getConfig((IModelElement)reference);
            }
            if (beanName != null) {
                IModelElement context;
                this.bean = selection instanceof ITreeSelection ? ((context = BeansUIUtils.getContext((ITreeSelection)selection)) instanceof IBeansConfig ? BeansModelUtils.getBeanWithConfigSets((String)beanName, (IBeansConfig)((IBeansConfig)context)) : BeansModelUtils.getBean((String)beanName, (IModelElement)context)) : config.getBean(beanName);
                if (this.bean != null) {
                    return true;
                }
            }
        }
        return false;
    }

    public final void run() {
        BeansUIUtils.openInEditor((IResourceModelElement)this.bean);
    }
}

