/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.ITextEditor;
import org.springframework.ide.eclipse.beans.ui.actions.AbstractBeansConfigEditorAction;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.ui.SpringUIUtils;

public class OpenJavaTypeAction
extends AbstractBeansConfigEditorAction {
    public void run(IAction action) {
        IType type;
        String className;
        if (this.getTextEditor() != null && this.getConfigFile() != null && (className = this.guessType(this.getTextEditor())) != null && className.length() > 0 && (type = JdtUtils.getJavaType((IProject)this.getConfigFile().getProject(), (String)className)) != null) {
            SpringUIUtils.openInEditor((IJavaElement)type);
        }
    }

    private String guessType(ITextEditor editor) {
        String selectedText = SpringUIUtils.getSelectedText((ITextEditor)editor);
        if (!this.isJavaType(selectedText)) {
            int caretPosition = SpringUIUtils.getCaretOffset((ITextEditor)editor);
            IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            try {
                IRegion line = doc.getLineInformation(doc.getLineOfOffset(caretPosition));
                String lineText = doc.get(line.getOffset(), line.getLength());
                selectedText = this.findJavaType(lineText, caretPosition - line.getOffset());
            }
            catch (BadLocationException badLocationException) {
                selectedText = null;
            }
        }
        return selectedText;
    }

    private boolean isJavaType(String type) {
        if (type == null || type.length() == 0) {
            return false;
        }
        if (Character.isJavaIdentifierStart(type.charAt(0))) {
            int i = 1;
            while (i < type.length()) {
                char c = type.charAt(i);
                if (!Character.isJavaIdentifierPart(c) && c != '.') {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private String findJavaType(String line, int offset) {
        int start = offset;
        while (start > 0) {
            char c = line.charAt(start - 1);
            if (!Character.isJavaIdentifierPart(c) && c != '.') break;
            --start;
        }
        int length = offset - start;
        int max = line.length();
        while (offset < max) {
            char c = line.charAt(offset);
            if (!Character.isJavaIdentifierPart(c) && c != '.') break;
            ++offset;
            ++length;
        }
        if (length == max) {
            return line;
        }
        if (length > 0) {
            return line.substring(start, start + length);
        }
        return null;
    }
}

