/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.internal.bestpractices.springiderules;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.core.model.IModelElement;

public class AllBeansCache {
    private final Map<IModelElement, IBean[]> allBeansCache = new ConcurrentHashMap<IModelElement, IBean[]>();

    public IBean[] getAllBeans(IModelElement rootElement) {
        IBean[] allBeans = this.allBeansCache.get(rootElement);
        if (allBeans == null) {
            Set beans = BeansModelUtils.getBeans((IModelElement)rootElement);
            allBeans = beans.toArray(new IBean[beans.size()]);
            this.allBeansCache.put(rootElement, allBeans);
        }
        return allBeans;
    }
}

