/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.internal.bestpractices.quickfix;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.cleanup.CleanupProcessorXML;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansTypedString;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.internal.bestpractices.quickfix.XmlQuickFixUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JndiObjectFactorySyntaxConverter {
    private static final String JEE_NAMESPACE_URL_ATTRIBUTE_NAME = "xmlns:jee";
    private static final String JEE_NAMESPACE_URL = "http://www.springframework.org/schema/jee";
    private static final String SCHEMA_LOCATION_ATTRIBUTE_NAME = "xsi:schemaLocation";
    private static final String SCHEMA_LOCATION = "http://www.springframework.org/schema/jee http://www.springframework.org/schema/jee/spring-jee.xsd";
    private static final String NAMESPACE_JNDI_ELEMENT_NAME = "jee:jndi-lookup";
    private static final String ID_ATTRIBUTE_NAME = "id";

    public void convert(IMarker marker) throws CoreException {
        IStructuredModel model = null;
        try {
            model = XmlQuickFixUtil.getModel(marker);
            Element legacyXmlElement = XmlQuickFixUtil.getMarkerElement(model, marker);
            this.insertNamespaceDeclaration(model);
            IBean jndiObjectFactoryBean = (IBean)BeansCorePlugin.getModel().getElement(marker.getAttribute("elementId", ""));
            Element namespaceJndiElement = this.createNamespaceSyntaxXmlElement(jndiObjectFactoryBean, NAMESPACE_JNDI_ELEMENT_NAME, legacyXmlElement.getOwnerDocument());
            legacyXmlElement.getParentNode().insertBefore(namespaceJndiElement, legacyXmlElement);
            FormatProcessorXML formatProcessor = new FormatProcessorXML();
            CleanupProcessorXML cleanupProcessor = new CleanupProcessorXML();
            cleanupProcessor.getCleanupPreferences().setCompressEmptyElementTags(true);
            formatProcessor.formatNode((Node)namespaceJndiElement);
            cleanupProcessor.cleanupNode((Node)namespaceJndiElement);
            legacyXmlElement.getParentNode().removeChild(legacyXmlElement);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    private Element createNamespaceSyntaxXmlElement(IBean bean, String elementName, Document document) {
        Element jndiObjectFactoryElement = document.createElement(elementName);
        jndiObjectFactoryElement.setAttribute(ID_ATTRIBUTE_NAME, bean.getElementName());
        for (IBeanProperty currProperty : bean.getProperties()) {
            Object value = currProperty.getValue();
            if (!(value instanceof BeansTypedString)) continue;
            BeansTypedString propertyValue = (BeansTypedString)value;
            String propertyName = currProperty.getElementName();
            jndiObjectFactoryElement.setAttribute(this.toHyphenFormat(propertyName), propertyValue.getString());
        }
        return jndiObjectFactoryElement;
    }

    private Node insertNamespaceDeclaration(IStructuredModel model) {
        IStructuredDocumentRegion beansRegion = model.getStructuredDocument().getFirstStructuredDocumentRegion().getNext().getNext();
        Element beansElement = (Element)model.getIndexedRegion(beansRegion.getStartOffset());
        beansElement.setAttribute(JEE_NAMESPACE_URL_ATTRIBUTE_NAME, JEE_NAMESPACE_URL);
        String schemaLocation = beansElement.getAttribute(SCHEMA_LOCATION_ATTRIBUTE_NAME);
        if (schemaLocation != null) {
            if (schemaLocation.indexOf(SCHEMA_LOCATION) == -1) {
                schemaLocation = String.valueOf(schemaLocation) + " \n\t\thttp://www.springframework.org/schema/jee http://www.springframework.org/schema/jee/spring-jee.xsd";
                beansElement.setAttribute(SCHEMA_LOCATION_ATTRIBUTE_NAME, schemaLocation);
            }
        } else {
            beansElement.setAttribute(SCHEMA_LOCATION_ATTRIBUTE_NAME, SCHEMA_LOCATION);
        }
        return beansElement;
    }

    private String toHyphenFormat(String camelFormat) {
        String hyphenFormat = camelFormat.replaceAll("[A-Z]", "-$0");
        hyphenFormat = hyphenFormat.toLowerCase();
        return hyphenFormat;
    }
}

