/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.internal.bestpractices.quickfix;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.cleanup.CleanupProcessorXML;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart;
import org.springframework.ide.eclipse.internal.bestpractices.quickfix.XmlQuickFixUtil;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class CreateRequiredMethodMarkerResolution
implements IMarkerResolution2 {
    private static final String MESSAGE_ATTRIBUTE_KEY = "message";
    private String property = "";
    private String bean = "";

    public CreateRequiredMethodMarkerResolution(IMarker marker) {
        String markerMessage = marker.getAttribute(MESSAGE_ATTRIBUTE_KEY, "");
        this.property = this.extractQuotedString("Property '", markerMessage);
        this.bean = this.extractQuotedString("bean '", markerMessage);
    }

    private String extractQuotedString(String startTag, String message) {
        int startPos = message.indexOf(startTag) + startTag.length();
        int endPos = message.indexOf("'", startPos);
        return message.substring(startPos, endPos);
    }

    public String getDescription() {
        return "Create property '" + this.property + "' in bean '" + this.bean + "'";
    }

    public Image getImage() {
        return null;
    }

    public String getLabel() {
        return "Create property '" + this.property + "' in bean '" + this.bean + "'";
    }

    public void run(IMarker marker) {
        IStructuredModel model = null;
        Element beanElement = null;
        try {
            try {
                model = XmlQuickFixUtil.getModel(marker);
                beanElement = XmlQuickFixUtil.getMarkerElement(model, marker);
                if (model != null && beanElement != null) {
                    Document document = beanElement.getOwnerDocument();
                    Text spacerNode = document.createTextNode("\n");
                    beanElement.appendChild(spacerNode);
                    Element newBeanProperty = document.createElement("property");
                    newBeanProperty.setAttribute("name", this.property);
                    newBeanProperty.setAttribute("value", "");
                    newBeanProperty = (Element)beanElement.appendChild(newBeanProperty);
                    spacerNode = document.createTextNode("\n\n");
                    beanElement.appendChild(spacerNode);
                    FormatProcessorXML formatProcessor = new FormatProcessorXML();
                    formatProcessor.formatNode((Node)newBeanProperty);
                    IEditorPart editor = XmlQuickFixUtil.getMarkedEditor(marker);
                    this.setCursorPositionToPropertyValue((XMLMultiPageEditorPart)editor, (ElementImpl)newBeanProperty);
                    CleanupProcessorXML cleanupProcessor = new CleanupProcessorXML();
                    cleanupProcessor.getCleanupPreferences().setCompressEmptyElementTags(true);
                    cleanupProcessor.cleanupNode((Node)newBeanProperty);
                    XmlQuickFixUtil.saveMarkedFile(marker);
                }
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)e.getStatus());
                if (model != null) {
                    model.releaseFromEdit();
                }
            }
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    private void setCursorPositionToPropertyValue(XMLMultiPageEditorPart xmlEditor, ElementImpl propertyElement) {
        IEditorPart[] editorParts;
        IEditorPart[] iEditorPartArray = editorParts = xmlEditor.findEditors(xmlEditor.getEditorInput());
        int n = editorParts.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorPart currEditorPart = iEditorPartArray[n2];
            if (currEditorPart instanceof StructuredTextEditor) {
                String valueAttributeStartString;
                StructuredTextEditor structuredTextEditor = (StructuredTextEditor)currEditorPart;
                int propertyElementStartOffset = propertyElement.getStartOffset();
                String propertyElementTextContent = propertyElement.getStartStructuredDocumentRegion().getFullText();
                int valueAttributeStartIndex = propertyElementTextContent.indexOf(valueAttributeStartString = "value=\"") + valueAttributeStartString.length();
                if (valueAttributeStartIndex > 0) {
                    int documentOffset = propertyElementStartOffset + valueAttributeStartIndex;
                    structuredTextEditor.selectAndReveal(documentOffset, 0);
                    currEditorPart.setFocus();
                }
            }
            ++n2;
        }
    }
}

