/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.AnimatedImageBinding;

public class AnimatedImageThread
extends Thread {
    List<AnimatedImageBinding> bindings = new ArrayList<AnimatedImageBinding>();

    public void addBinding(AnimatedImageBinding binding) {
        this.bindings.add(binding);
    }

    @Override
    public void run() {
        if (this.bindings.isEmpty()) {
            return;
        }
        long time = System.currentTimeMillis();
        for (AnimatedImageBinding binding : this.bindings) {
            binding.init(time);
        }
        while (!this.bindings.get(0).isDisposed()) {
            long minTime = System.currentTimeMillis() + 1000000L;
            for (AnimatedImageBinding binding : this.bindings) {
                if (binding.getNextTime() >= minTime) continue;
                minTime = binding.getNextTime();
            }
            time = System.currentTimeMillis();
            if (minTime > time) {
                try {
                    Thread.sleep(minTime - time + 1L);
                    time = System.currentTimeMillis();
                }
                catch (InterruptedException interruptedException) {}
            }
            boolean redraw = false;
            for (AnimatedImageBinding binding : this.bindings) {
                binding.setTime(time);
                if (!binding.isReadyToRedraw()) continue;
                redraw = true;
            }
            if (!redraw) continue;
            this.redraw();
        }
        return;
    }

    void redraw() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (AnimatedImageBinding binding : AnimatedImageThread.this.bindings) {
                    binding.redraw();
                }
            }
        });
    }
}

