/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.core;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.internal.text.html.HTML2TextReader;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceTable;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.osgi.framework.Version;
import org.springframework.ide.eclipse.beans.ui.namespaces.INamespaceDefinition;
import org.springframework.ide.eclipse.beans.ui.namespaces.NamespaceUtils;
import org.springframework.ide.eclipse.config.core.contentassist.Messages;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ConfigCoreUtils {
    public static String ATTR_DEFAULT_NAMESPACE = "xmlns";
    public static String ATTR_NAMESPACE_PREFIX = "xmlns:";
    public static String ATTR_SCHEMA_LOCATION = "xsi:schemaLocation";
    private static final Pattern VERSION_PATTERN = Pattern.compile(".*-([0-9,.]*)\\.xsd");

    public static String getDefaultNamespaceUri(IDOMDocument doc) {
        Element root;
        if (doc != null && (root = doc.getDocumentElement()) != null) {
            NamedNodeMap attrs = root.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                Node item = attrs.item(i);
                String itemName = item.getLocalName();
                if (itemName.equals(ATTR_DEFAULT_NAMESPACE)) {
                    return item.getNodeValue();
                }
                ++i;
            }
        }
        return null;
    }

    public static String getPrefixForNamespaceUri(IDOMDocument doc, String namespaceUri) {
        if (doc != null && namespaceUri != null) {
            NamespaceTable table = new NamespaceTable((Document)doc);
            Element elem = doc.getDocumentElement();
            table.addElementLineage(elem);
            return table.getPrefixForURI(namespaceUri);
        }
        return null;
    }

    public static Version getSchemaVersion(IDOMDocument doc, String namespaceUri) {
        String versLocation = ConfigCoreUtils.getSelectedSchemaLocation(doc, namespaceUri);
        Matcher matcher = VERSION_PATTERN.matcher(versLocation);
        if (matcher.matches()) {
            return new Version(matcher.group(1));
        }
        List defs = NamespaceUtils.getNamespaceDefinitions();
        for (INamespaceDefinition def : defs) {
            Version version = Version.emptyVersion;
            if (!namespaceUri.equals(def.getNamespaceURI())) continue;
            Version tempVersion = Version.emptyVersion;
            for (String location : def.getSchemaLocations()) {
                matcher = VERSION_PATTERN.matcher(location);
                if (matcher.matches()) {
                    tempVersion = new Version(matcher.group(1));
                }
                if (tempVersion.compareTo(version) < 0) continue;
                version = tempVersion;
            }
            return version;
        }
        return Version.emptyVersion;
    }

    public static String getSelectedSchemaLocation(IDOMDocument doc, String namespaceUri) {
        List<String> schemaInfo = ConfigCoreUtils.parseSchemaLocationAttr(doc);
        if (schemaInfo != null) {
            Iterator<String> iter = schemaInfo.iterator();
            while (iter.hasNext()) {
                String currSchema = iter.next();
                if (!currSchema.equals(namespaceUri) || !iter.hasNext()) continue;
                return iter.next();
            }
        }
        return "";
    }

    public static List<String> parseSchemaLocationAttr(IDOMDocument doc) {
        String schemaLocationValue;
        Element root;
        if (doc != null && (root = doc.getDocumentElement()) != null && (schemaLocationValue = root.getAttribute(ATTR_SCHEMA_LOCATION)) != null) {
            schemaLocationValue = schemaLocationValue.replaceAll("\\n|\\t|\\r", " ");
            schemaLocationValue = schemaLocationValue.replaceAll(" +", " ");
            schemaLocationValue = schemaLocationValue.trim();
            return Arrays.asList(schemaLocationValue.split(" "));
        }
        return null;
    }

    public static String stripTags(String html) {
        if (html != null) {
            try {
                StringReader reader = new StringReader(html);
                HTML2TextReader parser = new HTML2TextReader((Reader)reader, null);
                return parser.getString().trim();
            }
            catch (IOException e) {
                StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.config.core", Messages.XmlBackedContentProposalProvider_ERROR_STRIP_TAGS, (Throwable)e));
            }
        }
        return html;
    }
}

