/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.internal.configurator.server;

import java.io.File;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IServer;
import org.springsource.ide.eclipse.commons.configurator.ConfigurableExtension;
import org.springsource.ide.eclipse.commons.configurator.ServerHandler;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.springsource.ide.eclipse.commons.internal.configurator.server.ServerDescriptor;

public class ConfigurableServerExtension
extends ConfigurableExtension {
    private static final String ID_SERVERS_VIEW = "org.eclipse.wst.server.ui.ServersView";
    private final ServerDescriptor descriptor;
    private final File runtimeLocation;

    public ConfigurableServerExtension(ServerDescriptor descriptor, File runtimeLocation) {
        this(descriptor, runtimeLocation, runtimeLocation.getName());
    }

    public ConfigurableServerExtension(ServerDescriptor descriptor, File runtimeLocation, String id) {
        super(id);
        Assert.isNotNull((Object)descriptor);
        this.descriptor = descriptor;
        this.runtimeLocation = runtimeLocation;
        this.setLabel(descriptor.getServerName());
        if (runtimeLocation != null) {
            this.setLocation(runtimeLocation.getAbsolutePath());
        }
        this.setConfigured(this.getServer() != null);
    }

    @Override
    public IStatus configure(IProgressMonitor monitor) {
        ServerHandler handler = this.createServerHandler();
        try {
            handler.createServer(monitor, ServerHandler.ALWAYS_OVERWRITE, this.descriptor.getCallback());
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.springsource.ide.eclipse.commons.configurator", "The server could not be created.", (Throwable)e);
            StatusHandler.log((IStatus)status);
            return status;
        }
        return new Status(0, "org.springsource.ide.eclipse.commons.configurator", NLS.bind((String)"A server with the name {0} has been added to the Servers view.", (Object)this.descriptor.getServerName()));
    }

    @Override
    public String getBundleId() {
        return this.descriptor.getBundleId();
    }

    public ServerDescriptor getDescriptor() {
        return this.descriptor;
    }

    public IServer getServer() {
        return this.createServerHandler().getExistingServer();
    }

    @Override
    public void postConfiguration(IStatus result) {
        IWorkbenchWindow window;
        if (result.isOK() && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            try {
                window.getActivePage().showView(ID_SERVERS_VIEW);
            }
            catch (PartInitException partInitException) {}
        }
    }

    @Override
    public IStatus unConfigure(IProgressMonitor monitor) {
        ServerHandler handler = this.createServerHandler();
        try {
            handler.deleteServerAndRuntime(monitor);
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.springsource.ide.eclipse.commons.configurator", "The server could not be removed.", (Throwable)e);
            StatusHandler.log((IStatus)status);
            return status;
        }
        return Status.OK_STATUS;
    }

    private ServerHandler createServerHandler() {
        return new ServerHandler(this.descriptor, this.runtimeLocation);
    }
}

