/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.wizard;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SearchPattern;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ICommandParameterDescriptor;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.IFrameworkCommandDescriptor;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.swt.ViewerSearchPart;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.wizard.AbstractGenericWizardPage;

public class GenericWizardCommandListPage
extends AbstractGenericWizardPage {
    private TableViewer commandTableViewer;
    private Text descriptionControl;
    private IFrameworkCommandDescriptor selectedCommandDescriptor;
    private static final String DESCRIPTION_INDENT = "   ";
    private Set<IFrameworkCommandDescriptor> commandDescriptors = new HashSet<IFrameworkCommandDescriptor>();
    public static final String PAGE_MESSAGE = "Select a command from the list of commands below. Only one command can be configured for execution at a time";
    public static final String SELECT_COMMAND_LABEL = "&Select a command to configure and execute:";

    public GenericWizardCommandListPage(String pageName) {
        super(pageName);
        this.setTitle("Select Command");
    }

    protected int getViewerConfiguration() {
        return 68356;
    }

    @Override
    protected Composite createPageArea(Composite parent) {
        Composite listSection = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(listSection);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)listSection);
        this.createCommandTableArea(listSection);
        this.createDescriptionArea(listSection);
        this.refreshDescriptionArea();
        return listSection;
    }

    public synchronized boolean containsCommandDescriptor(IFrameworkCommandDescriptor command) {
        if (this.commandDescriptors != null) {
            return this.commandDescriptors.contains(command);
        }
        return false;
    }

    public synchronized IFrameworkCommandDescriptor addCommandDescriptor(IFrameworkCommandDescriptor command) {
        if (command == null) {
            return null;
        }
        if (!this.commandDescriptors.contains(command)) {
            this.commandDescriptors.add(command);
            if (this.commandTableViewer != null && !this.commandTableViewer.getTable().isDisposed()) {
                this.commandTableViewer.add((Object)command);
            }
            return command;
        }
        return null;
    }

    public synchronized boolean selectCommandInViewer(IFrameworkCommandDescriptor command) {
        return this.selectCommand(command);
    }

    private boolean selectCommand(IFrameworkCommandDescriptor command) {
        if (command != null && !this.commandDescriptors.contains(command)) {
            return false;
        }
        this.selectedCommandDescriptor = command;
        if (this.commandTableViewer != null) {
            if (command == null) {
                this.commandTableViewer.getTable().deselectAll();
                this.selectionChanged(null);
            } else {
                this.commandTableViewer.setSelection((ISelection)new StructuredSelection((Object)command), true);
            }
            return true;
        }
        return false;
    }

    protected ViewerSearchPart createSearchControl(Composite parent) {
        ViewerSearchPart part = new ViewerSearchPart(parent){

            @Override
            protected boolean matches(Object element, Object parentElement, String pattern) {
                if (element instanceof IFrameworkCommandDescriptor) {
                    String commandName = ((IFrameworkCommandDescriptor)element).getName();
                    String lowerCasePattern = pattern.toLowerCase();
                    if (commandName != null) {
                        commandName = commandName.toLowerCase();
                        SearchPattern filter = new SearchPattern();
                        filter.setPattern(lowerCasePattern);
                        return filter.matches(commandName);
                    }
                }
                return false;
            }
        };
        return part;
    }

    protected synchronized void createCommandTableArea(Composite parent) {
        Composite tableArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(tableArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableArea);
        Label tableLabel = new Label(tableArea, 16384);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)tableLabel);
        tableLabel.setText(SELECT_COMMAND_LABEL);
        final ViewerSearchPart part = this.createSearchControl(tableArea);
        Table table = new Table(tableArea, this.getViewerConfiguration());
        this.commandTableViewer = new TableViewer(table);
        part.connectViewer((StructuredViewer)this.commandTableViewer);
        this.setTableColumnAndLayout(this.commandTableViewer);
        this.commandTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    Collection topLevel = (Collection)inputElement;
                    return topLevel.toArray();
                }
                return null;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.commandTableViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IFrameworkCommandDescriptor) {
                    return ((IFrameworkCommandDescriptor)element).getName();
                }
                return null;
            }
        });
        this.commandTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selObj;
                IStructuredSelection selection = (IStructuredSelection)GenericWizardCommandListPage.this.commandTableViewer.getSelection();
                if (selection != null && (selObj = selection.getFirstElement()) instanceof IFrameworkCommandDescriptor) {
                    GenericWizardCommandListPage.this.selectionChanged((IFrameworkCommandDescriptor)selObj);
                }
                GenericWizardCommandListPage.this.checkPageComplete();
            }
        });
        this.commandTableViewer.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                IFrameworkCommandDescriptor currentSelection;
                Object topSelection;
                if (e.keyCode == 0x1000001 && (topSelection = GenericWizardCommandListPage.this.commandTableViewer.getElementAt(0)) == (currentSelection = GenericWizardCommandListPage.this.getSelectedCommandDescriptor())) {
                    part.getTextControl().setFocus();
                }
            }
        });
        this.commandTableViewer.setInput(this.commandDescriptors);
        Text searchText = part.getTextControl();
        searchText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    GenericWizardCommandListPage.this.commandTableViewer.getTable().setFocus();
                    Object selection = GenericWizardCommandListPage.this.commandTableViewer.getElementAt(0);
                    if (selection instanceof IFrameworkCommandDescriptor) {
                        GenericWizardCommandListPage.this.selectCommandInViewer((IFrameworkCommandDescriptor)selection);
                    }
                }
            }
        });
        searchText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent event) {
                int itemCount = GenericWizardCommandListPage.this.commandTableViewer.getTable().getItemCount();
                if (itemCount == 1) {
                    IFrameworkCommandDescriptor remainingDescriptor = (IFrameworkCommandDescriptor)GenericWizardCommandListPage.this.commandTableViewer.getElementAt(0);
                    if (remainingDescriptor != null) {
                        GenericWizardCommandListPage.this.selectCommandInViewer(remainingDescriptor);
                    }
                } else {
                    GenericWizardCommandListPage.this.selectCommandInViewer(null);
                }
            }

            public void keyPressed(KeyEvent event) {
            }
        });
        searchText.setFocus();
        this.checkPageComplete();
    }

    protected void selectionChanged(IFrameworkCommandDescriptor selectedDescriptor) {
        this.selectedCommandDescriptor = selectedDescriptor;
        this.getGenericCommandWizard().setCommandInstance(this.selectedCommandDescriptor);
        this.refreshDescriptionArea();
        this.checkPageComplete();
    }

    protected int getMinTableHeight() {
        return 200;
    }

    protected int getMinCommandColumnWeight() {
        return 400;
    }

    protected void setTableColumnAndLayout(final TableViewer tableviewer) {
        tableviewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object command1, Object command2) {
                if (viewer instanceof TableViewer) {
                    Table table = ((TableViewer)viewer).getTable();
                    if (command1 instanceof IFrameworkCommandDescriptor && command2 instanceof IFrameworkCommandDescriptor) {
                        int sortDirection = table.getSortDirection();
                        String commandName1 = ((IFrameworkCommandDescriptor)command1).getName();
                        String commandName2 = ((IFrameworkCommandDescriptor)command2).getName();
                        return sortDirection == 128 ? commandName1.compareToIgnoreCase(commandName2) : commandName2.compareToIgnoreCase(commandName1);
                    }
                }
                return super.compare(viewer, command1, command2);
            }
        });
        final Table table = tableviewer.getTable();
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, this.getMinTableHeight()).applyTo((Control)table);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(this.getMinCommandColumnWeight(), true));
        TableColumn commandColumn = new TableColumn(table, 0);
        table.setLayout((Layout)tableLayout);
        commandColumn.setText("Commands");
        commandColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int dir = table.getSortDirection();
                dir = dir == 128 ? 1024 : 128;
                table.setSortDirection(dir);
                tableviewer.refresh();
            }
        });
        table.setSortColumn(commandColumn);
        table.setSortDirection(128);
        table.setHeaderVisible(false);
        table.layout(true);
        tableviewer.refresh();
    }

    protected void checkPageComplete() {
        IFrameworkCommandDescriptor command = this.getSelectedCommandDescriptor();
        if (command == null || this.hasRequiredParameters(command)) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
        }
    }

    public boolean isPageComplete() {
        if (!this.isCurrentPage()) {
            return true;
        }
        return super.isPageComplete();
    }

    public boolean canFlipToNextPage() {
        IFrameworkCommandDescriptor command = this.getSelectedCommandDescriptor();
        if (command == null) {
            this.setMessage(PAGE_MESSAGE);
            return false;
        }
        if (this.hasRequiredParameters(command)) {
            this.setMessage("This command has required parameters with values to set. Click next to set the values.");
            return true;
        }
        if (command.getParameters().length == 0) {
            this.setMessage("This command has no parameters to set. Click finish to execute the command.");
            return false;
        }
        this.setMessage("Click next to set optional parameter values, or click finish to execute the command.");
        return true;
    }

    protected boolean hasRequiredParameters(IFrameworkCommandDescriptor commandDescriptor) {
        ICommandParameterDescriptor[] parameters;
        ICommandParameterDescriptor[] iCommandParameterDescriptorArray = parameters = commandDescriptor.getParameters();
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ICommandParameterDescriptor parameter = iCommandParameterDescriptorArray[n2];
            if (parameter.isMandatory()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void createDescriptionArea(Composite parent) {
        Composite descriptionArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(descriptionArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)descriptionArea);
        Label descriptionLabel = new Label(descriptionArea, 16384);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)descriptionLabel);
        descriptionLabel.setText("Command Description:");
        this.descriptionControl = new Text(descriptionArea, 2632);
        GridDataFactory.fillDefaults().grab(true, true).hint(this.getDescriptionWidthHint(), this.getDescriptionHeightHint()).applyTo((Control)this.descriptionControl);
    }

    protected int getDescriptionWidthHint() {
        return -1;
    }

    protected int getDescriptionHeightHint() {
        return 180;
    }

    public synchronized IFrameworkCommandDescriptor getSelectedCommandDescriptor() {
        return this.selectedCommandDescriptor;
    }

    protected void refreshDescriptionArea() {
        if (this.descriptionControl != null && !this.descriptionControl.isDisposed()) {
            DescriptionSetter buffer = new DescriptionSetter(this.getSelectedCommandDescriptor(), this.descriptionControl);
            buffer.setDescription();
        }
    }

    protected static class DescriptionSetter {
        private int lines = 0;
        private IFrameworkCommandDescriptor command;
        private Text descriptionText;
        private StringBuffer buffer;

        public DescriptionSetter(IFrameworkCommandDescriptor command, Text descriptionText) {
            this.command = command;
            this.descriptionText = descriptionText;
        }

        public String setDescription() {
            this.buffer = new StringBuffer();
            if (this.command == null) {
                this.appendLine("n/a");
            } else {
                String description = this.command.getDescription();
                if (description != null && description.length() > 0) {
                    this.appendLine(description);
                } else {
                    this.appendLine("Description not available");
                }
                ICommandParameterDescriptor[] parameters = this.command.getParameters();
                this.appendLine("");
                this.appendLine("Parameters:");
                if (parameters == null || parameters.length == 0) {
                    this.appendLine("   This command has no parameters");
                } else {
                    ICommandParameterDescriptor[] iCommandParameterDescriptorArray = parameters;
                    int n = parameters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICommandParameterDescriptor param = iCommandParameterDescriptorArray[n2];
                        StringBuffer params = new StringBuffer();
                        params.append(GenericWizardCommandListPage.DESCRIPTION_INDENT);
                        params.append(param.getName());
                        params.append(" -- ");
                        params.append(param.isMandatory() ? " is required" : " optional");
                        this.appendLine(params.toString());
                        ++n2;
                    }
                }
            }
            String text = this.buffer.toString();
            this.descriptionText.setText(text);
            return text;
        }

        public int getLines() {
            return this.lines;
        }

        protected void appendLine(String text) {
            this.buffer.append(text);
            this.buffer.append(System.getProperty("line.separator"));
            ++this.lines;
        }
    }
}

