/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.parameters.editors;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ComboParameterDescriptor;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ICommandParameter;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ICommandParameterDescriptor;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ParameterKind;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.parameters.editors.AbstractParameterEditor;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.swt.SWTFactory;

public class ComboParameterEditor
extends AbstractParameterEditor {
    public static final int DEFAULT_COMBO_BOX_LIMIT = 5;
    protected Map<String, Button> radialButtons;
    protected Combo combo;

    public ComboParameterEditor(ICommandParameter parameter, boolean requiresLabel) {
        super(parameter, requiresLabel);
    }

    @Override
    public Composite createControls(Composite parent) {
        ICommandParameterDescriptor parameter = this.getParameterDescriptor();
        if (parameter == null || parameter.getParameterKind() != ParameterKind.COMBO) {
            return null;
        }
        ComboParameterDescriptor comboParameter = (ComboParameterDescriptor)parameter;
        String[] values = comboParameter.getSelectionValues();
        if (values == null || values.length == 0) {
            return null;
        }
        int size = values.length;
        if (size <= this.getComboBoxLimit()) {
            this.createRadialButtons(parent, comboParameter);
        } else {
            this.createCombo(parent, comboParameter);
        }
        return null;
    }

    protected int getComboBoxLimit() {
        return 5;
    }

    protected Control createCombo(Composite parent, ComboParameterDescriptor parameter) {
        String[] values = parameter.getSelectionValues();
        this.combo = new Combo(parent, 12);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)this.combo);
        this.combo.setItems(values);
        String defaultValue = (String)this.getParameter().getValue();
        if (defaultValue != null) {
            int i = 0;
            while (i < values.length) {
                if (defaultValue.equals(values[i])) {
                    this.combo.select(i);
                    break;
                }
                ++i;
            }
        }
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComboParameterEditor.this.setParameterValueAndNotifyClear(ComboParameterEditor.this.combo.getItem(ComboParameterEditor.this.combo.getSelectionIndex()));
            }
        });
        return this.combo;
    }

    protected Control createRadialButtons(Composite parent, ComboParameterDescriptor parameter) {
        Composite buttonArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(this.getComboBoxLimit()).equalWidth(true).applyTo(buttonArea);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonArea);
        this.radialButtons = new HashMap<String, Button>();
        String[] values = parameter.getSelectionValues();
        String defaultValue = (String)this.getParameter().getValue();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            final Button button = SWTFactory.createRadialButton(buttonArea, value, false);
            if (button != null) {
                button.setData((Object)value);
                if (value.equals(defaultValue)) {
                    button.setSelection(true);
                }
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ComboParameterEditor.this.setParameterValueAndNotifyClear(button.getData());
                    }
                });
                this.radialButtons.put(value, button);
            }
            ++n2;
        }
        return buttonArea;
    }

    @Override
    protected void clearControls() {
        if (this.combo != null && !this.combo.isDisposed()) {
            this.combo.deselectAll();
        } else if (this.radialButtons != null) {
            Collection<Button> buttons = this.radialButtons.values();
            for (Button button : buttons) {
                if (button.isDisposed()) continue;
                button.setSelection(false);
            }
        }
    }
}

