/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.settings;

import java.util.ArrayList;
import java.util.Iterator;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class UnversionedCustomProperty {
    private final String name;
    private final String value;
    private static final String NL = System.getProperty("line.separator");

    public UnversionedCustomProperty(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public static UnversionedCustomProperty[] getSvnRevisionProperties(ISVNRemoteResource remoteResource, SVNRevision revision, SVNRevision peg) throws SVNException {
        return UnversionedCustomProperty.getSvnRevisionProperties(remoteResource, revision, peg, true);
    }

    public static UnversionedCustomProperty[] getSvnRevisionProperties(ISVNRemoteResource remoteResource, SVNRevision revision, SVNRevision peg, boolean customOnly) throws SVNException {
        SVNUrl url = remoteResource.getUrl();
        ISVNProperty[] props = UnversionedCustomProperty.getSvnRevisionProperties(url, revision, peg);
        ArrayList<UnversionedCustomProperty> temp = new ArrayList<UnversionedCustomProperty>();
        int i = 0;
        while (i < props.length) {
            String name = props[i].getName();
            String value = props[i].getValue();
            if (!customOnly || !name.startsWith("svn:") && !name.startsWith("bugtraq:") && !name.startsWith("tsvn:")) {
                UnversionedCustomProperty ucp = new UnversionedCustomProperty(name, value);
                temp.add(ucp);
            }
            ++i;
        }
        UnversionedCustomProperty[] ret = new UnversionedCustomProperty[temp.size()];
        int i2 = 0;
        Iterator iter = temp.iterator();
        while (iter.hasNext()) {
            ret[i2++] = (UnversionedCustomProperty)iter.next();
        }
        return ret;
    }

    public static ISVNProperty[] getSvnRevisionProperties(SVNUrl url, SVNRevision revision, SVNRevision peg) throws SVNException {
        return UnversionedCustomProperty.getSvnRevisionProperties(url, revision, peg, true);
    }

    public static ISVNProperty[] getSvnRevisionProperties(SVNUrl url, SVNRevision revision, SVNRevision peg, boolean customOnly) throws SVNException {
        ISVNClientAdapter svnClient = null;
        try {
            svnClient = SVNProviderPlugin.getPlugin().getSVNClient();
            SVNProviderPlugin.disableConsoleLogging();
            ISVNProperty[] props = svnClient.getRevProperties(url, (SVNRevision.Number)revision);
            if (customOnly) {
                ISVNProperty[] iSVNPropertyArray = UnversionedCustomProperty.stripNonCustom(props);
                return iSVNPropertyArray;
            }
            ISVNProperty[] iSVNPropertyArray = props;
            return iSVNPropertyArray;
        }
        catch (SVNClientException e) {
            throw SVNException.wrapException((Exception)((Object)e));
        }
        finally {
            SVNProviderPlugin.enableConsoleLogging();
            SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(svnClient);
        }
    }

    private static ISVNProperty[] stripNonCustom(ISVNProperty[] propsIn) {
        ArrayList<ISVNProperty> temp = new ArrayList<ISVNProperty>();
        int i = 0;
        while (i < propsIn.length) {
            String name = propsIn[i].getName();
            if (!(name.startsWith("svn:") || name.startsWith("bugtraq:") || name.startsWith("tsvn:"))) {
                temp.add(propsIn[i]);
            }
            ++i;
        }
        ISVNProperty[] ret = new ISVNProperty[temp.size()];
        int i2 = 0;
        Iterator iter = temp.iterator();
        while (iter.hasNext()) {
            ret[i2++] = (ISVNProperty)iter.next();
        }
        return ret;
    }

    public static String asMultilineString(UnversionedCustomProperty[] props) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < props.length) {
            if (props[i] == null) break;
            sb.append(String.valueOf(props[i].getName()) + ": " + props[i].getValue() + NL);
            ++i;
        }
        return sb.toString();
    }
}

