/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.dialogs.SubclipseTrayDialog;

public abstract class SvnDialog
extends SubclipseTrayDialog {
    private String id;
    private IDialogSettings settings = SVNUIPlugin.getPlugin().getDialogSettings();
    protected static final int LABEL_WIDTH_HINT = 400;

    public SvnDialog(Shell shell, String id) {
        super(shell);
        this.id = id;
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x10);
    }

    protected void cancelPressed() {
        this.saveLocation();
        super.cancelPressed();
    }

    protected void okPressed() {
        this.saveLocation();
        super.okPressed();
    }

    protected Point getInitialLocation(Point initialSize) {
        if (this.id != null) {
            try {
                int x = this.settings.getInt(String.valueOf(this.id) + ".location.x");
                int y = this.settings.getInt(String.valueOf(this.id) + ".location.y");
                return new Point(x, y);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return super.getInitialLocation(initialSize);
    }

    protected Point getInitialSize() {
        if (this.id != null) {
            try {
                int x = this.settings.getInt(String.valueOf(this.id) + ".size.x");
                int y = this.settings.getInt(String.valueOf(this.id) + ".size.y");
                return new Point(x, y);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return super.getInitialSize();
    }

    protected void saveLocation() {
        if (this.id != null) {
            int x = this.getShell().getLocation().x;
            int y = this.getShell().getLocation().y;
            this.settings.put(String.valueOf(this.id) + ".location.x", x);
            this.settings.put(String.valueOf(this.id) + ".location.y", y);
            x = this.getShell().getSize().x;
            y = this.getShell().getSize().y;
            this.settings.put(String.valueOf(this.id) + ".size.x", x);
            this.settings.put(String.valueOf(this.id) + ".size.y", y);
        }
    }

    protected Label createWrappingLabel(Composite parent, String text, int indent, int horizontalSpan) {
        Label label = new Label(parent, 16448);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = horizontalSpan;
        data.horizontalAlignment = 4;
        data.horizontalIndent = indent;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 400;
        label.setLayoutData((Object)data);
        return label;
    }
}

