/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.decorator;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.decorator.AcceptMineResolution;
import org.tigris.subversion.subclipse.ui.decorator.AcceptTheirsResolution;
import org.tigris.subversion.subclipse.ui.decorator.EditConflictsResolution;
import org.tigris.subversion.subclipse.ui.decorator.MarkAsResolvedResolution;

public class ConflictResolutionGenerator
implements IMarkerResolutionGenerator2 {
    private boolean textConflict;
    private boolean propertyConflict;
    private boolean treeConflict;

    public boolean hasResolutions(IMarker marker) {
        return true;
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        ArrayList<Object> conflictResolutions = new ArrayList<Object>();
        try {
            if (marker.getAttribute("textConflict") != null && marker.getAttribute("textConflict").toString().equals("true")) {
                conflictResolutions.add(new EditConflictsResolution());
                conflictResolutions.add(new AcceptMineResolution());
                conflictResolutions.add(new AcceptTheirsResolution());
            }
        }
        catch (Exception e) {
            SVNUIPlugin.log(e.getMessage());
        }
        conflictResolutions.add(new MarkAsResolvedResolution());
        IMarkerResolution[] resolutionArray = new IMarkerResolution[conflictResolutions.size()];
        conflictResolutions.toArray(resolutionArray);
        return resolutionArray;
    }

    public void setTextConflict(boolean textConflict) {
        this.textConflict = textConflict;
    }

    public void setPropertyConflict(boolean propertyConflict) {
        this.propertyConflict = propertyConflict;
    }

    public void setTreeConflict(boolean treeConflict) {
        this.treeConflict = treeConflict;
    }
}

