/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.metadata.core;

import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.DeclareAnnotation;
import org.aspectj.lang.annotation.DeclareError;
import org.aspectj.lang.annotation.DeclareParents;
import org.aspectj.lang.annotation.DeclareWarning;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.ide.eclipse.beans.core.metadata.model.AbstractMethodAnnotationMetadata;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;

public class AspectMethodAnnotationMetadata
extends AbstractMethodAnnotationMetadata {
    private static final long serialVersionUID = 4275348191391381652L;
    private static final Map<String, Type> TYPE_MAPPING = new HashMap<String, Type>();
    private Type type = null;

    static {
        TYPE_MAPPING.put(Before.class.getName(), Type.BEFORE);
        TYPE_MAPPING.put(After.class.getName(), Type.AFTER);
        TYPE_MAPPING.put(AfterReturning.class.getName(), Type.AFTER);
        TYPE_MAPPING.put(AfterThrowing.class.getName(), Type.AFTER);
        TYPE_MAPPING.put(Around.class.getName(), Type.AROUND);
        TYPE_MAPPING.put(DeclareAnnotation.class.getName(), Type.DECLARE_ANNOTATION);
        TYPE_MAPPING.put(DeclareWarning.class.getName(), Type.DECLARE_WARNING);
        TYPE_MAPPING.put(DeclareError.class.getName(), Type.DECLARE_ERROR);
        TYPE_MAPPING.put(DeclareParents.class.getName(), Type.DECLARE_PARENTS);
        TYPE_MAPPING.put(Pointcut.class.getName(), Type.POINTCUT);
    }

    public AspectMethodAnnotationMetadata(String key, String handle, Object value, IModelSourceLocation location) {
        super(key, handle, value, location);
        this.type = TYPE_MAPPING.get(key);
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        BEFORE,
        AFTER,
        AROUND,
        DECLARE_ANNOTATION,
        DECLARE_WARNING,
        DECLARE_ERROR,
        POINTCUT,
        DECLARE_PARENTS;

    }
}

