/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.MethodArguments;
import org.springframework.ide.eclipse.webflow.core.internal.model.MethodResult;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IAttribute;
import org.springframework.ide.eclipse.webflow.core.model.IBeanAction;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IMethodArguments;
import org.springframework.ide.eclipse.webflow.core.model.IMethodResult;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BeanAction
extends AbstractAction
implements IBeanAction,
ICloneableModelElement<BeanAction> {
    private IMethodArguments methodArguments;
    private IMethodResult methodResult;

    @Override
    public void init(IDOMNode node, IWebflowModelElement parent) {
        super.init(node, parent);
        NodeList children = node.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                IDOMNode child = (IDOMNode)children.item(i);
                if ("method-arguments".equals(child.getLocalName())) {
                    this.methodArguments = new MethodArguments();
                    this.methodArguments.init(child, this);
                } else if ("method-result".equals(child.getLocalName())) {
                    this.methodResult = new MethodResult();
                    this.methodResult.init(child, this);
                }
                ++i;
            }
        }
    }

    @Override
    public IMethodArguments getMethodArguments() {
        return this.methodArguments;
    }

    @Override
    public IMethodResult getMethodResult() {
        return this.methodResult;
    }

    @Override
    public void setMethodArguments(IMethodArguments methodArguments) {
        if (this.methodArguments != null) {
            this.getNode().removeChild((Node)this.methodArguments.getNode());
        }
        this.methodArguments = methodArguments;
        if (methodArguments != null) {
            WebflowModelXmlUtils.insertNode((Node)methodArguments.getNode(), (Node)this.getNode());
        }
        super.fireStructureChange("move_children", new Integer(1));
    }

    @Override
    public void setMethodResult(IMethodResult methodResult) {
        if (this.methodResult != null) {
            this.getNode().removeChild((Node)this.methodResult.getNode());
        }
        this.methodResult = methodResult;
        if (methodResult != null) {
            WebflowModelXmlUtils.insertNode((Node)methodResult.getNode(), (Node)this.getNode());
        }
        super.fireStructureChange("move_children", new Integer(1));
    }

    @Override
    public BeanAction cloneModelElement() {
        BeanAction state = new BeanAction();
        state.init((IDOMNode)this.node.cloneNode(true), this.parent);
        state.setType(this.getType());
        return state;
    }

    @Override
    public void applyCloneValues(BeanAction element) {
        if (element != null) {
            if (this.node.getParentNode() != null) {
                this.parent.getNode().replaceChild((Node)element.getNode(), (Node)this.node);
            }
            this.setType(element.getType());
            this.init(element.getNode(), this.parent);
            super.fireStructureChange("move_children", new Integer(0));
            super.firePropertyChange("properties");
        }
    }

    @Override
    public void createNew(IWebflowModelElement parent) {
        IDOMNode node = (IDOMNode)parent.getNode().getOwnerDocument().createElement("bean-action");
        this.init(node, parent);
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor)) {
            for (IAttribute state : this.getAttributes()) {
                if (monitor.isCanceled()) {
                    return;
                }
                state.accept(visitor, monitor);
            }
            if (monitor.isCanceled()) {
                return;
            }
            if (this.getMethodArguments() != null) {
                this.getMethodArguments().accept(visitor, monitor);
            }
            if (monitor.isCanceled()) {
                return;
            }
            if (this.getMethodResult() != null) {
                this.getMethodResult().accept(visitor, monitor);
            }
        }
    }

    public IModelElement[] getElementChildren() {
        ArrayList<IWebflowModelElement> children = new ArrayList<IWebflowModelElement>();
        children.addAll(this.getAttributes());
        children.add(this.getMethodArguments());
        children.add(this.getMethodResult());
        return children.toArray(new IModelElement[children.size()]);
    }
}

