/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.xml;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtil {
    public static String toString(Node node) {
        return DOMUtil.formatNode(node, new StringBuffer()).toString();
    }

    private static StringBuffer formatNode(Node node, StringBuffer stringBuffer) {
        return DOMUtil.formatNode(node, 0, stringBuffer);
    }

    private static StringBuffer formatNode(Node node, int indent, StringBuffer stringBuffer) {
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                stringBuffer.append("&lt;?xml version=\"1.0\" ?>\n");
                stringBuffer = DOMUtil.formatNode(((Document)node).getDocumentElement(), indent, stringBuffer);
                break;
            }
            case 1: {
                if (indent > 0) {
                    stringBuffer.append("\n");
                }
                int i = 0;
                while (i < indent) {
                    stringBuffer.append(" ");
                    ++i;
                }
                stringBuffer.append("<" + node.getNodeName());
                NamedNodeMap attrs = node.getAttributes();
                int i2 = 0;
                while (i2 < attrs.getLength()) {
                    Node attr = attrs.item(i2);
                    stringBuffer.append("\n");
                    int j = 0;
                    while (j < indent) {
                        stringBuffer.append(" ");
                        ++j;
                    }
                    stringBuffer.append("   " + attr.getNodeName().trim() + "=\"" + attr.getNodeValue().trim() + "\"");
                    ++i2;
                }
                stringBuffer.append(">");
                indent += 3;
                NodeList children = node.getChildNodes();
                if (children != null) {
                    int len = children.getLength();
                    int i3 = 0;
                    while (i3 < len) {
                        stringBuffer = DOMUtil.formatNode(children.item(i3), indent, stringBuffer);
                        ++i3;
                    }
                }
                indent -= 3;
                break;
            }
            case 5: {
                stringBuffer.append("&");
                stringBuffer.append(node.getNodeName().trim());
                stringBuffer.append(";");
                break;
            }
            case 4: {
                stringBuffer.append("<![CDATA[");
                stringBuffer.append(node.getNodeValue().trim());
                stringBuffer.append("]]>");
                break;
            }
            case 3: {
                stringBuffer.append("\n");
                int i = 0;
                while (i < indent) {
                    stringBuffer.append(" ");
                    ++i;
                }
                stringBuffer.append(node.getNodeValue().trim());
                break;
            }
            case 7: {
                stringBuffer.append("<?");
                stringBuffer.append(node.getNodeName().trim());
                String data = node.getNodeValue().trim();
                stringBuffer.append(" ");
                stringBuffer.append(data);
                stringBuffer.append("?>");
            }
        }
        if (type == 1) {
            stringBuffer.append("\n");
            int i = 0;
            while (i < indent) {
                stringBuffer.append(" ");
                ++i;
            }
            stringBuffer.append("</");
            stringBuffer.append(node.getNodeName().trim());
            stringBuffer.append('>');
        }
        return stringBuffer;
    }

    public static Document parse(String fileName) {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(new File(fileName));
            return document;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public static void writeXmlToFile(String filename, Document document) {
        try {
            DOMSource source = new DOMSource(document);
            File file = new File(filename);
            StreamResult result = new StreamResult(file);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public static int countByTagName(String tag, Document document) {
        NodeList list = document.getElementsByTagName(tag);
        return list.getLength();
    }
}

