/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge;

import com.collabnet.subversion.merge.CopyCommand;
import com.collabnet.subversion.merge.MergeResult;
import com.collabnet.subversion.merge.Messages;
import com.collabnet.subversion.merge.views.MergeResultsView;
import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.operations.RepositoryProviderOperation;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class CopyOperation
extends RepositoryProviderOperation {
    private SVNUrl srcUrl;
    private File destPath;
    private SVNRevision svnRevision;
    private CopyCommand command;
    private MergeResult mergeResult;

    public CopyOperation(IWorkbenchPart part, IResource[] resources, SVNUrl srcUrl, File destPath, SVNRevision svnRevision, MergeResult mergeResult) {
        super(part, resources);
        this.srcUrl = srcUrl;
        this.destPath = destPath;
        this.svnRevision = svnRevision;
        this.mergeResult = mergeResult;
    }

    protected void execute(SVNTeamProvider provider, IResource[] resources, IProgressMonitor monitor) throws SVNException, InterruptedException {
        monitor.beginTask(null, 100);
        try {
            try {
                this.command = new CopyCommand(provider.getSVNWorkspaceRoot(), this.srcUrl, this.destPath, this.svnRevision);
                this.command.run(Policy.subMonitorFor((IProgressMonitor)monitor, (int)1000));
                this.mergeResult.setAction("A");
                if (this.mergeResult.getResource() instanceof IContainer) {
                    MergeResult[] mergeResults = this.mergeResult.getMergeOutput().getMergeResults();
                    int i = 0;
                    while (i < mergeResults.length) {
                        IContainer parent;
                        if (mergeResults[i].getResource() != null && mergeResults[i].getResource().getParent() != null && mergeResults[i].getAction().equals("S") && (parent = mergeResults[i].getResource().getParent()).getFullPath().equals((Object)this.mergeResult.getResource().getFullPath())) {
                            mergeResults[i].setAction("A");
                        }
                        ++i;
                    }
                }
                this.mergeResult.getMergeOutput().store();
                MergeResultsView.getView().refreshAsync(this.mergeResult.getMergeOutput());
            }
            catch (SVNException e) {
                if (e.operationInterrupted()) {
                    this.showCancelledMessage();
                } else {
                    this.collectStatus(e.getStatus());
                }
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected String getTaskName(SVNTeamProvider provider) {
        return String.valueOf(Messages.CopyOperation_copying) + provider.getProject().getName();
    }

    protected String getTaskName() {
        return Messages.CopyOperation_title;
    }
}

