/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors.integration.graph;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.config.graph.BadgedImageDescriptor;
import org.springframework.ide.eclipse.config.graph.ScaledImageDescriptor;
import org.springframework.ide.eclipse.config.ui.ConfigUiPlugin;

public class IntegrationImages {
    private static final URL baseURL = ConfigUiPlugin.getDefault().getBundle().getEntry("/icons/");
    private static ImageRegistry imageRegistry;
    private static final double SCALE = 0.5;
    private static final String INT = "integration";
    private static final String INT16 = "integration16";
    public static final ImageDescriptor AGGREGATOR;
    public static final ImageDescriptor AGGREGATOR_SMALL;
    public static final ImageDescriptor BRIDGE;
    public static final ImageDescriptor BRIDGE_SMALL;
    public static final ImageDescriptor CHAIN;
    public static final ImageDescriptor CHAIN_SMALL;
    public static final ImageDescriptor CHANNEL;
    public static final ImageDescriptor CHANNEL_GRAY;
    public static final ImageDescriptor CHANNEL_SMALL;
    public static final ImageDescriptor CLAIM_CHECK;
    public static final ImageDescriptor CLAIM_CHECK_SMALL;
    public static final ImageDescriptor CONTENT_FILTER;
    public static final ImageDescriptor CONTENT_FILTER_SMALL;
    public static final ImageDescriptor CONTROL_BUS;
    public static final ImageDescriptor CONTROL_BUS_SMALL;
    public static final ImageDescriptor DELAYER;
    public static final ImageDescriptor DELAYER_SMALL;
    public static final ImageDescriptor ENRICHER;
    public static final ImageDescriptor ENRICHER_SMALL;
    public static final ImageDescriptor EXCEPTION_ROUTER;
    public static final ImageDescriptor EXCEPTION_ROUTER_SMALL;
    public static final ImageDescriptor FILTER;
    public static final ImageDescriptor FILTER_SMALL;
    public static final ImageDescriptor INBOUND_ADAPTER;
    public static final ImageDescriptor INBOUND_ADAPTER_SMALL;
    public static final ImageDescriptor INBOUND_GATEWAY;
    public static final ImageDescriptor INBOUND_GATEWAY_SMALL;
    public static final ImageDescriptor OUTBOUND_ADAPTER;
    public static final ImageDescriptor OUTBOUND_ADAPTER_SMALL;
    public static final ImageDescriptor OUTBOUND_GATEWAY;
    public static final ImageDescriptor OUTBOUND_GATEWAY_SMALL;
    public static final ImageDescriptor PLACEHOLDER;
    public static final ImageDescriptor PLACEHOLDER_SMALL;
    public static final ImageDescriptor PUBSUB_CHANNEL;
    public static final ImageDescriptor PUBSUB_CHANNEL_SMALL;
    public static final ImageDescriptor RECIPIENT_LIST;
    public static final ImageDescriptor RECIPIENT_LIST_SMALL;
    public static final ImageDescriptor RESEQUENCER;
    public static final ImageDescriptor RESEQUENCER_SMALL;
    public static final ImageDescriptor ROUTER;
    public static final ImageDescriptor ROUTER_SMALL;
    public static final ImageDescriptor SERVICE_ACTIVATOR;
    public static final ImageDescriptor SERVICE_ACTIVATOR_SMALL;
    public static final ImageDescriptor SPLITTER;
    public static final ImageDescriptor SPLITTER_SMALL;
    public static final ImageDescriptor TRANSFORMER;
    public static final ImageDescriptor TRANSFORMER_SMALL;
    public static final ImageDescriptor BADGE_SI;
    public static final ImageDescriptor BADGE_SI_AMQP;
    public static final ImageDescriptor BADGE_SI_AWS;
    public static final ImageDescriptor BADGE_SI_EVENT;
    public static final ImageDescriptor BADGE_SI_FEED;
    public static final ImageDescriptor BADGE_SI_FILE;
    public static final ImageDescriptor BADGE_SI_FTP;
    public static final ImageDescriptor BADGE_SI_GEMFIRE;
    public static final ImageDescriptor BADGE_SI_GROOVY;
    public static final ImageDescriptor BADGE_SI_HTTP;
    public static final ImageDescriptor BADGE_SI_HTTPINVOKER;
    public static final ImageDescriptor BADGE_SI_IP;
    public static final ImageDescriptor BADGE_SI_JDBC;
    public static final ImageDescriptor BADGE_SI_JMS;
    public static final ImageDescriptor BADGE_SI_JMX;
    public static final ImageDescriptor BADGE_SI_JGROUPS;
    public static final ImageDescriptor BADGE_SI_JPA;
    public static final ImageDescriptor BADGE_SI_KAFKA;
    public static final ImageDescriptor BADGE_SI_MAIL;
    public static final ImageDescriptor BADGE_SI_MONGODB;
    public static final ImageDescriptor BADGE_SI_MQTT;
    public static final ImageDescriptor BADGE_SI_PRINT;
    public static final ImageDescriptor BADGE_SI_REDIS;
    public static final ImageDescriptor BADGE_SI_RMI;
    public static final ImageDescriptor BADGE_SI_SCRIPTING;
    public static final ImageDescriptor BADGE_SI_SECURITY;
    public static final ImageDescriptor BADGE_SI_SFTP;
    public static final ImageDescriptor BADGE_SI_SMB;
    public static final ImageDescriptor BADGE_SI_SMPP;
    public static final ImageDescriptor BADGE_SI_SPLUNK;
    public static final ImageDescriptor BADGE_SI_STREAM;
    public static final ImageDescriptor BADGE_SI_SYSLOG;
    public static final ImageDescriptor BADGE_SI_TWITTER;
    public static final ImageDescriptor BADGE_SI_VOLDEMORT;
    public static final ImageDescriptor BADGE_SI_WEBSOCKET;
    public static final ImageDescriptor BADGE_SI_WS;
    public static final ImageDescriptor BADGE_SI_XML;
    public static final ImageDescriptor BADGE_SI_XMPP;
    public static final ImageDescriptor BADGE_SI_XQUERY;

    static {
        AGGREGATOR = IntegrationImages.create(INT, "aggregator.png");
        AGGREGATOR_SMALL = IntegrationImages.scale(AGGREGATOR, 0.5);
        BRIDGE = IntegrationImages.create(INT, "bridge.png");
        BRIDGE_SMALL = IntegrationImages.scale(BRIDGE, 0.5);
        CHAIN = IntegrationImages.create(INT, "chain.png");
        CHAIN_SMALL = IntegrationImages.scale(CHAIN, 0.5);
        CHANNEL = IntegrationImages.create(INT, "channel.png");
        CHANNEL_GRAY = ImageDescriptor.createWithFlags((ImageDescriptor)CHANNEL, (int)2);
        CHANNEL_SMALL = IntegrationImages.scale(CHANNEL, 0.5);
        CLAIM_CHECK = IntegrationImages.create(INT, "claim-check.png");
        CLAIM_CHECK_SMALL = IntegrationImages.scale(CLAIM_CHECK, 0.5);
        CONTENT_FILTER = IntegrationImages.create(INT, "content-filter.png");
        CONTENT_FILTER_SMALL = IntegrationImages.scale(CONTENT_FILTER, 0.5);
        CONTROL_BUS = IntegrationImages.create(INT, "control-bus.png");
        CONTROL_BUS_SMALL = IntegrationImages.scale(CONTROL_BUS, 0.5);
        DELAYER = IntegrationImages.create(INT, "delayer.png");
        DELAYER_SMALL = IntegrationImages.scale(DELAYER, 0.5);
        ENRICHER = IntegrationImages.create(INT, "enricher.png");
        ENRICHER_SMALL = IntegrationImages.scale(ENRICHER, 0.5);
        EXCEPTION_ROUTER = IntegrationImages.create(INT, "exception-router.png");
        EXCEPTION_ROUTER_SMALL = IntegrationImages.scale(EXCEPTION_ROUTER, 0.5);
        FILTER = IntegrationImages.create(INT, "filter.png");
        FILTER_SMALL = IntegrationImages.scale(FILTER, 0.5);
        INBOUND_ADAPTER = IntegrationImages.create(INT, "inbound-adapter.png");
        INBOUND_ADAPTER_SMALL = IntegrationImages.scale(INBOUND_ADAPTER, 0.5);
        INBOUND_GATEWAY = IntegrationImages.create(INT, "inbound-gateway.png");
        INBOUND_GATEWAY_SMALL = IntegrationImages.scale(INBOUND_GATEWAY, 0.5);
        OUTBOUND_ADAPTER = IntegrationImages.create(INT, "outbound-adapter.png");
        OUTBOUND_ADAPTER_SMALL = IntegrationImages.scale(OUTBOUND_ADAPTER, 0.5);
        OUTBOUND_GATEWAY = IntegrationImages.create(INT, "outbound-gateway.png");
        OUTBOUND_GATEWAY_SMALL = IntegrationImages.scale(OUTBOUND_GATEWAY, 0.5);
        PLACEHOLDER = IntegrationImages.create(INT, "placeholder.png");
        PLACEHOLDER_SMALL = IntegrationImages.scale(PLACEHOLDER, 0.5);
        PUBSUB_CHANNEL = IntegrationImages.create(INT, "pubsub-channel.png");
        PUBSUB_CHANNEL_SMALL = IntegrationImages.scale(PUBSUB_CHANNEL, 0.5);
        RECIPIENT_LIST = IntegrationImages.create(INT, "recipient-list.png");
        RECIPIENT_LIST_SMALL = IntegrationImages.scale(RECIPIENT_LIST, 0.5);
        RESEQUENCER = IntegrationImages.create(INT, "resequencer.png");
        RESEQUENCER_SMALL = IntegrationImages.scale(RESEQUENCER, 0.5);
        ROUTER = IntegrationImages.create(INT, "router.png");
        ROUTER_SMALL = IntegrationImages.scale(ROUTER, 0.5);
        SERVICE_ACTIVATOR = IntegrationImages.create(INT, "service-activator.png");
        SERVICE_ACTIVATOR_SMALL = IntegrationImages.scale(SERVICE_ACTIVATOR, 0.5);
        SPLITTER = IntegrationImages.create(INT, "splitter.png");
        SPLITTER_SMALL = IntegrationImages.scale(SPLITTER, 0.5);
        TRANSFORMER = IntegrationImages.create(INT, "transformer.png");
        TRANSFORMER_SMALL = IntegrationImages.scale(TRANSFORMER, 0.5);
        BADGE_SI = IntegrationImages.create(INT16, "spring-integration.gif");
        BADGE_SI_AMQP = IntegrationImages.create(INT16, "spring-integration-amqp.gif");
        BADGE_SI_AWS = IntegrationImages.create(INT16, "spring-integration-aws.gif");
        BADGE_SI_EVENT = IntegrationImages.create(INT16, "spring-integration-event.gif");
        BADGE_SI_FEED = IntegrationImages.create(INT16, "spring-integration-feed.gif");
        BADGE_SI_FILE = IntegrationImages.create(INT16, "spring-integration-file.gif");
        BADGE_SI_FTP = IntegrationImages.create(INT16, "spring-integration-ftp.gif");
        BADGE_SI_GEMFIRE = IntegrationImages.create(INT16, "spring-integration-gemfire.gif");
        BADGE_SI_GROOVY = IntegrationImages.create(INT16, "spring-integration-groovy.gif");
        BADGE_SI_HTTP = IntegrationImages.create(INT16, "spring-integration-http.gif");
        BADGE_SI_HTTPINVOKER = IntegrationImages.create(INT16, "spring-integration-httpinvoker.gif");
        BADGE_SI_IP = IntegrationImages.create(INT16, "spring-integration-ip.gif");
        BADGE_SI_JDBC = IntegrationImages.create(INT16, "spring-integration-jdbc.gif");
        BADGE_SI_JMS = IntegrationImages.create(INT16, "spring-integration-jms.gif");
        BADGE_SI_JMX = IntegrationImages.create(INT16, "spring-integration-jmx.gif");
        BADGE_SI_JGROUPS = IntegrationImages.create(INT16, "spring-integration-jgroups.gif");
        BADGE_SI_JPA = IntegrationImages.create(INT16, "spring-integration-jpa.gif");
        BADGE_SI_KAFKA = IntegrationImages.create(INT16, "spring-integration-kafka.gif");
        BADGE_SI_MAIL = IntegrationImages.create(INT16, "spring-integration-mail.gif");
        BADGE_SI_MONGODB = IntegrationImages.create(INT16, "spring-integration-mongodb.gif");
        BADGE_SI_MQTT = IntegrationImages.create(INT16, "spring-integration-mqttadapter.gif");
        BADGE_SI_PRINT = IntegrationImages.create(INT16, "spring-integration-print.gif");
        BADGE_SI_REDIS = IntegrationImages.create(INT16, "spring-integration-redis.gif");
        BADGE_SI_RMI = IntegrationImages.create(INT16, "spring-integration-rmi.gif");
        BADGE_SI_SCRIPTING = IntegrationImages.create(INT16, "spring-integration-scripting.gif");
        BADGE_SI_SECURITY = IntegrationImages.create(INT16, "spring-integration-security.gif");
        BADGE_SI_SFTP = IntegrationImages.create(INT16, "spring-integration-sftp.gif");
        BADGE_SI_SMB = IntegrationImages.create(INT16, "spring-integration-smb.gif");
        BADGE_SI_SMPP = IntegrationImages.create(INT16, "spring-integration-smpp.gif");
        BADGE_SI_SPLUNK = IntegrationImages.create(INT16, "spring-integration-splunk.gif");
        BADGE_SI_STREAM = IntegrationImages.create(INT16, "spring-integration-stream.gif");
        BADGE_SI_SYSLOG = IntegrationImages.create(INT16, "spring-integration-syslog.gif");
        BADGE_SI_TWITTER = IntegrationImages.create(INT16, "spring-integration-twitter.gif");
        BADGE_SI_VOLDEMORT = IntegrationImages.create(INT16, "spring-integration-voldemort.gif");
        BADGE_SI_WEBSOCKET = IntegrationImages.create(INT16, "spring-integration-websocket.gif");
        BADGE_SI_WS = IntegrationImages.create(INT16, "spring-integration-ws.gif");
        BADGE_SI_XML = IntegrationImages.create(INT16, "spring-integration-xml.gif");
        BADGE_SI_XMPP = IntegrationImages.create(INT16, "spring-integration-xmpp.gif");
        BADGE_SI_XQUERY = IntegrationImages.create(INT16, "spring-integration-xquery.gif");
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)IntegrationImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    public static Image getImageWithBadge(ImageDescriptor descriptor, ImageDescriptor badge) {
        String key = "" + descriptor.hashCode();
        key = String.valueOf(key) + badge.hashCode();
        ImageDescriptor cache = IntegrationImages.getImageRegistry().getDescriptor(key);
        if (cache == null) {
            cache = new BadgedImageDescriptor(descriptor, badge, false, false);
            IntegrationImages.getImageRegistry().put(key, cache);
        }
        return CommonImages.getImage((ImageDescriptor)cache);
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (baseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(baseURL, buffer.toString());
    }

    private static ImageDescriptor scale(ImageDescriptor descriptor, double scale) {
        String key = "" + descriptor.hashCode();
        key = String.valueOf(key) + new Double(scale).hashCode();
        ImageDescriptor cache = IntegrationImages.getImageRegistry().getDescriptor(key);
        if (cache == null) {
            cache = new ScaledImageDescriptor(descriptor, scale);
            IntegrationImages.getImageRegistry().put(key, cache);
        }
        return cache;
    }
}

