/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.config.core.formatting.ShallowFormatProcessorXML;
import org.springframework.ide.eclipse.config.ui.actions.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DeleteNodeAction
extends Action {
    private final StructuredTextViewer textView;
    private final IDOMNode node;
    private final ShallowFormatProcessorXML formatter;

    public DeleteNodeAction(StructuredTextViewer textView, IDOMNode node) {
        this.textView = textView;
        this.node = node;
        this.formatter = new ShallowFormatProcessorXML();
        this.setText(String.valueOf(Messages.getString("DeleteNodeAction.DELETE_ELEMENT_PREFIX")) + node.getNodeName() + Messages.getString("DeleteNodeAction.DELETE_ELEMENT_SUFFIX"));
    }

    public boolean isEnabled() {
        if (this.node == null) {
            return false;
        }
        Element root = this.node.getOwnerDocument().getDocumentElement();
        if (this.node.equals(root)) {
            return false;
        }
        return super.isEnabled();
    }

    public void run() {
        IDOMModel model = this.node.getModel();
        Node parent = this.node.getParentNode();
        if (this.textView != null && model != null && parent != null) {
            model.beginRecording((Object)this.textView);
            parent.removeChild((Node)this.node);
            this.formatter.formatNode(parent);
            model.endRecording((Object)this.textView);
        }
    }
}

