/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.widgets;

import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public final class TriStateCheckBox {
    private final Button button;
    private TriState state = TriState.UNCHECKED;

    public TriStateCheckBox(Composite parent, WidgetFactory widgetFactory) {
        this(parent, null, widgetFactory);
    }

    public TriStateCheckBox(Composite parent, String text, WidgetFactory widgetFactory) {
        this.button = widgetFactory.createCheckBox(parent, text);
        this.button.addSelectionListener(this.buildSelectionListener());
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        this.button.addDisposeListener(disposeListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.button.addSelectionListener(selectionListener);
    }

    private SelectionListener buildSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TriStateCheckBox.this.checkBoxClicked();
            }
        };
    }

    void checkBoxClicked() {
        this.state = this.nextState();
        this.updateCheckBox();
    }

    public Button getCheckBox() {
        return this.button;
    }

    public Image getImage() {
        return this.button.getImage();
    }

    public Boolean getSelection() {
        return this.state == TriState.PARTIALLY_CHECKED ? null : Boolean.valueOf(this.state == TriState.CHECKED);
    }

    public String getText() {
        return this.button.getText();
    }

    public boolean isDisposed() {
        return this.button.isDisposed();
    }

    public boolean isEnabled() {
        return this.button.isEnabled();
    }

    private TriState nextState() {
        switch (this.state) {
            case UNCHECKED: {
                return TriState.PARTIALLY_CHECKED;
            }
            case PARTIALLY_CHECKED: {
                return TriState.CHECKED;
            }
            case CHECKED: {
                return TriState.UNCHECKED;
            }
        }
        throw new IllegalStateException("unknown state: " + (Object)((Object)this.state));
    }

    public void removeDisposeListener(DisposeListener disposeListener) {
        this.button.removeDisposeListener(disposeListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.button.removeSelectionListener(selectionListener);
    }

    public void setEnabled(boolean enabled) {
        this.button.setEnabled(enabled);
    }

    public void setImage(Image image) {
        this.button.setImage(image);
    }

    public void setSelection(Boolean selection) {
        TriState old = this.state;
        this.state = this.stateForBoolean(selection);
        if (old != this.state) {
            this.updateCheckBox();
        }
    }

    public void setText(String text) {
        this.button.setText(text);
    }

    private TriState stateForBoolean(Boolean selection) {
        return selection == null ? TriState.PARTIALLY_CHECKED : (selection != false ? TriState.CHECKED : TriState.UNCHECKED);
    }

    void updateCheckBox() {
        switch (this.state) {
            case UNCHECKED: {
                this.button.setSelection(false);
                this.button.setGrayed(false);
                break;
            }
            case PARTIALLY_CHECKED: {
                this.button.setSelection(true);
                this.button.setGrayed(true);
                break;
            }
            case CHECKED: {
                this.button.setSelection(true);
                this.button.setGrayed(false);
                break;
            }
            default: {
                throw new IllegalStateException("unknown state: " + (Object)((Object)this.state));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TriState {
        CHECKED,
        PARTIALLY_CHECKED,
        UNCHECKED;

    }
}

