/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.sqltools.common.ui.helpsystem.CommonContextProvider;
import org.eclipse.datatools.sqltools.common.ui.helpsystem.HelpSystemEditorPart;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.modelvalidity.SQLModelValidationDelegate;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.IErrorItem;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorInput;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorPage;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core.ErrorItem;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core.Messages;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.extensions.IEditorDescriptor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.extensions.IEditorPageDescriptor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.SOEUIPlugin;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.util.ILogger;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.util.Images;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.WorkbenchPart;

public class SchemaObjectEditorPage
extends HelpSystemEditorPart
implements ISchemaObjectEditorPage {
    protected ILogger _logger = SOEUIPlugin.getLogger(null);
    private FormEditor _editor;
    private PageForm _mform;
    private int _index;
    private String _id;
    protected String _errorMsg;
    private IEditorDescriptor _editorDescriptor;
    private IEditorPageDescriptor _pageDescriptor;
    protected DiagnosticChain _diagnostics;
    protected List _remembersMarkers;
    protected boolean _pageOpened = false;
    protected boolean _isOnlineMode = false;

    public SchemaObjectEditorPage() {
    }

    public SchemaObjectEditorPage(FormEditor editor, String id, String title) {
        this(id, title);
        this.initialize(editor);
    }

    public SchemaObjectEditorPage(String id, String title) {
        this._id = id;
        this.setPartName(title);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public void initialize(FormEditor editor) {
        this._editor = editor;
    }

    public FormEditor getEditor() {
        return this._editor;
    }

    public IManagedForm getManagedForm() {
        return this._mform;
    }

    public void setActive(boolean active) {
        if (active) {
            this._mform.refresh();
        } else {
            this.removeRememberedMarkers();
        }
    }

    public boolean isActive() {
        return this.equals(this._editor.getActivePageInstance());
    }

    public void createPartControl(Composite parent) {
        ScrolledForm form = this._editor.getToolkit().createScrolledForm(parent);
        this._mform = this.createManagedForm(form);
        BusyIndicator.showWhile((Display)parent.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                SchemaObjectEditorPage.this.createFormContent((IManagedForm)SchemaObjectEditorPage.this._mform);
            }
        });
        this._contextProvider = new CommonContextProvider(this.getEditorDescriptor().getPluginId());
        parent.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)parent, (String)HelpUtil.getContextId((String)this._pageDescriptor.getContextHelpId(), (String)this.getEditorDescriptor().getPluginId()));
    }

    protected PageForm createManagedForm(ScrolledForm form) {
        return new PageForm(this, form);
    }

    protected void createFormContent(IManagedForm managedForm) {
        this._pageOpened = true;
        if (this._pageDescriptor != null && this._pageDescriptor.getContextHelpId() != null && this._pageDescriptor.getContextHelpId().trim().length() != 0) {
            IToolBarManager toolBar = managedForm.getForm().getToolBarManager();
            Action help = new Action(Messages.SchemaObjectEditorPage_help_name){

                public void run() {
                    SchemaObjectEditorPage.this.displayHelp(SchemaObjectEditorPage.this._pageDescriptor.getContextHelpId());
                }
            };
            help.setImageDescriptor(Images.DESC_HELP);
            help.setToolTipText(Messages.SchemaObjectEditorPage_help_tip);
            toolBar.add((IAction)help);
            managedForm.getForm().updateToolBar();
        }
        managedForm.getToolkit().decorateFormHeading(managedForm.getForm().getForm());
    }

    private void displayHelp(String contextHelpId) {
        String contextId = HelpUtil.getContextId((String)contextHelpId, (String)this.getEditorDescriptor().getPluginId());
        if (contextId != null && contextId.length() > 0) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(contextId);
        } else {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp();
        }
    }

    public Control getPartControl() {
        return this._mform != null ? this._mform.getForm() : null;
    }

    public void dispose() {
        if (this._mform != null) {
            this._mform.dispose();
        }
        this.removeRememberedMarkers();
    }

    public String getId() {
        return this._id;
    }

    public Image getTitleImage() {
        return null;
    }

    public void setFocus() {
        if (this._mform != null) {
            this._mform.setFocus();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (this._mform != null) {
            this._mform.commit(true);
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        return this._mform != null ? this._mform.isDirty() : false;
    }

    public void setIndex(int index) {
        this._index = index;
    }

    public int getIndex() {
        return this._index;
    }

    public boolean isEditor() {
        return false;
    }

    public boolean selectReveal(Object object) {
        if (this._mform != null) {
            return this._mform.setInput(object);
        }
        return false;
    }

    public boolean canLeaveThePage() {
        return true;
    }

    public void setEditor(FormEditor editor) {
        this._editor = editor;
    }

    public void setId(String id) {
        this._id = id;
    }

    public void setPartName(String title) {
        super.setPartName(title);
    }

    public String getErrorMsg() {
        return this._errorMsg;
    }

    public IEditorDescriptor getEditorDescriptor() {
        return this._editorDescriptor;
    }

    public IEditorPageDescriptor getPageDescriptor() {
        return this._pageDescriptor;
    }

    public void setEditorDescriptor(IEditorDescriptor editor) {
        this._editorDescriptor = editor;
    }

    public void setPageDescriptor(IEditorPageDescriptor page) {
        this._pageDescriptor = page;
    }

    public void refresh() {
        this.removeRememberedMarkers();
    }

    public void revert() {
        this.refresh();
    }

    public DatabaseIdentifier getDatabaseIdentifier() {
        ISchemaObjectEditorInput input = (ISchemaObjectEditorInput)this.getEditor().getEditorInput();
        return input.getDatabaseIdentifier();
    }

    public void markDirty() {
        ISchemaObjectEditor editor = (ISchemaObjectEditor)this.getEditor();
        editor.markDirty();
    }

    public IErrorItem[] validate(TypedEvent event) {
        ArrayList<ErrorItem> errors = new ArrayList<ErrorItem>();
        this._diagnostics = this.getDiagnosticChain(event);
        boolean isValid = ((BasicDiagnostic)this._diagnostics).getChildren().size() == 0;
        SQLObject[] objs = this.getSQLObjects();
        if (objs == null) {
            return new IErrorItem[0];
        }
        int i = 0;
        while (i < objs.length) {
            isValid &= SQLModelValidationDelegate.getInstance().validate((EObject)objs[i], this._diagnostics, this.buildValidationContext(event), this.buildSharedParams(event));
            ++i;
        }
        if (!isValid && ((Diagnostic)this._diagnostics).getChildren().size() > 0) {
            for (Diagnostic d : ((Diagnostic)this._diagnostics).getChildren()) {
                errors.add(new ErrorItem(null, d.getMessage(), d.getSeverity()));
            }
        }
        IErrorItem[] items = errors.toArray(new IErrorItem[errors.size()]);
        return items;
    }

    protected Map buildValidationContext(TypedEvent e) {
        HashMap context = new HashMap();
        return context;
    }

    protected Map buildSharedParams(TypedEvent e) {
        HashMap context = new HashMap();
        return context;
    }

    protected Map buildSharedParams() {
        return this.buildSharedParams(null);
    }

    public void populateSQLObjects(TypedEvent event) {
    }

    public void validateAndShowErrors(TypedEvent event) {
        IErrorItem[] errors = this.validate(event);
        this.showErrorItems(errors);
    }

    protected SQLObject[] getSQLObjects() {
        return new SQLObject[0];
    }

    protected synchronized void showErrorItems(IErrorItem[] items) {
        if (Thread.interrupted()) {
            return;
        }
        ISchemaObjectEditor editor = (ISchemaObjectEditor)this.getEditor();
        this.removeRememberedMarkers();
        if (items == null) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IMarker marker = null;
        try {
            int i = 0;
            while (i < items.length) {
                int severity = items[i].getSeverity();
                severity = severity == 2 ? 1 : (severity == 1 ? 0 : 2);
                marker = workspace.getRoot().createMarker("org.eclipse.core.resources.problemmarker");
                marker.setAttribute("message", (Object)items[i].getMessage());
                marker.setAttribute("userEditable", (Object)Boolean.FALSE);
                marker.setAttribute("severity", severity);
                marker.setAttribute("priority", 2);
                marker.setAttribute("transient", (Object)Boolean.TRUE);
                marker.setAttribute("location", (Object)(String.valueOf(((WorkbenchPart)editor).getPartName()) + ": " + this.getPageDescriptor().getPageName()));
                this._remembersMarkers.add(marker);
                ++i;
            }
        }
        catch (Exception e) {
            this._logger.error("SchemaObjectEditorPage_marker_creation_error", (Throwable)e);
        }
    }

    protected void removeRememberedMarkers() {
        if (this._remembersMarkers == null) {
            this._remembersMarkers = new ArrayList();
        }
        for (IMarker marker : this._remembersMarkers) {
            try {
                marker.delete();
            }
            catch (CoreException cex) {
                this._logger.error("SchemaObjectEditorPage_marker_remove_error", (Throwable)cex);
            }
        }
        this._remembersMarkers.clear();
    }

    protected DiagnosticChain getDiagnosticChain(TypedEvent event) {
        return new BasicDiagnostic();
    }

    public boolean isPageOpened() {
        return this._pageOpened;
    }

    public void modelRegenerated() {
        this.refresh();
    }

    public boolean aboutToSave(IProgressMonitor monitor) {
        return true;
    }

    public IErrorItem[] validateOnline(TypedEvent event) {
        this._isOnlineMode = true;
        IErrorItem[] errors = this.validate(event);
        this._isOnlineMode = false;
        return errors;
    }

    public void menuAboutToShow(IMenuManager manager) {
    }

    public String[] getPreferencePageIds() {
        return null;
    }

    public void setFocus(int itemType, Object item) {
        if (this.getPageDescriptor().getPageId() != null) {
            this.getEditor().setActivePage(this.getPageDescriptor().getPageId());
        }
    }

    public void enable(boolean enabled) {
    }

    public static class PageForm
    extends ManagedForm {
        public PageForm(SchemaObjectEditorPage page, ScrolledForm form) {
            super(page.getEditor().getToolkit(), form);
            this.setContainer(page);
        }

        public SchemaObjectEditorPage getPage() {
            return (SchemaObjectEditorPage)this.getContainer();
        }

        public void dirtyStateChanged() {
            this.getPage().getEditor().editorDirtyStateChanged();
        }

        public void staleStateChanged() {
            if (this.getPage().isActive()) {
                this.refresh();
            }
        }
    }
}

