/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.infer;

import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.wst.jsdt.core.ast.ASTVisitor;
import org.eclipse.wst.jsdt.core.ast.IASTNode;
import org.eclipse.wst.jsdt.core.ast.IAbstractFunctionDeclaration;
import org.eclipse.wst.jsdt.core.ast.IAbstractVariableDeclaration;
import org.eclipse.wst.jsdt.core.ast.IAllocationExpression;
import org.eclipse.wst.jsdt.core.ast.IArgument;
import org.eclipse.wst.jsdt.core.ast.IAssignment;
import org.eclipse.wst.jsdt.core.ast.IBinaryExpression;
import org.eclipse.wst.jsdt.core.ast.IExpression;
import org.eclipse.wst.jsdt.core.ast.IFalseLiteral;
import org.eclipse.wst.jsdt.core.ast.IFieldReference;
import org.eclipse.wst.jsdt.core.ast.IFunctionCall;
import org.eclipse.wst.jsdt.core.ast.IFunctionDeclaration;
import org.eclipse.wst.jsdt.core.ast.IFunctionExpression;
import org.eclipse.wst.jsdt.core.ast.IJsDoc;
import org.eclipse.wst.jsdt.core.ast.ILocalDeclaration;
import org.eclipse.wst.jsdt.core.ast.INumberLiteral;
import org.eclipse.wst.jsdt.core.ast.IObjectLiteral;
import org.eclipse.wst.jsdt.core.ast.IObjectLiteralField;
import org.eclipse.wst.jsdt.core.ast.IProgramElement;
import org.eclipse.wst.jsdt.core.ast.IReference;
import org.eclipse.wst.jsdt.core.ast.IReturnStatement;
import org.eclipse.wst.jsdt.core.ast.IScriptFileDeclaration;
import org.eclipse.wst.jsdt.core.ast.ISingleNameReference;
import org.eclipse.wst.jsdt.core.ast.IStringLiteral;
import org.eclipse.wst.jsdt.core.ast.IThisReference;
import org.eclipse.wst.jsdt.core.ast.ITrueLiteral;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.IInferEngine;
import org.eclipse.wst.jsdt.core.infer.InferOptions;
import org.eclipse.wst.jsdt.core.infer.InferredAttribute;
import org.eclipse.wst.jsdt.core.infer.InferredMember;
import org.eclipse.wst.jsdt.core.infer.InferredMethod;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.core.infer.InferrenceProvider;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.FunctionExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Javadoc;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocSingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ObjectLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.Reference;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.StringLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.ThisReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IIndexConstants;

public class InferEngine
extends ASTVisitor
implements IInferEngine {
    private InferredType fStringType;
    private InferredType fNumberType;
    private InferredType fBooleanType;
    private InferredType fFunctionType;
    private InferredType fArrayType;
    private InferredType fVoidType;
    private InferredType fObjectType;
    InferOptions inferOptions;
    CompilationUnitDeclaration compUnit;
    Context[] contexts = new Context[100];
    int contextPtr = -1;
    Context currentContext = new Context();
    protected int passNumber = 1;
    boolean isTopLevelAnonymousFunction;
    int anonymousCount = 0;
    public static boolean DEBUG = false;
    public InferrenceProvider inferenceProvider;
    public InferredType StringType = new InferredType(TypeConstants.JAVA_LANG_STRING[0]);
    public InferredType NumberType = new InferredType(TypeConstants.NUMBER[0]);
    public InferredType BooleanType = new InferredType(TypeConstants.BOOLEAN_OBJECT[0]);
    public InferredType FunctionType = new InferredType(TypeConstants.FUNCTION[0]);
    public InferredType ArrayType = new InferredType(TypeConstants.ARRAY[0]);
    public InferredType VoidType = new InferredType(TypeConstants.VOID);
    public InferredType ObjectType = new InferredType(TypeConstants.OBJECT);
    public InferredType GlobalType = new InferredType(InferredType.GLOBAL_NAME);
    public static HashtableOfObject WellKnownTypes = new HashtableOfObject();
    protected InferredType inferredGlobal;
    static final char[] CONSTRUCTOR_ID = new char[]{'c', 'o', 'n', 's', 't', 'r', 'u', 'c', 't', 'o', 'r'};
    private static boolean REPORT_INFER_TIME = false;

    public InferEngine() {
        this(new InferOptions());
    }

    public InferEngine(InferOptions inferOptions) {
        WellKnownTypes.put(TypeConstants.OBJECT, null);
        WellKnownTypes.put(TypeConstants.ARRAY[0], null);
        WellKnownTypes.put(TypeConstants.JAVA_LANG_STRING[0], null);
        WellKnownTypes.put(TypeConstants.NUMBER[0], null);
        WellKnownTypes.put(TypeConstants.BOOLEAN_OBJECT[0], null);
        WellKnownTypes.put(TypeConstants.FUNCTION[0], null);
        WellKnownTypes.put(new char[]{'D', 'a', 't', 'e'}, null);
        WellKnownTypes.put(new char[]{'M', 'a', 't', 'h'}, null);
        WellKnownTypes.put(new char[]{'R', 'e', 'g', 'E', 'x', 'p'}, null);
        WellKnownTypes.put(new char[]{'E', 'r', 'r', 'o', 'r'}, null);
        this.inferredGlobal = null;
        this.inferOptions = inferOptions;
    }

    @Override
    public void initialize() {
        this.contextPtr = -1;
        this.currentContext = new Context();
        this.passNumber = 1;
        this.isTopLevelAnonymousFunction = false;
        this.anonymousCount = 0;
        this.inferredGlobal = null;
    }

    @Override
    public void setCompilationUnit(CompilationUnitDeclaration scriptFileDeclaration) {
        this.compUnit = scriptFileDeclaration;
        this.buildDefinedMembers(scriptFileDeclaration.getStatements(), null);
    }

    @Override
    public boolean visit(IFunctionCall functionCall) {
        boolean visitChildren = this.handleFunctionCall(functionCall);
        if (visitChildren && functionCall.getReceiver() instanceof FunctionExpression) {
            MethodDeclaration methodDeclaration;
            if (this.contextPtr == -1) {
                this.isTopLevelAnonymousFunction = true;
            }
            if (functionCall instanceof MessageSend && ((MessageSend)functionCall).getArguments() != null && (methodDeclaration = ((FunctionExpression)functionCall.getReceiver()).getMethodDeclaration()) != null && methodDeclaration.getArguments() != null) {
                IArgument[] declaredArguments = methodDeclaration.getArguments();
                IExpression[] sentArguments = ((MessageSend)functionCall).getArguments();
                int i = 0;
                while (i < declaredArguments.length) {
                    if (i < sentArguments.length) {
                        this.handleFunctionDeclarationArgument(declaredArguments[i], sentArguments[i]);
                    }
                    ++i;
                }
            }
        }
        return visitChildren;
    }

    protected void handleFunctionDeclarationArgument(IArgument declaredArgument, IExpression sentArgument) {
        if (!declaredArgument.isType() && declaredArgument.getInferredType() == null) {
            char[] parameterName;
            if (sentArgument instanceof SingleNameReference) {
                char[] parameterName2;
                InferredType inferredType = this.getInferredType(sentArgument);
                if (inferredType == null && (parameterName2 = this.getName(sentArgument)) != null && this.isGlobal(parameterName2)) {
                    inferredType = this.createAnonymousGlobalType(parameterName2);
                }
                declaredArgument.setInferredType(inferredType);
            } else if (sentArgument instanceof ThisReference && this.isTopLevelAnonymousFunction && (parameterName = declaredArgument.getName()) != null) {
                InferredType inferredType = this.createAnonymousGlobalType(parameterName);
                declaredArgument.setInferredType(inferredType);
            }
        }
    }

    @Override
    public boolean visit(ILocalDeclaration localDeclaration) {
        boolean keepVisiting;
        this.currentContext.addMember(localDeclaration.getName(), localDeclaration);
        this.pushContext();
        this.currentContext.currentLocalDeclaration = localDeclaration;
        if (this.passNumber == 1 && localDeclaration instanceof LocalDeclaration && this.currentContext.currentMethod == null) {
            ((LocalDeclaration)localDeclaration).setIsLocal(false);
        }
        if (localDeclaration.getJsDoc() != null) {
            InferredType type;
            Javadoc javadoc = (Javadoc)localDeclaration.getJsDoc();
            this.createTypeIfNecessary(javadoc);
            InferredAttribute attribute = null;
            if (javadoc.memberOf != null) {
                type = this.addType(javadoc.memberOf.getFullTypeName(), true);
                int nameStart = localDeclaration.sourceStart();
                attribute = type.addAttribute(localDeclaration.getName(), localDeclaration, nameStart);
                this.handleAttributeDeclaration(attribute, localDeclaration.getInitialization());
                if (localDeclaration.getInitialization() != null) {
                    attribute.initializationStart = localDeclaration.getInitialization().sourceStart();
                    attribute.type = this.getTypeOf(localDeclaration.getInitialization());
                }
                attribute.inType = type;
            }
            if (javadoc.returnType != null) {
                type = this.addType(this.changePrimitiveToObject(javadoc.returnType.getFullTypeName()));
                localDeclaration.setInferredType(type);
                if (attribute != null) {
                    attribute.type = type;
                }
            }
        }
        if (localDeclaration.getInitialization() instanceof IFunctionExpression && !(keepVisiting = this.handleFunctionExpressionLocalDeclaration(localDeclaration))) {
            return false;
        }
        if (localDeclaration.getInitialization() != null) {
            if (localDeclaration.getInitialization() instanceof MessageSend) {
                this.handleFunctionCall((IFunctionCall)localDeclaration.getInitialization(), (LocalDeclaration)localDeclaration);
                if (((MessageSend)localDeclaration.getInitialization()).receiver instanceof IFunctionExpression && this.passNumber == 2 && ((FunctionExpression)((MessageSend)localDeclaration.getInitialization()).receiver).methodDeclaration != null) {
                    localDeclaration.setInferredType(((FunctionExpression)((MessageSend)localDeclaration.getInitialization()).receiver).methodDeclaration.inferredType);
                }
            } else {
                if (this.isExpressionAType(localDeclaration.getInitialization())) {
                    localDeclaration.setIsType(true);
                    this.handleLocalDeclarationExpressionType(localDeclaration);
                }
                InferredType type = this.getTypeForVariableInitialization(localDeclaration.getName(), localDeclaration.getInitialization());
                if (localDeclaration.getInferredType() == null || type != null && type.isAnonymous) {
                    localDeclaration.setInferredType(type);
                }
            }
        }
        return true;
    }

    @Override
    public void endVisit(ILocalDeclaration localDeclaration) {
        this.popContext();
    }

    private void createTypeIfNecessary(Javadoc javadoc) {
        if (javadoc.memberOf != null) {
            Object namespace = new char[][]{};
            char[][] typeName = javadoc.memberOf.getTypeName();
            if (javadoc.namespace != null) {
                namespace = javadoc.namespace.getTypeName();
            }
            char[] name = CharOperation.concat(CharOperation.concatWith(namespace, '.'), CharOperation.concatWith(typeName, '.'), '.');
            this.currentContext.currentType = this.addType(name);
            if (javadoc.extendsType != null) {
                char[] superName = CharOperation.concatWith(javadoc.extendsType.getTypeName(), '.');
                this.currentContext.currentType.setSuperType(this.addType(superName));
            }
            this.currentContext.isJsDocClass = true;
        }
    }

    @Override
    public boolean visit(IAssignment assignment) {
        IAbstractVariableDeclaration existingVarDecl = null;
        IAssignment existingAssignmentDecl = null;
        if (assignment.getLeftHandSide() instanceof ISingleNameReference && (existingVarDecl = this.getVariable(assignment.getLeftHandSide())) == null && (existingAssignmentDecl = this.getAssignment(assignment.getLeftHandSide())) == null) {
            this.currentContext.addMember(this.getName(assignment.getLeftHandSide()), assignment);
        }
        this.pushContext();
        this.currentContext.currentAssignment = assignment;
        if (this.passNumber == 1 && assignment instanceof Assignment && this.currentContext.currentMethod != null) {
            ((Assignment)assignment).setContainingFunction(this.currentContext.currentMethod);
        }
        IExpression assignmentExpression = assignment.getExpression();
        if (!this.handlePotentialType(assignment)) {
            if (assignmentExpression instanceof FunctionExpression) {
                boolean keepVisiting = this.handleFunctionExpressionAssignment(assignment);
                if (assignment.getInferredType() != null && existingVarDecl != null && existingVarDecl.getInferredType() == null) {
                    existingVarDecl.setInferredType(assignment.getInferredType());
                }
                if (!keepVisiting) {
                    return false;
                }
            } else if (assignmentExpression instanceof SingleNameReference && this.currentContext.currentType != null && InferEngine.isThis(assignment.getLeftHandSide())) {
                ISingleNameReference snr = (ISingleNameReference)assignmentExpression;
                Object object = this.currentContext.getMember(snr.getToken());
                IFieldReference fieldReference = (IFieldReference)assignment.getLeftHandSide();
                char[] memberName = fieldReference.getToken();
                InferredMember member = null;
                int nameStart = fieldReference.sourceEnd() - memberName.length + 1;
                if (object instanceof MethodDeclaration) {
                    MethodDeclaration method = (MethodDeclaration)object;
                    member = this.currentContext.currentType.addMethod(memberName, method, nameStart);
                } else {
                    member = this.currentContext.currentType.addAttribute(memberName, assignment, nameStart);
                    this.handleAttributeDeclaration((InferredAttribute)member, assignment.getExpression());
                    if (member.type == null) {
                        member.type = this.getTypeOf(assignmentExpression);
                    }
                }
                if (member != null) {
                    member.isStatic = false;
                }
            } else {
                if (assignment.getLeftHandSide() instanceof ISingleNameReference) {
                    char[] variableName = this.getName(assignment);
                    InferredType existingType = null;
                    if (existingVarDecl != null) {
                        existingType = existingVarDecl.getInferredType();
                    } else if (existingAssignmentDecl != null) {
                        existingType = existingAssignmentDecl.getInferredType();
                    }
                    InferredType type = null;
                    if (existingType == null) {
                        type = this.getTypeForVariableInitialization(variableName, assignmentExpression);
                        if (this.isExpressionAType(assignmentExpression)) {
                            assignment.setIsType(true);
                        }
                    } else {
                        InferredType newAssignmentType = this.getTypeOf(assignmentExpression);
                        if (newAssignmentType != null && existingType != newAssignmentType) {
                            InferredType newCombinedType = null;
                            if (!(existingType.isAnonymous || existingType.isGlobal() || existingVarDecl instanceof IArgument)) {
                                newCombinedType = existingVarDecl instanceof LocalDeclaration && ((LocalDeclaration)existingVarDecl).isLocal() ? this.createAnonymousType(existingVarDecl, null) : this.createAnonymousGlobalType(variableName);
                                newCombinedType.setIsDefinition(true);
                                if (existingType.isIndexed()) {
                                    newCombinedType.addMixin(existingType.getName());
                                } else {
                                    newCombinedType.mixin(existingType);
                                }
                            } else {
                                newCombinedType = existingType;
                            }
                            if (newAssignmentType.isIndexed()) {
                                newCombinedType.addMixin(newAssignmentType.getName());
                            } else {
                                newCombinedType.mixin(newAssignmentType);
                            }
                            type = newCombinedType;
                        }
                    }
                    if (type != null) {
                        assignment.setInferredType(type);
                        if (existingVarDecl != null) {
                            existingVarDecl.setInferredType(type);
                        }
                        if (existingAssignmentDecl != null) {
                            existingAssignmentDecl.setInferredType(type);
                        }
                    }
                    return true;
                }
                if (assignmentExpression instanceof AllocationExpression && ((AllocationExpression)assignmentExpression).member instanceof FunctionExpression) {
                    this.handleFunctionExpressionAssignment(assignment);
                } else if (assignmentExpression instanceof Assignment && ((Assignment)assignmentExpression).expression instanceof FunctionExpression) {
                    this.handleFunctionExpressionAssignment(assignment);
                } else if (this.inferOptions.useAssignments) {
                    IExpression lhs = assignment.getLeftHandSide();
                    if (lhs instanceof FieldReference || lhs instanceof ArrayReference) {
                        char[] typeName;
                        IFunctionDeclaration function;
                        Reference lhsRef = (Reference)lhs;
                        Expression receiver = null;
                        char[] attName = null;
                        int nameStart = 0;
                        if (lhsRef instanceof FieldReference) {
                            receiver = ((FieldReference)lhsRef).receiver;
                            attName = ((FieldReference)lhsRef).token;
                            nameStart = (int)(((FieldReference)lhsRef).nameSourcePosition >>> 32);
                        } else if (lhsRef instanceof ArrayReference && ((ArrayReference)lhsRef).position instanceof StringLiteral) {
                            receiver = ((ArrayReference)lhsRef).receiver;
                            attName = ((StringLiteral)((ArrayReference)lhsRef).position).source();
                            nameStart = ((StringLiteral)((ArrayReference)lhsRef).position).sourceStart + 1;
                        }
                        InferredType receiverType = this.getInferredType(receiver);
                        if (receiverType == null && (function = this.getDefinedFunction(receiver)) != null && (typeName = this.constructTypeName(receiver)) != null) {
                            receiverType = this.addType(typeName);
                        }
                        if (receiverType == null && this.passNumber == 2) {
                            receiverType = this.getReceiverType(receiver, true);
                        }
                        if (receiver != null && receiverType != null && attName != null && attName.length > 0) {
                            IExpression expression;
                            IAbstractVariableDeclaration varDecl;
                            if (!receiverType.isAnonymous && !this.isExpressionAType(receiver)) {
                                receiverType = this.createTypeToAssignTo(receiver, receiverType);
                                this.setTypeOf(receiver, receiverType);
                            }
                            if (receiverType != null && receiverType.getSuperType() != null && receiverType.getSuperType().isFunction() && (varDecl = this.getVariable(receiver)) != null && (expression = varDecl.getInitialization()) != null && expression instanceof IFunctionExpression) {
                                receiverType.setCorrespondingFunction(((IFunctionExpression)expression).getMethodDeclaration());
                            }
                            boolean isStatic = false;
                            if (!this.isExpressionAType(receiver)) {
                                receiverType = this.createTypeToAssignTo(receiver, receiverType);
                            } else if (!receiverType.isAnonymous && !receiver.isThis()) {
                                isStatic = true;
                            }
                            InferredMethod method = null;
                            InferredAttribute attr = receiverType.findAttribute(attName);
                            if (attr == null) {
                                method = receiverType.findMethod(attName, null);
                            } else if (this.passNumber == 2) {
                                this.handleAttributeDeclaration(attr);
                            }
                            if (method == null && attr == null || method == null && attr != null && attr.type == null) {
                                InferredType rhsType = assignment.getInferredType();
                                boolean isType = false;
                                if (rhsType != null && assignment.getInferredType() != null && assignment.isType() && this.isExpressionAType(receiver) && !receiverType.isAnonymous) {
                                    isType = true;
                                    char[] newTypeName = receiverType.getName();
                                    newTypeName = CharOperation.concat(newTypeName, attName, '.');
                                    if (rhsType.isAnonymous && !rhsType.isGlobal()) {
                                        this.convertAnonymousTypeToNamed(rhsType, newTypeName);
                                        rhsType.setIsDefinition(true);
                                        rhsType.setNameStart(assignment.sourceStart());
                                    } else if (!CharOperation.equals(newTypeName, rhsType.getName())) {
                                        InferredType newType = this.addType(newTypeName, true);
                                        rhsType.addSynonym(newType);
                                    }
                                }
                                IFunctionDeclaration definedFunction = null;
                                if (rhsType == null) {
                                    definedFunction = this.getDefinedFunction(assignmentExpression);
                                }
                                if (definedFunction != null) {
                                    method = receiverType.addMethod(attName, definedFunction, nameStart);
                                    receiverType.setIsDefinition(true);
                                    method.isStatic = isStatic;
                                } else {
                                    int nameStart_ = nameStart;
                                    attr = receiverType.addAttribute(attName, assignment, nameStart_);
                                    receiverType.setIsDefinition(true);
                                    this.handleAttributeDeclaration(attr, assignmentExpression);
                                    if (rhsType == null) {
                                        if (receiver instanceof IThisReference && this.currentContext.currentType == this.getInferredGlobal(false)) {
                                            rhsType = this.getTypeForVariableInitialization(attName, assignmentExpression);
                                        } else {
                                            rhsType = this.getTypeOf(assignmentExpression);
                                            if (receiverType != null && rhsType != null && receiverType.isGlobal() && rhsType.isAnonymous) {
                                                char[] globalAttName = InferEngine.createAnonymousGlobalTypeName(attName);
                                                this.convertAnonymousTypeToNamed(rhsType, globalAttName);
                                            }
                                            if (rhsType != null && rhsType.getSuperType() != null && rhsType.getSuperType().isFunction() && rhsType.getCorrespondingFunction() != null) {
                                                method = receiverType.addMethod(attName, rhsType.getCorrespondingFunction(), nameStart);
                                                method.isStatic = isStatic;
                                            }
                                        }
                                    }
                                    char[] possibleTypeName = this.constructTypeName(receiver);
                                    boolean bl = attr.isStatic = isStatic || possibleTypeName != null && this.compUnit.findInferredType(possibleTypeName) != null;
                                    if (attr.type == null || rhsType != null) {
                                        attr.type = rhsType;
                                        attr.setIsType(isType);
                                    }
                                    if (rhsType != null) {
                                        assignment.setInferredType(rhsType);
                                    }
                                }
                            } else if (method == null && attr != null && attr.type != null && attr.type.getSuperType() != null && attr.type.getSuperType().isFunction() && attr.type.getCorrespondingFunction() != null) {
                                method = receiverType.addMethod(attName, attr.type.getCorrespondingFunction(), nameStart);
                                receiverType.setIsDefinition(true);
                                method.isStatic = isStatic;
                            }
                        }
                    } else if (assignment.getInferredType() == null) {
                        InferredType rhsType = this.getTypeOf(assignment.getExpression());
                        assignment.setInferredType(rhsType);
                    }
                    if (this.isRootGlobal(lhs)) {
                        InferredType rhsType;
                        char[] lhsName = this.constructTypeName(assignment.getLeftHandSide());
                        char[] rhsName = this.constructTypeName(assignment.getExpression());
                        if (lhsName != null && lhsName.length > 0 && rhsName != null && rhsName.length > 0 && (rhsType = this.findDefinedType(rhsName)) != null) {
                            InferredType lhsType = this.addType(lhsName, true);
                            lhsType.setNameStart(lhs.sourceStart());
                            lhsType.addSynonym(rhsType);
                        }
                    }
                }
            }
        }
        return true;
    }

    protected InferredType createAnonymousType(char[] possibleTypeName, InferredType currentType) {
        char[] name;
        if (this.isKnownType(possibleTypeName)) {
            name = possibleTypeName;
        } else {
            char[] cs = String.valueOf(this.anonymousCount++).toCharArray();
            name = CharOperation.concat(ANONYMOUS_PREFIX, possibleTypeName, cs);
        }
        InferredType type = this.addType(name, true);
        type.isAnonymous = true;
        type.setIsGlobal(false);
        if (currentType != null) {
            type.setSuperType(currentType);
        }
        return type;
    }

    protected InferredType createAnonymousType(IASTNode forNode, InferredType parrentType) {
        char[] name = InferEngine.createAnonymousTypeName(forNode);
        InferredType type = this.addType(name, true);
        type.isAnonymous = true;
        type.setIsGlobal(false);
        if (parrentType != null) {
            type.setSuperType(parrentType);
        }
        return type;
    }

    private InferredType createAnonymousType(IAbstractVariableDeclaration var) {
        InferredType currentType = var.getInferredType();
        if (currentType == null || !currentType.isAnonymous) {
            InferredType type = this.createAnonymousType(var, currentType);
            var.setInferredType(type);
        }
        return var.getInferredType();
    }

    private InferredType createAnonymousType(IObjectLiteral objLit) {
        InferredType anonType = objLit.getInferredType();
        if (anonType == null) {
            char[] name = InferEngine.createAnonymousTypeName(objLit);
            anonType = this.addType(name, true);
            anonType.isAnonymous = true;
            anonType.isObjectLiteral = true;
            anonType.setSuperType(this.getObjectType());
            anonType.setIsGlobal(false);
            anonType.sourceStart = objLit.sourceStart();
            anonType.sourceEnd = objLit.sourceEnd();
        }
        this.populateType(anonType, objLit, false);
        return anonType;
    }

    protected InferredType createAnonymousGlobalType(char[] varName) {
        char[] name = InferEngine.createAnonymousGlobalTypeName(varName);
        InferredType globalType = this.compUnit.findInferredType(name);
        if (globalType == null) {
            globalType = this.addType(name, false);
            globalType.isAnonymous = true;
            globalType.isObjectLiteral = true;
            globalType.setSuperType(this.getObjectType());
            globalType.setIsGlobal(true);
        }
        return globalType;
    }

    protected static char[] createAnonymousTypeName(IASTNode node) {
        char[] loc = (String.valueOf(String.valueOf(node.sourceStart())) + '_' + String.valueOf(node.sourceEnd())).toCharArray();
        return CharOperation.concat(ANONYMOUS_PREFIX, ANONYMOUS_CLASS_ID, loc);
    }

    public static char[] createAnonymousGlobalTypeName(char[] varName) {
        return CharOperation.concat(CharOperation.concat(ANONYMOUS_PREFIX, ANONYMOUS_CLASS_ID), varName, '_');
    }

    protected boolean handleFunctionExpressionAssignment(IAssignment assignment) {
        IFunctionExpression functionExpression = null;
        if (assignment.getExpression() instanceof IFunctionExpression) {
            functionExpression = (IFunctionExpression)assignment.getExpression();
        } else if (assignment.getExpression() instanceof IAllocationExpression) {
            functionExpression = (IFunctionExpression)((IAllocationExpression)((Object)assignment.getExpression())).getMember();
        } else if (assignment.getExpression() instanceof IAssignment) {
            functionExpression = (FunctionExpression)((IAssignment)assignment.getExpression()).getExpression();
        }
        if (functionExpression == null) {
            return false;
        }
        MethodDeclaration methodDeclaration = functionExpression.getMethodDeclaration();
        char[] possibleTypeName = this.constructTypeName(assignment.getLeftHandSide());
        InferredType type = null;
        if (possibleTypeName != null) {
            type = this.compUnit.findInferredType(possibleTypeName);
            if (type == null && this.isPossibleClassName(possibleTypeName)) {
                type = this.addType(possibleTypeName, true);
            }
            if (type == null && methodDeclaration.getJsDoc() != null && ((Javadoc)methodDeclaration.getJsDoc()).isConstructor) {
                type = this.addType(possibleTypeName, true);
                this.handleJSDocConstructor(type, methodDeclaration, assignment.sourceStart());
            }
        }
        if (type != null) {
            if (this.inferOptions.useInitMethod) {
                this.currentContext.currentType = type;
                int nameStart = assignment.getLeftHandSide().sourceStart();
                int expressionEnd = assignment.getExpression().sourceEnd();
                this.handleConstructor(type, methodDeclaration, nameStart, expressionEnd);
                assignment.setInferredType(type);
                if (this.currentContext.currentLocalDeclaration != null && CharOperation.equals(this.currentContext.currentLocalDeclaration.getName(), this.getName(assignment))) {
                    this.currentContext.currentLocalDeclaration.setInferredType(type);
                }
                methodDeclaration.setIsAnonymous(true);
            }
        } else if (assignment.getLeftHandSide() instanceof FieldReference || assignment.getLeftHandSide() instanceof ArrayReference) {
            Reference ref = (Reference)assignment.getLeftHandSide();
            Expression receiver = null;
            char[] methodName = null;
            int nameStart = 0;
            if (ref instanceof FieldReference) {
                receiver = ((FieldReference)ref).receiver;
                methodName = ((FieldReference)ref).token;
                nameStart = (int)(((FieldReference)ref).nameSourcePosition >>> 32);
            } else if (ref instanceof ArrayReference && ((ArrayReference)ref).position instanceof StringLiteral) {
                receiver = ((ArrayReference)ref).receiver;
                methodName = ((StringLiteral)((ArrayReference)ref).position).source();
                nameStart = ((StringLiteral)((ArrayReference)ref).position).sourceStart + 1;
            }
            if (receiver == null) {
                return false;
            }
            InferredType receiverType = this.getInferredType(receiver);
            if (receiverType == null && this.passNumber == 2) {
                receiverType = this.getReceiverType(receiver, true);
            }
            if (receiverType != null && methodName != null) {
                InferredMethod method;
                if (!receiver.isThis()) {
                    receiverType = this.createTypeToAssignTo(receiver, receiverType);
                }
                if ((method = receiverType.findMethod(methodName, methodDeclaration)) == null) {
                    method = receiverType.addMethod(methodName, methodDeclaration, nameStart);
                    receiverType.setIsDefinition(true);
                    char[] possibleInTypeName = this.constructTypeName(receiver);
                    method.isStatic = possibleInTypeName != null && this.compUnit.findInferredType(possibleInTypeName) != null;
                    return true;
                }
                if (this.passNumber == 2) {
                    return false;
                }
            } else if (this.passNumber == 2 && methodName != null && (receiverType = this.getReceiverType(receiver, false)) != null) {
                InferredMethod method = receiverType.addMethod(methodName, methodDeclaration, nameStart);
                method.isStatic = !receiverType.isObjectLiteral;
                receiverType.updatePositions(assignment.sourceStart(), assignment.sourceEnd());
            }
        } else if (assignment.getLeftHandSide() instanceof SingleNameReference && this.passNumber == 2) {
            assignment.setInferredType(this.getTypeOf(assignment.getExpression()));
            methodDeclaration.setIsAnonymous(true);
            methodDeclaration.setSelector(((SingleNameReference)assignment.getLeftHandSide()).token);
            methodDeclaration.sourceStart = ((SingleNameReference)assignment.getLeftHandSide()).sourceStart();
        }
        return true;
    }

    private boolean handleFunctionExpressionLocalDeclaration(ILocalDeclaration localDeclaration) {
        boolean keepVisiting = true;
        IFunctionExpression functionExpression = null;
        IExpression expression = localDeclaration.getInitialization();
        if (expression instanceof IFunctionExpression) {
            functionExpression = (IFunctionExpression)expression;
        } else if (expression instanceof IAllocationExpression) {
            functionExpression = (IFunctionExpression)((IAllocationExpression)((Object)expression)).getMember();
        } else if (expression instanceof IAssignment) {
            functionExpression = (FunctionExpression)((IAssignment)expression).getExpression();
        }
        if (functionExpression == null) {
            return false;
        }
        MethodDeclaration methodDeclaration = functionExpression.getMethodDeclaration();
        char[] possibleTypeName = localDeclaration.getName();
        InferredType type = null;
        if (possibleTypeName != null) {
            type = this.compUnit.findInferredType(possibleTypeName);
            if (type == null && this.isPossibleClassName(possibleTypeName)) {
                type = this.addType(possibleTypeName, true);
            }
            if (type == null && methodDeclaration.getJsDoc() != null && ((Javadoc)methodDeclaration.getJsDoc()).isConstructor) {
                type = this.addType(possibleTypeName, true);
                this.handleJSDocConstructor(type, methodDeclaration, localDeclaration.sourceStart());
            }
        }
        if (type != null) {
            if (this.inferOptions.useInitMethod) {
                this.currentContext.currentType = type;
                type.setIsDefinition(true);
                int nameStart = localDeclaration.sourceStart();
                type.addConstructorMethod(type.name, methodDeclaration, nameStart);
                type.updatePositions(nameStart, localDeclaration.getInitialization().sourceEnd());
                localDeclaration.setInferredType(type);
                localDeclaration.setIsType(true);
            }
            keepVisiting = false;
        }
        return keepVisiting;
    }

    protected boolean handleLocalDeclarationExpressionType(ILocalDeclaration localDeclaration) {
        IExpression expr = localDeclaration.getInitialization();
        InferredType type = null;
        if (expr instanceof IAssignment) {
            type = ((IAssignment)expr).getInferredType();
        } else if (expr instanceof IAbstractVariableDeclaration) {
            type = ((IAbstractVariableDeclaration)((Object)expr)).getInferredType();
        } else if (expr instanceof IFieldReference) {
            InferredAttribute attr;
            IExpression receiver = ((IFieldReference)expr).getReceiver();
            InferredType receiverType = this.getTypeOf(receiver);
            if (receiverType != null && (attr = receiverType.findAttribute(((IFieldReference)expr).getToken())) != null) {
                type = attr.inType;
            }
        } else if (expr instanceof ISingleNameReference) {
            IAbstractFunctionDeclaration funcDecl;
            IAssignment assign;
            IAbstractVariableDeclaration varDecl = this.getVariable(expr);
            if (varDecl != null) {
                type = varDecl.getInferredType();
            }
            if (type == null && (assign = this.getAssignment(expr)) != null) {
                type = assign.getInferredType();
            }
            if (type == null && (funcDecl = this.getFunction(expr)) != null && funcDecl.getName() != null) {
                type = this.findDefinedType(funcDecl.getName());
            }
            if (type == null) {
                type = this.compUnit.findInferredType(((ISingleNameReference)expr).getToken());
            }
        } else if (expr instanceof IThisReference) {
            InferredType newType = null;
            IFunctionDeclaration parentMethod = this.currentContext.currentMethod;
            IAssignment parentAssignment = ((Context)this.currentContext).parent.currentAssignment;
            ILocalDeclaration parentLocalDeclaration = ((Context)this.currentContext).parent.currentLocalDeclaration;
            char[] newTypeName = null;
            int typeStart = 0;
            int typeEnd = 0;
            if (this.currentContext.parent != null && parentAssignment != null && parentAssignment.getExpression() instanceof IFunctionExpression && ((IFunctionExpression)parentAssignment.getExpression()).getMethodDeclaration() == parentMethod) {
                newTypeName = parentAssignment.getLeftHandSide().getASTType() == 37 && ((Expression)((IFieldReference)parentAssignment.getLeftHandSide()).getReceiver()).isPrototype() ? Util.getTypeName(((IFieldReference)((IFieldReference)parentAssignment.getLeftHandSide()).getReceiver()).getReceiver()) : Util.getTypeName(parentAssignment.getLeftHandSide());
                typeStart = parentAssignment.sourceStart();
                typeEnd = parentAssignment.sourceEnd();
            } else if (this.currentContext.parent != null && parentLocalDeclaration != null && parentLocalDeclaration.getInitialization() instanceof IFunctionExpression && ((IFunctionExpression)parentLocalDeclaration.getInitialization()).getMethodDeclaration() == parentMethod) {
                newTypeName = parentLocalDeclaration.getName();
                typeStart = parentLocalDeclaration.sourceStart();
                typeEnd = parentLocalDeclaration.sourceEnd();
            } else if (parentMethod != null && parentMethod.getName() != null && (parentMethod.getInferredMethod() == null || parentMethod.getInferredMethod().inType == null)) {
                newTypeName = parentMethod.getName();
                typeStart = parentMethod.sourceStart();
                typeEnd = parentMethod.sourceEnd();
            }
            if (newTypeName != null) {
                newType = this.compUnit.findInferredType(newTypeName);
                if (newType == null) {
                    newType = this.addType(newTypeName);
                }
            } else {
                return false;
            }
            newType.setIsDefinition(true);
            newType.updatePositions(typeStart, typeEnd);
            type = newType;
        }
        if (this.passNumber == 1 && expr instanceof IObjectLiteral) {
            return false;
        }
        if (type != null) {
            this.setTypeOf(expr, type);
            if (localDeclaration instanceof AbstractVariableDeclaration) {
                ((AbstractVariableDeclaration)((Object)localDeclaration)).setInferredType(type);
            }
            return true;
        }
        return false;
    }

    protected boolean handlePotentialType(IAssignment assignment) {
        IExpression lhs = assignment.getLeftHandSide();
        if (lhs instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)lhs;
            if (fieldReference.isPrototype()) {
                InferredType superType;
                InferredType newType = null;
                char[] possibleTypeName = this.constructTypeName(fieldReference.getReceiver());
                if (possibleTypeName == null) {
                    return true;
                }
                newType = this.compUnit.findInferredType(possibleTypeName);
                if (newType == null) {
                    IAbstractFunctionDeclaration theFunction = this.getFunction(fieldReference.getReceiver());
                    IAbstractVariableDeclaration theVariable = null;
                    if (theFunction == null) {
                        theVariable = this.getVariable(fieldReference.getReceiver());
                    }
                    if (theFunction != null ? theFunction.getInferredType() != null && !theFunction.getInferredType().isVoid() : theVariable != null && theVariable.getInitialization() != null && theVariable.getInitialization() instanceof IFunctionExpression && ((IFunctionExpression)theVariable.getInitialization()).getMethodDeclaration().getInferredType() != null && !((IFunctionExpression)theVariable.getInitialization()).getMethodDeclaration().getInferredType().isVoid()) {
                        return false;
                    }
                    newType = this.addType(possibleTypeName, true);
                }
                newType.setIsDefinition(true);
                newType.updatePositions(assignment.sourceStart(), assignment.sourceEnd());
                if (assignment.getExpression() instanceof IAllocationExpression) {
                    IAllocationExpression allocationExpression = (IAllocationExpression)((Object)assignment.getExpression());
                    InferredType superType2 = null;
                    char[] possibleSuperTypeName = this.constructTypeName(allocationExpression.getMember());
                    if (possibleSuperTypeName != null) {
                        superType2 = this.compUnit.findInferredType(possibleSuperTypeName);
                        if (superType2 == null) {
                            superType2 = this.addType(possibleSuperTypeName);
                        }
                        if (newType.getSuperType() == null) {
                            newType.setSuperType(superType2);
                        }
                    }
                    return true;
                }
                if (assignment.getExpression() instanceof IObjectLiteral) {
                    this.populateType(newType, (IObjectLiteral)assignment.getExpression(), false);
                    if (newType.getSuperType() == null) {
                        newType.setSuperType(this.getObjectType());
                    }
                    return true;
                }
                if (assignment.getExpression() instanceof FieldReference) {
                    superType = this.getTypeOf(assignment.getExpression());
                    if (newType.getSuperType() == null && superType != null) {
                        newType.setSuperType(superType);
                    }
                    return true;
                }
                if (assignment.getExpression() instanceof SingleNameReference) {
                    superType = this.getTypeOf(assignment.getExpression());
                    if (newType.getSuperType() == null && superType != null) {
                        newType.setSuperType(superType);
                    }
                    return true;
                }
            } else {
                if (fieldReference.receiver.isPrototype()) {
                    FieldReference prototype = (FieldReference)fieldReference.receiver;
                    InferredType assignedToType = null;
                    if (this.isExpressionAType(prototype.receiver)) {
                        assignedToType = this.getTypeOf(prototype.receiver);
                    }
                    if (assignedToType == null) {
                        char[] possibleTypeName = this.constructTypeName(prototype.receiver);
                        if (possibleTypeName != null) {
                            assignedToType = this.addType(possibleTypeName);
                            assignedToType.updatePositions(assignment.sourceStart(), assignment.sourceEnd());
                            assignedToType.setIsDefinition(true);
                        } else {
                            return true;
                        }
                    }
                    if (this.passNumber == 1 && assignment.getExpression() instanceof IObjectLiteral) {
                        return false;
                    }
                    char[] memberName = fieldReference.token;
                    int nameStart = (int)(fieldReference.nameSourcePosition >>> 32);
                    InferredType typeOf = assignment.getJsDoc() != null && assignment.getJsDoc() instanceof Javadoc && ((Javadoc)assignment.getJsDoc()).returnType != null ? this.addType(this.changePrimitiveToObject(((Javadoc)assignment.getJsDoc()).returnType.getFullTypeName())) : this.getTypeOf(assignment.getExpression());
                    IFunctionDeclaration methodDecl = null;
                    if (typeOf == null || typeOf == this.getFunctionType()) {
                        methodDecl = this.getDefinedFunction(assignment.getExpression());
                    }
                    if (methodDecl != null) {
                        assignedToType.addMethod(memberName, methodDecl, nameStart);
                    } else {
                        InferredAttribute attribute = assignedToType.addAttribute(memberName, assignment, nameStart);
                        this.handleAttributeDeclaration(attribute, assignment.getExpression());
                        attribute.initializationStart = assignment.getExpression().sourceStart();
                        if (attribute.type == null) {
                            attribute.type = typeOf;
                        }
                    }
                    return true;
                }
                if (fieldReference.receiver instanceof IThisReference) {
                    InferredType newType = null;
                    IFunctionDeclaration parentMethod = this.currentContext.currentMethod;
                    IAssignment parentAssignment = ((Context)this.currentContext).parent.currentAssignment;
                    ILocalDeclaration parentLocalDeclaration = ((Context)this.currentContext).parent.currentLocalDeclaration;
                    char[] newTypeName = null;
                    int typeStart = 0;
                    int typeEnd = 0;
                    if (this.currentContext.parent != null && parentAssignment != null && parentAssignment.getExpression() instanceof IFunctionExpression && ((IFunctionExpression)parentAssignment.getExpression()).getMethodDeclaration() == parentMethod) {
                        newTypeName = parentAssignment.getLeftHandSide().getASTType() == 37 && ((Expression)((IFieldReference)parentAssignment.getLeftHandSide()).getReceiver()).isPrototype() ? Util.getTypeName(((IFieldReference)((IFieldReference)parentAssignment.getLeftHandSide()).getReceiver()).getReceiver()) : Util.getTypeName(parentAssignment.getLeftHandSide());
                        typeStart = parentAssignment.sourceStart();
                        typeEnd = parentAssignment.sourceEnd();
                    } else if (this.currentContext.parent != null && parentLocalDeclaration != null && parentLocalDeclaration.getInitialization() instanceof IFunctionExpression && ((IFunctionExpression)parentLocalDeclaration.getInitialization()).getMethodDeclaration() == parentMethod) {
                        newTypeName = parentLocalDeclaration.getName();
                        typeStart = parentLocalDeclaration.sourceStart();
                        typeEnd = parentLocalDeclaration.sourceEnd();
                    } else if (parentMethod != null && parentMethod.getName() != null && (parentMethod.getInferredMethod() == null || parentMethod.getInferredMethod().inType == null)) {
                        newTypeName = parentMethod.getName();
                        typeStart = parentMethod.sourceStart();
                        typeEnd = parentMethod.sourceEnd();
                    }
                    if (newTypeName != null) {
                        newType = this.compUnit.findInferredType(newTypeName);
                        if (newType == null) {
                            newType = this.addType(newTypeName);
                        }
                    } else {
                        return false;
                    }
                    newType.setIsDefinition(true);
                    newType.updatePositions(typeStart, typeEnd);
                    if (parentAssignment != null) {
                        parentAssignment.setInferredType(newType);
                        parentAssignment.setIsType(true);
                    }
                    if (parentLocalDeclaration != null) {
                        parentLocalDeclaration.setInferredType(newType);
                        parentLocalDeclaration.setIsType(true);
                    }
                    if (this.passNumber == 1 && assignment.getExpression() instanceof IObjectLiteral) {
                        return false;
                    }
                    char[] memberName = fieldReference.token;
                    int nameStart = (int)(fieldReference.nameSourcePosition >>> 32);
                    InferredType typeOf = this.getTypeOf(assignment.getExpression());
                    IFunctionDeclaration methodDecl = null;
                    if (typeOf == null || typeOf == this.getFunctionType()) {
                        methodDecl = this.getDefinedFunction(assignment.getExpression());
                    }
                    if (methodDecl != null) {
                        newType.addMethod(memberName, methodDecl, nameStart);
                        if (methodDecl.getInferredType() == null && assignment.getJsDoc() != null && ((Javadoc)assignment.getJsDoc()).returnType != null && ((Javadoc)assignment.getJsDoc()).returnType.getFullTypeName() != null) {
                            methodDecl.setInferredType(this.addType(((Javadoc)assignment.getJsDoc()).returnType.getFullTypeName()));
                        }
                    } else {
                        InferredAttribute attribute = newType.addAttribute(memberName, assignment, nameStart);
                        if (attribute.type == null && assignment.getJsDoc() != null && ((Javadoc)assignment.getJsDoc()).returnType != null && ((Javadoc)assignment.getJsDoc()).returnType.getFullTypeName() != null) {
                            attribute.type = this.addType(((Javadoc)assignment.getJsDoc()).returnType.getFullTypeName());
                        }
                        this.handleAttributeDeclaration(attribute, assignment.getExpression());
                        attribute.initializationStart = assignment.getExpression().sourceStart();
                        if (attribute.type == null) {
                            attribute.type = typeOf;
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    protected IFunctionDeclaration getDefinedFunction(IExpression expression) {
        if (expression instanceof SingleNameReference) {
            Object object = this.currentContext.getMember(((SingleNameReference)expression).token);
            if (object instanceof AbstractMethodDeclaration) {
                return (MethodDeclaration)object;
            }
        } else {
            if (expression instanceof FunctionExpression) {
                return ((FunctionExpression)expression).methodDeclaration;
            }
            if (expression instanceof FieldReference) {
                InferredMethod method;
                FieldReference fieldReference = (FieldReference)expression;
                InferredType receiverType = this.getInferredType(fieldReference.receiver);
                if (receiverType == null && this.passNumber == 2) {
                    receiverType = this.getReceiverType(fieldReference.receiver, false);
                }
                if (receiverType != null && (method = receiverType.findMethod(fieldReference.token, null)) != null) {
                    return method.getFunctionDeclaration();
                }
            }
        }
        return null;
    }

    protected void setTypeOf(IExpression expression, InferredType type) {
        if (expression instanceof ISingleNameReference) {
            IAssignment varAssignment;
            InferredAttribute attribute;
            IAbstractVariableDeclaration varDecl = this.getVariable(expression);
            if (varDecl != null) {
                varDecl.setInferredType(type);
            }
            if (this.inferredGlobal != null && (attribute = this.inferredGlobal.findAttribute(((ISingleNameReference)expression).getToken())) != null) {
                attribute.type = type;
            }
            if ((varAssignment = this.getAssignment(expression)) != null) {
                varAssignment.setInferredType(type);
            }
        } else if (expression instanceof FieldReference) {
            InferredAttribute attr;
            FieldReference fieldReference = (FieldReference)expression;
            InferredType parentType = this.getTypeOf(fieldReference.getReceiver());
            if (parentType != null && (attr = parentType.findAttribute(fieldReference.token)) != null) {
                attr.type = type;
            }
        } else if (expression instanceof IObjectLiteral) {
            ((IObjectLiteral)expression).setInferredType(type);
        } else if (expression instanceof IThisReference) {
            this.currentContext.currentType = type;
        }
    }

    protected InferredType getTypeOf(IExpression expression) {
        if (expression instanceof IStringLiteral) {
            return this.getStringType();
        }
        if (expression instanceof INumberLiteral) {
            return this.getNumberType();
        }
        if (expression instanceof IAllocationExpression) {
            IAllocationExpression allocationExpression = (IAllocationExpression)((Object)expression);
            IExpression member = allocationExpression.getMember();
            InferredType type = null;
            char[] possibleTypeName = this.constructTypeName(member);
            if (possibleTypeName != null) {
                type = this.compUnit.findInferredType(possibleTypeName);
            }
            if (type == null) {
                type = this.getTypeOf(member);
            }
            if ((type == null || type == this.getFunctionType()) && possibleTypeName != null && possibleTypeName.length > 0) {
                type = this.addType(possibleTypeName, false);
            }
            return type;
        }
        if (expression instanceof ISingleNameReference) {
            InferredType type;
            InferredType type2;
            InferredType type3;
            InferredType type4;
            InferredAttribute attribute;
            IAbstractVariableDeclaration varDecl = this.getVariable(expression);
            if (varDecl != null) {
                return varDecl.getInferredType();
            }
            if (this.inferredGlobal != null && (attribute = this.inferredGlobal.findAttribute(((ISingleNameReference)expression).getToken())) != null) {
                return attribute.type;
            }
            IAssignment assign = this.getAssignment(expression);
            if (assign != null && (type4 = assign.getInferredType()) != null) {
                return type4;
            }
            IAbstractFunctionDeclaration funcDecl = this.getFunction(expression);
            if (funcDecl != null && (type3 = this.findDefinedType(funcDecl.getName())) != null) {
                return type3;
            }
            char[] possibleTypeName = this.constructTypeName(expression);
            if (possibleTypeName != null && (type2 = this.compUnit.findInferredType(possibleTypeName)) != null) {
                return type2;
            }
            char[] possibleGlobalTypeName = InferEngine.createAnonymousGlobalTypeName(((SingleNameReference)expression).token);
            if (possibleGlobalTypeName != null && (type = this.compUnit.findInferredType(possibleGlobalTypeName)) != null) {
                return type;
            }
            if (funcDecl != null) {
                return this.getFunctionType();
            }
        } else if (expression instanceof FieldReference) {
            InferredType type;
            char[] typeName;
            FieldReference fieldReference = (FieldReference)expression;
            if (fieldReference.receiver.isThis() && this.currentContext.currentType != null) {
                InferredAttribute attribute = this.currentContext.currentType.findAttribute(fieldReference.getToken());
                if (attribute != null) {
                    return attribute.type;
                }
            } else {
                InferredType recieverType = this.getReceiverType(((FieldReference)expression).getReceiver(), false);
                if (recieverType != null) {
                    char[] fieldName = ((FieldReference)expression).getToken();
                    InferredAttribute attr = recieverType.findAttribute(fieldName);
                    if (attr != null) {
                        return attr.type;
                    }
                    if (recieverType.findMethod(fieldName, null) != null) {
                        return this.getFunctionType();
                    }
                }
            }
            if ((typeName = this.constructTypeName(expression)) != null && typeName.length > 0 && (type = this.findDefinedType(typeName)) != null) {
                return type;
            }
        } else {
            if (expression instanceof IReturnStatement) {
                return ((IReturnStatement)((Object)expression)).getInferredType();
            }
            if (expression instanceof ArrayInitializer) {
                ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
                boolean typeSet = false;
                InferredType memberType = null;
                if (arrayInitializer.expressions != null) {
                    int i = 0;
                    while (i < arrayInitializer.expressions.length) {
                        InferredType thisType = this.getTypeOf(arrayInitializer.expressions[i]);
                        if (thisType != null) {
                            if (!thisType.equals(memberType)) {
                                memberType = !typeSet ? thisType : null;
                            }
                            typeSet = true;
                        }
                        ++i;
                    }
                }
                if (memberType != null) {
                    InferredType type = new InferredType(InferredType.ARRAY_NAME);
                    type.referenceClass = memberType;
                    return type;
                }
                return this.getArrayType();
            }
            if (expression instanceof ITrueLiteral || expression instanceof IFalseLiteral) {
                return this.getBooleanType();
            }
            if (expression instanceof IObjectLiteral) {
                InferredType type = this.createAnonymousType((IObjectLiteral)expression);
                type.sourceStart = expression.sourceStart();
                type.sourceEnd = expression.sourceEnd();
                return type;
            }
            if (expression instanceof IThisReference) {
                return this.currentContext.currentType != null ? this.currentContext.currentType : this.getInferredGlobal(true);
            }
            if (expression instanceof Assignment) {
                return this.getTypeOf(((Assignment)expression).getExpression());
            }
            if (expression instanceof FunctionExpression) {
                return this.getFunctionType();
            }
            if (expression instanceof UnaryExpression) {
                return this.getTypeOf(((UnaryExpression)expression).expression);
            }
            if (expression instanceof BinaryExpression) {
                BinaryExpression bExpression = (BinaryExpression)expression;
                int operator = (bExpression.bits & 0xFC0) >> 6;
                switch (operator) {
                    case 9: 
                    case 10: 
                    case 13: 
                    case 15: 
                    case 16: 
                    case 17: {
                        return this.getNumberType();
                    }
                    case 14: {
                        InferredType leftType = this.getTypeOf(bExpression.left);
                        InferredType rightType = this.getTypeOf(bExpression.right);
                        if (leftType != null && leftType.equals(this.getStringType())) {
                            return this.getStringType();
                        }
                        if (rightType != null && rightType.equals(this.getStringType())) {
                            return this.getStringType();
                        }
                        if (leftType == null || rightType == null) {
                            return null;
                        }
                        if (leftType.equals(this.getStringType()) || rightType.equals(this.getStringType())) {
                            return this.getStringType();
                        }
                        if (leftType.equals(this.getNumberType()) && rightType.equals(this.getNumberType())) {
                            return this.getNumberType();
                        }
                        return null;
                    }
                    case 0: 
                    case 1: {
                        if (this.currentContext.currentAssignment != null && InferEngine.expressionContains(this.currentContext.currentAssignment.getExpression(), bExpression) || this.currentContext.currentLocalDeclaration != null && InferEngine.expressionContains(this.currentContext.currentLocalDeclaration.getInitialization(), bExpression) || this.currentContext.currentReturn != null && InferEngine.expressionContains(this.currentContext.currentReturn.getExpression(), bExpression)) {
                            InferredType rightType;
                            InferredType leftType = this.getTypeOf(bExpression.left);
                            if (leftType == (rightType = this.getTypeOf(bExpression.right))) {
                                return leftType;
                            }
                            if (leftType != null && rightType != null) {
                                InferredType newCombinedType = this.createAnonymousType(expression, null);
                                if (leftType.isIndexed()) {
                                    newCombinedType.addMixin(leftType.getName());
                                } else {
                                    newCombinedType.mixin(leftType);
                                }
                                if (rightType.isIndexed()) {
                                    newCombinedType.addMixin(rightType.getName());
                                } else {
                                    newCombinedType.mixin(rightType);
                                }
                                return newCombinedType;
                            }
                            if (leftType != null) {
                                return leftType;
                            }
                            if (rightType != null) {
                                return rightType;
                            }
                        }
                        return this.getBooleanType();
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 18: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 29: {
                        return this.getBooleanType();
                    }
                }
                return null;
            }
            if (expression instanceof MessageSend) {
                Object method;
                if (((MessageSend)expression).receiver instanceof IFunctionExpression) {
                    if (((FunctionExpression)((MessageSend)expression).receiver).methodDeclaration != null) {
                        return ((FunctionExpression)((MessageSend)expression).receiver).methodDeclaration.inferredType;
                    }
                } else if (((MessageSend)expression).selector != null && (method = this.currentContext.getMember(((MessageSend)expression).selector)) instanceof MethodDeclaration) {
                    return ((MethodDeclaration)method).inferredType;
                }
            }
        }
        return null;
    }

    protected void populateType(InferredType type, IObjectLiteral objLit, boolean isStatic) {
        block19: {
            if (objLit.getInferredType() != null) break block19;
            objLit.setInferredType(type);
            if (objLit.getFields() == null) break block19;
            int i = 0;
            while (i < objLit.getFields().length) {
                block22: {
                    int nameStart;
                    char[] name;
                    IObjectLiteralField field;
                    block21: {
                        block20: {
                            field = objLit.getFields()[i];
                            name = null;
                            nameStart = -1;
                            if (!(field.getFieldName() instanceof SingleNameReference)) break block20;
                            SingleNameReference singleNameReference = (SingleNameReference)field.getFieldName();
                            name = singleNameReference.token;
                            nameStart = singleNameReference.sourceStart;
                            break block21;
                        }
                        if (!(field.getFieldName() instanceof IStringLiteral)) break block22;
                        IStringLiteral stringLiteral = (IStringLiteral)field.getFieldName();
                        name = stringLiteral.source();
                        nameStart = stringLiteral.sourceStart();
                    }
                    Javadoc javaDoc = (Javadoc)field.getJsDoc();
                    InferredType returnType = null;
                    if (javaDoc != null) {
                        InferredType previousType;
                        if (javaDoc.memberOf != null) {
                            char[] typeName = javaDoc.memberOf.getFullTypeName();
                            this.convertAnonymousTypeToNamed(type, typeName);
                            type.setIsDefinition(true);
                        } else if (this.currentContext.isJsDocClass && javaDoc.property != null && type.isAnonymous && (previousType = this.currentContext.currentType) != null) {
                            this.copyAnonymousTypeToNamed(type, previousType);
                            type = this.currentContext.currentType = previousType;
                            objLit.setInferredType(this.currentContext.currentType);
                        }
                        if (javaDoc.returnType != null) {
                            returnType = this.addType(this.changePrimitiveToObject(javaDoc.returnType.getFullTypeName()));
                        }
                    }
                    if (field.getInitializer() instanceof IFunctionExpression) {
                        IFunctionExpression functionExpression = (IFunctionExpression)field.getInitializer();
                        InferredMethod method = type.addMethod(name, functionExpression.getMethodDeclaration(), nameStart);
                        method.isStatic = isStatic;
                        if (javaDoc != null) {
                            functionExpression.getMethodDeclaration().modifiers = javaDoc.modifiers;
                        }
                        this.handleFunctionDeclarationArguments(functionExpression.getMethodDeclaration(), javaDoc);
                        if (returnType != null && functionExpression.getMethodDeclaration().getInferredType() == null) {
                            functionExpression.getMethodDeclaration().setInferredType(returnType);
                        }
                    } else if (field.getInitializer() != null) {
                        IAbstractFunctionDeclaration func;
                        InferredAttribute attribute = type.findAttribute(name);
                        if (attribute == null) {
                            attribute = type.addAttribute(name, field.getInitializer(), nameStart);
                            this.handleAttributeDeclaration(attribute, field.getInitializer());
                            attribute.isStatic = isStatic;
                            if (returnType != null) {
                                attribute.type = returnType;
                                if (field.getInitializer() instanceof ObjectLiteral) {
                                    ((ObjectLiteral)field.getInitializer()).setInferredType(returnType);
                                }
                            } else {
                                attribute.type = this.getTypeOf(field.getInitializer());
                            }
                        }
                        if (attribute.type != null && attribute.type.isFunction() && type.findMethod(attribute.name, null) == null && (func = this.getFunction(field.getInitializer())) instanceof IFunctionDeclaration) {
                            type.addMethod(name, (IFunctionDeclaration)func, nameStart);
                        }
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public void endVisit(IAssignment assignment) {
        this.popContext();
    }

    protected boolean handleAttributeDeclaration(InferredAttribute attribute) {
        return true;
    }

    protected boolean handleAttributeDeclaration(InferredAttribute attribute, IExpression initializer) {
        return true;
    }

    protected boolean handleFunctionCall(IFunctionCall messageSend) {
        return this.handleFunctionCall(messageSend, null);
    }

    protected boolean handleFunctionCall(IFunctionCall messageSend, LocalDeclaration assignmentExpression) {
        return true;
    }

    @Override
    public boolean visit(IReturnStatement returnStatement) {
        this.pushContext();
        this.currentContext.currentReturn = returnStatement;
        if (this.currentContext.currentMethod != null && returnStatement.getExpression() != null) {
            InferredType type = null;
            IExpression expression = returnStatement.getExpression();
            if (expression instanceof IObjectLiteral) {
                type = this.createAnonymousType((ObjectLiteral)expression);
                type.sourceStart = expression.sourceStart();
                type.sourceEnd = expression.sourceEnd();
            } else {
                type = this.getTypeOf(expression);
            }
            if (this.currentContext.currentMethod.getInferredType() == this.getVoidType() && type != null) {
                this.currentContext.currentMethod.setInferredType(type);
            } else if (this.currentContext.currentMethod.getInferredType() == this.getArrayType() && this.currentContext.currentMethod.getInferredType().referenceClass == null && type != null && CharOperation.equals(type.name, TypeConstants.ARRAY[0])) {
                this.currentContext.currentMethod.setInferredType(type);
            } else {
                boolean shouldSetToAny;
                boolean bl = shouldSetToAny = !((MethodDeclaration)this.currentContext.currentMethod).isInferredJsDocType();
                if (type != null && shouldSetToAny) {
                    String currentMethodInferredType = null;
                    if (this.currentContext.currentMethod.getInferredType() != null && this.currentContext.currentMethod.getInferredType().name != null) {
                        currentMethodInferredType = new String(this.currentContext.currentMethod.getInferredType().name);
                    }
                    boolean returnTypesEqual = type.equals(this.currentContext.currentMethod.getInferredType());
                    boolean returnTypeNamesEqual = new String(type.name).equals(currentMethodInferredType);
                    boolean returnTypeIsWellKnown = WellKnownTypes.containsKey(type.name);
                    boolean bl2 = shouldSetToAny = !returnTypesEqual && (!returnTypeIsWellKnown || !returnTypeIsWellKnown || !returnTypeNamesEqual);
                }
                if (shouldSetToAny) {
                    this.currentContext.currentMethod.setInferredType(null);
                }
            }
        }
        return false;
    }

    @Override
    public void endVisit(IReturnStatement returnStatement) {
        this.popContext();
    }

    @Override
    public void endVisit(IFunctionCall functionCall) {
        super.endVisit(functionCall);
        if (functionCall.getReceiver() instanceof FunctionExpression) {
            MethodDeclaration methodDeclaration;
            if (this.contextPtr == -1) {
                this.isTopLevelAnonymousFunction = true;
            }
            if (functionCall instanceof MessageSend && ((MessageSend)functionCall).getArguments() != null && (methodDeclaration = ((FunctionExpression)functionCall.getReceiver()).getMethodDeclaration()) != null && methodDeclaration.getArguments() != null) {
                IArgument[] declaredArguments = methodDeclaration.getArguments();
                IExpression[] sentArguments = ((MessageSend)functionCall).getArguments();
                int i = 0;
                while (i < declaredArguments.length) {
                    if (i < sentArguments.length) {
                        char[] parameterName = null;
                        parameterName = this.getName(sentArguments[i]);
                        if (parameterName != null && this.passNumber == 2 && declaredArguments[i].getInferredType() != null) {
                            IASTNode node = (IASTNode)this.currentContext.getMember(parameterName);
                            if (node instanceof IAbstractVariableDeclaration && ((IAbstractVariableDeclaration)node).getInferredType() != null) {
                                if (((IAbstractVariableDeclaration)node).getInferredType().isNamed() && ((LocalDeclaration)node).getInferredType().equals(declaredArguments[i].getInferredType().getSuperType())) {
                                    ((IAbstractVariableDeclaration)node).setInferredType(declaredArguments[i].getInferredType());
                                }
                            } else if (node instanceof IAssignment && ((IAssignment)node).getInferredType() != null && ((IAssignment)node).getInferredType().isNamed() && ((IAssignment)node).getInferredType().equals(declaredArguments[i].getInferredType().getSuperType())) {
                                ((IAssignment)node).setInferredType(declaredArguments[i].getInferredType());
                            }
                        }
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public void endVisit(IFunctionDeclaration methodDeclaration) {
        this.popContext();
    }

    @Override
    public boolean visit(IFunctionDeclaration methodDeclaration) {
        this.pushContext();
        if (this.isTopLevelAnonymousFunction && this.currentContext.currentType == null) {
            this.currentContext.currentType = this.getInferredGlobal(true);
        } else if (!this.isTopLevelAnonymousFunction && this.currentContext.currentType != null && CharOperation.equals(this.currentContext.currentType.getName(), IIndexConstants.GLOBAL_SYMBOL)) {
            this.currentContext.currentType = null;
        }
        this.isTopLevelAnonymousFunction = false;
        char[] methodName = methodDeclaration.getName();
        if (methodName == null && methodDeclaration.getInferredMethod() != null) {
            methodName = methodDeclaration.getInferredMethod().name;
        }
        if (this.passNumber == 1 && methodDeclaration instanceof AbstractMethodDeclaration && this.currentContext.currentMethod != null) {
            ((AbstractMethodDeclaration)((Object)methodDeclaration)).setContainingFunction(this.currentContext.currentMethod);
        }
        this.buildDefinedMembers(methodDeclaration.getStatements(), methodDeclaration.getArguments());
        if (this.passNumber == 1) {
            if (methodDeclaration.getJsDoc() != null) {
                InferredType type;
                InferredMethod method = null;
                Javadoc javadoc = (Javadoc)methodDeclaration.getJsDoc();
                this.createTypeIfNecessary(javadoc);
                if (javadoc.isConstructor) {
                    type = !this.currentContext.isJsDocClass && methodName != null ? this.addType(methodName) : this.currentContext.currentType;
                    if (type != null) {
                        this.handleJSDocConstructor(type, methodDeclaration, methodDeclaration.sourceStart());
                    }
                } else if (javadoc.memberOf != null) {
                    type = this.addType(javadoc.memberOf.getFullTypeName(), true);
                    char[] name = methodName;
                    int nameStart = methodDeclaration.sourceStart();
                    if (name != null) {
                        method = type.addMethod(methodName, methodDeclaration, nameStart);
                    }
                } else if (javadoc.methodDef != null && this.currentContext.isJsDocClass) {
                    type = this.currentContext.currentType;
                    char[][] methName = javadoc.methodDef.getTypeName();
                    int nameStart = ((MethodDeclaration)methodDeclaration).sourceStart;
                    if (methName.length == 1) {
                        method = type.addMethod(methName[0], methodDeclaration, nameStart);
                    } else {
                        method = type.addMethod(methName[methName.length - 1], methodDeclaration, nameStart);
                        method.isStatic = true;
                    }
                }
                if (javadoc.returnType != null) {
                    type = this.addType(this.changePrimitiveToObject(javadoc.returnType.getFullTypeName()));
                    methodDeclaration.setInferredType(type);
                    ((MethodDeclaration)methodDeclaration).bits |= 0x4000;
                }
            }
            this.handleFunctionDeclarationArguments(methodDeclaration, methodDeclaration.getJsDoc());
        }
        if (this.passNumber == 2 && methodName != null) {
            InferredType type = this.compUnit.findInferredType(methodName);
            InferredMethod inferMeth = methodDeclaration.getInferredMethod();
            if (type != null && (inferMeth == null || inferMeth.inType == null || inferMeth.inType == type || CharOperation.equals(inferMeth.inType.getName(), type.getName()))) {
                this.currentContext.currentType = type;
                type.setIsDefinition(true);
                if (inferMeth == null || !inferMeth.isConstructor) {
                    int nameStart = methodDeclaration.sourceStart();
                    type.addConstructorMethod(methodName, methodDeclaration, nameStart);
                }
            }
        }
        this.currentContext.currentMethod = methodDeclaration;
        if (methodDeclaration.getInferredMethod() != null && methodDeclaration.getInferredMethod().inType != null) {
            this.currentContext.currentType = methodDeclaration.getInferredMethod().inType;
        }
        if (methodDeclaration.getInferredType() == null) {
            methodDeclaration.setInferredType(this.getVoidType());
        }
        return true;
    }

    protected void handleConstructor(InferredType type, IFunctionDeclaration methodDeclaration, int start, int end) {
        type.setIsDefinition(true);
        type.addConstructorMethod(type.name, methodDeclaration, start);
        type.updatePositions(start, end);
    }

    protected void handleJSDocConstructor(InferredType type, IFunctionDeclaration methodDeclaration, int nameStart) {
        Javadoc javadoc = (Javadoc)methodDeclaration.getJsDoc();
        type.setIsDefinition(true);
        type.addConstructorMethod(type.name, methodDeclaration, nameStart);
        if (javadoc.extendsType != null) {
            InferredType superType = this.addType(javadoc.extendsType.getFullTypeName());
            type.setSuperType(superType);
        }
    }

    protected void handleFunctionDeclarationArguments(IFunctionDeclaration methodDeclaration, IJsDoc jsdoc) {
        if (jsdoc == null || !(jsdoc instanceof Javadoc)) {
            return;
        }
        Javadoc javadoc = (Javadoc)jsdoc;
        IArgument[] arguments = methodDeclaration.getArguments();
        if (arguments != null) {
            int i = 0;
            while (i < arguments.length) {
                InferredType currType = arguments[i].getInferredType();
                if (currType == null || currType.isAnonymous) {
                    InferredType paramType = null;
                    JavadocSingleNameReference param = javadoc.findParam(arguments[i].getName());
                    if (param != null) {
                        if (param.types != null) {
                            char[] name = new char[]{};
                            int j = 0;
                            while (j < param.types.length) {
                                char[] typeName = this.changePrimitiveToObject(param.types[j].getFullTypeName());
                                if (j == 0) {
                                    name = typeName;
                                } else {
                                    name = CharOperation.append(name, '|');
                                    name = CharOperation.concat(name, typeName);
                                }
                                ++j;
                            }
                            paramType = this.addType(name);
                        }
                    } else if (arguments[i].getJsDoc() != null) {
                        if (((Javadoc)arguments[i].getJsDoc()).returnType != null) {
                            paramType = this.addType(((Javadoc)arguments[i].getJsDoc()).returnType.getFullTypeName());
                        }
                    } else if (arguments[i].getComment() != null) {
                        char[] comment = CharOperation.trim(arguments[i].getComment());
                        boolean validForName = true;
                        int j = 0;
                        while (j < comment.length && validForName) {
                            validForName &= !CharOperation.isWhitespace(comment[j]) && (Character.isJavaIdentifierPart(comment[j]) || comment[j] == '.');
                            ++j;
                        }
                        if (validForName) {
                            paramType = this.addType(comment);
                        }
                    }
                    if (paramType != null) {
                        if (currType != null) {
                            InferredType currSuperType = currType.getSuperType();
                            currType.setSuperType(paramType);
                            paramType.setSuperType(currSuperType);
                            paramType = currType;
                        }
                        arguments[i].setInferredType(paramType);
                    }
                }
                ++i;
            }
        }
    }

    private void copyAnonymousTypeToNamed(InferredType inClass, InferredType toType) {
        if (toType == null) {
            return;
        }
        this.compUnit.inferredTypesHash.removeKey(inClass.name);
        if (inClass.methods != null) {
            toType.methods.addAll(inClass.methods);
        }
        if (inClass.attributes != null) {
            int i = 0;
            while (i < inClass.numberAttributes) {
                toType.addAttribute(inClass.attributes[i]);
                ++i;
            }
        }
    }

    protected void renameType(InferredType type, char[] newTypeName) {
        InferredMethod constructor = type.findMethod(TypeConstants.INIT, null);
        if (constructor != null) {
            constructor.name = newTypeName;
        }
        this.compUnit.inferredTypesHash.removeKey(type.name);
        type.name = newTypeName;
        this.compUnit.inferredTypesHash.put(newTypeName, type);
    }

    protected void convertAnonymousTypeToNamed(InferredType type, char[] newTypeName) {
        if (type.isAnonymous) {
            this.renameType(type, newTypeName);
            type.isAnonymous = false;
            type.setIsGlobal(true);
        }
    }

    protected boolean isMatch(IExpression expr, char[][] names, int index) {
        char[] matchName = names[index];
        if (expr instanceof SingleNameReference) {
            SingleNameReference snr = (SingleNameReference)expr;
            return CharOperation.equals(snr.token, matchName);
        }
        if (expr instanceof FieldReference && names.length > 1 && index > 0) {
            FieldReference fieldReference = (FieldReference)expr;
            if (CharOperation.equals(fieldReference.token, matchName)) {
                return this.isMatch(fieldReference.receiver, names, index - 1);
            }
        }
        return false;
    }

    protected boolean isFunction(IFunctionCall messageSend, String string) {
        String[] names = string.split("\\.");
        char[] functionName = names[names.length - 1].toCharArray();
        if (!CharOperation.equals(functionName, messageSend.getSelector())) {
            return false;
        }
        char[][] namesChars = new char[names.length][];
        int i = 0;
        while (i < namesChars.length) {
            namesChars[i] = names[i].toCharArray();
            ++i;
        }
        if (names.length > 1) {
            return this.isMatch(messageSend.getReceiver(), namesChars, namesChars.length - 2);
        }
        return true;
    }

    protected boolean isFunction(IFunctionCall messageSend, char[][] names) {
        if (messageSend == null) {
            return false;
        }
        char[] functionName = names[names.length - 1];
        if (!CharOperation.equals(functionName, messageSend.getSelector())) {
            return false;
        }
        if (names.length > 1) {
            return this.isMatch(messageSend.getReceiver(), names, names.length - 2);
        }
        return true;
    }

    @Override
    public void doInfer() {
        try {
            long time0 = 0L;
            if (REPORT_INFER_TIME) {
                time0 = System.currentTimeMillis();
            }
            this.clearBuiltInTypes();
            ASTVisitor visitor = this.getVisitor(this.compUnit);
            if (visitor != null) {
                this.compUnit.traverse(visitor);
            }
            this.passNumber = 2;
            visitor = this.getVisitor(this.compUnit);
            if (visitor != null) {
                this.compUnit.traverse(visitor);
            }
            int i = 0;
            while (i < this.compUnit.numberInferredTypes) {
                if (this.compUnit.inferredTypes[i].sourceStart < 0) {
                    this.compUnit.inferredTypes[i].sourceStart = 0;
                }
                ++i;
            }
            if (REPORT_INFER_TIME) {
                long time = System.currentTimeMillis() - time0;
                System.err.println(String.valueOf(this.getClass().getName()) + " inferred " + new String(this.compUnit.getFileName()) + " in " + time + "ms");
            }
            this.compUnit = null;
        }
        catch (RuntimeException e) {
            org.eclipse.wst.jsdt.internal.core.util.Util.log(e, "error during type inferencing");
        }
    }

    protected InferredType addType(char[] className) {
        return this.addType(className, false);
    }

    protected InferredType addType(char[] className, boolean isDefinition) {
        InferredType type = this.compUnit.addType(className, isDefinition, this.inferenceProvider.getID());
        return type;
    }

    protected final void pushContext() {
        Context newContext = new Context(this.currentContext);
        this.contexts[++this.contextPtr] = this.currentContext;
        this.currentContext = newContext;
    }

    protected final void popContext() {
        this.currentContext = this.contexts[this.contextPtr];
        this.contexts[this.contextPtr--] = null;
    }

    protected final boolean isInNamedMethod() {
        return this.currentContext.currentMethod != null && this.currentContext.currentMethod.getName() != null;
    }

    protected IAbstractVariableDeclaration getVariable(IExpression expression) {
        Object var;
        IReference ref;
        char[] name = null;
        if (expression instanceof ISingleNameReference) {
            name = ((ISingleNameReference)expression).getToken();
        } else if (expression instanceof IFieldReference && (ref = InferEngine.getRoot((IFieldReference)expression)) != null && ref instanceof SingleNameReference) {
            name = ((SingleNameReference)ref).getToken();
        }
        if (name != null && (var = this.currentContext.getMember(name)) instanceof IAbstractVariableDeclaration) {
            return (IAbstractVariableDeclaration)var;
        }
        return null;
    }

    protected IAssignment getAssignment(IExpression expression) {
        Object assignment;
        IReference ref;
        char[] name = null;
        if (expression instanceof ISingleNameReference) {
            name = ((ISingleNameReference)expression).getToken();
        } else if (expression instanceof IFieldReference && (ref = InferEngine.getRoot((IFieldReference)expression)) != null && ref instanceof SingleNameReference) {
            name = ((SingleNameReference)ref).getToken();
        }
        if (name != null && (assignment = this.currentContext.getMember(name)) instanceof IAssignment) {
            return (IAssignment)assignment;
        }
        return null;
    }

    protected IAbstractFunctionDeclaration getFunction(IExpression expression) {
        IAbstractFunctionDeclaration function;
        block8: {
            IAbstractFunctionDeclaration calledFunction;
            Object method;
            char[] name;
            block6: {
                IExpression init;
                Object method2;
                block7: {
                    function = null;
                    name = null;
                    if (!(expression instanceof ISingleNameReference)) break block6;
                    name = ((ISingleNameReference)expression).getToken();
                    method2 = this.currentContext.getMember(name);
                    if (!(method2 instanceof IAbstractFunctionDeclaration)) break block7;
                    function = (IAbstractFunctionDeclaration)method2;
                    break block8;
                }
                if (!(method2 instanceof ILocalDeclaration) || !((init = ((ILocalDeclaration)method2).getInitialization()) instanceof IFunctionExpression)) break block8;
                function = ((IFunctionExpression)init).getMethodDeclaration();
                break block8;
            }
            if (expression instanceof IFieldReference) {
                InferredMethod inferredMethod;
                InferredType receiverType = this.getReceiverType(((IFieldReference)expression).getReceiver(), false);
                if (receiverType != null && (inferredMethod = receiverType.findMethod(((IFieldReference)expression).getToken(), null)) != null) {
                    function = inferredMethod.getFunctionDeclaration();
                }
                name = ((IFieldReference)expression).getToken();
            } else if (expression instanceof MessageSend && (name = ((MessageSend)expression).selector) != null && (method = this.currentContext.getMember(name)) instanceof IAbstractFunctionDeclaration && (calledFunction = (IAbstractFunctionDeclaration)method).getStatements() != null) {
                IProgramElement[] statements = calledFunction.getStatements();
                int i = 0;
                while (i < statements.length) {
                    if (statements[i] instanceof IReturnStatement && ((IReturnStatement)statements[i]).getExpression() instanceof IFunctionExpression) {
                        function = ((IFunctionExpression)((IReturnStatement)statements[i]).getExpression()).getMethodDeclaration();
                        break;
                    }
                    ++i;
                }
            }
        }
        return function;
    }

    private void buildDefinedMembers(IProgramElement[] statements, IArgument[] arguments) {
        int i;
        if (arguments != null) {
            i = 0;
            while (i < arguments.length) {
                this.currentContext.addMember(arguments[i].getName(), arguments[i]);
                ++i;
            }
        }
        if (statements != null) {
            i = 0;
            while (i < statements.length) {
                IAbstractFunctionDeclaration method;
                if (statements[i] instanceof ILocalDeclaration) {
                    ILocalDeclaration local = (ILocalDeclaration)statements[i];
                    this.currentContext.addMember(local.getName(), local);
                } else if (statements[i] instanceof IAbstractFunctionDeclaration && (method = (IAbstractFunctionDeclaration)statements[i]).getName() != null) {
                    this.currentContext.addMember(method.getName(), method);
                }
                ++i;
            }
        }
    }

    private static boolean isThis(IExpression expression) {
        return expression instanceof ASTNode && ((ASTNode)((Object)expression)).isThis();
    }

    private InferredType getInferredType(IExpression expression) {
        InferredType type = null;
        if (expression instanceof IThisReference) {
            type = this.currentContext.currentType;
        } else if (expression instanceof SingleNameReference) {
            char[] possibleTypeName;
            IAbstractVariableDeclaration varDecl = this.getVariable(expression);
            if (varDecl != null) {
                type = varDecl.getInferredType();
            }
            IAssignment assignment = null;
            if (type == null && (assignment = this.getAssignment(expression)) != null) {
                type = assignment.getInferredType();
            }
            if ((type == null && varDecl == null && assignment == null || type != null && type.isFunction()) && (possibleTypeName = this.constructTypeName(expression)) != null) {
                InferredType existingType = this.compUnit.findInferredType(possibleTypeName);
                if (existingType != null) {
                    type = existingType;
                } else if (WellKnownTypes.containsKey(possibleTypeName) || this.isKnownType(possibleTypeName)) {
                    type = this.addType(possibleTypeName, false);
                }
            }
        } else if (expression instanceof FieldReference) {
            char[] possibleTypeName = this.constructTypeName(expression);
            if (possibleTypeName != null) {
                type = this.compUnit.findInferredType(possibleTypeName);
            }
            if (type == null && this.isPossibleClassName(possibleTypeName)) {
                type = this.addType(possibleTypeName, true);
            }
            if (type == null) {
                InferredAttribute typeAttribute;
                FieldReference fRef = (FieldReference)expression;
                InferredType parentType = this.getInferredType(fRef.receiver);
                if (parentType != null && (typeAttribute = parentType.findAttribute(fRef.token)) != null) {
                    type = typeAttribute.type;
                }
            }
        }
        return type;
    }

    protected InferredType getInferredType2(IExpression fieldReceiver) {
        char[] name;
        InferredAttribute attr;
        InferredType receiverType = null;
        IAbstractVariableDeclaration var = this.getVariable(fieldReceiver);
        if (var != null) {
            receiverType = this.createAnonymousType(var);
        } else if (this.inferredGlobal != null && fieldReceiver instanceof ISingleNameReference && (attr = this.inferredGlobal.findAttribute(name = ((ISingleNameReference)fieldReceiver).getToken())) != null) {
            receiverType = attr.type;
        }
        return receiverType;
    }

    protected boolean isKnownType(char[] possibleTypeName) {
        return false;
    }

    protected final char[] constructTypeName(IExpression expression) {
        return Util.getTypeName(expression);
    }

    @Override
    public boolean visit(IObjectLiteral literal) {
        if (this.passNumber == 1 && literal.getInferredType() == null) {
            this.createAnonymousType(literal);
        }
        this.pushContext();
        this.currentContext.currentType = literal.getInferredType();
        return true;
    }

    @Override
    public void endVisit(IObjectLiteral literal) {
        this.popContext();
    }

    @Override
    public void initializeOptions(InferOptions options) {
    }

    protected boolean isPossibleClassName(char[] name) {
        return false;
    }

    public IScriptFileDeclaration getScriptFileDeclaration() {
        return this.compUnit;
    }

    public InferredType findDefinedType(char[] className) {
        return this.compUnit.findInferredType(className);
    }

    protected Object findDefinedMember(char[] memberName) {
        return this.currentContext.getMember(memberName);
    }

    protected char[] changePrimitiveToObject(char[] name) {
        if (CharOperation.equals(name, TypeConstants.BOOLEAN, false)) {
            return this.getBooleanType().getName();
        }
        return name;
    }

    protected InferredType getStringType() {
        if (this.fStringType == null) {
            this.fStringType = this.addType(TypeConstants.JAVA_LANG_STRING[0]);
        }
        return this.fStringType;
    }

    protected InferredType getNumberType() {
        if (this.fNumberType == null) {
            this.fNumberType = this.addType(TypeConstants.NUMBER[0]);
        }
        return this.fNumberType;
    }

    protected InferredType getBooleanType() {
        if (this.fBooleanType == null) {
            this.fBooleanType = this.addType(TypeConstants.BOOLEAN_OBJECT[0]);
        }
        return this.fBooleanType;
    }

    protected InferredType getFunctionType() {
        if (this.fFunctionType == null) {
            this.fFunctionType = this.addType(TypeConstants.FUNCTION[0]);
        }
        return this.fFunctionType;
    }

    protected InferredType getArrayType() {
        if (this.fArrayType == null) {
            this.fArrayType = this.addType(TypeConstants.ARRAY[0]);
        }
        return this.fArrayType;
    }

    protected InferredType getVoidType() {
        if (this.fVoidType == null) {
            this.fVoidType = this.addType(TypeConstants.VOID);
        }
        return this.fVoidType;
    }

    protected InferredType getObjectType() {
        if (this.fObjectType == null) {
            this.fObjectType = this.addType(TypeConstants.OBJECT);
        }
        return this.fObjectType;
    }

    protected char[] getName(IExpression expression) {
        char[] name = null;
        if (expression instanceof ISingleNameReference) {
            name = ((ISingleNameReference)expression).getToken();
        } else if (expression instanceof IFieldReference) {
            name = ((IFieldReference)expression).getToken();
        } else if (expression instanceof IAssignment) {
            name = this.getName(((IAssignment)expression).getLeftHandSide());
        }
        return name;
    }

    private InferredType getTypeForVariableInitialization(char[] variableName, IExpression initialization) {
        InferredType type = this.getTypeOf(initialization);
        boolean isGlobal = this.isGlobal(variableName);
        if (type != null && !type.isIndexed() && isGlobal) {
            char[] globalTypeName = InferEngine.createAnonymousGlobalTypeName(variableName);
            this.renameType(type, globalTypeName);
            type.isAnonymous = true;
            type.setIsGlobal(true);
        } else if (type == null && isGlobal && this.passNumber == 2) {
            type = this.createAnonymousGlobalType(variableName);
        }
        return type;
    }

    private InferredType createTypeToAssignTo(IExpression receiver, InferredType currentReceiverType) {
        char[] varName = this.getName(receiver);
        InferredType newType = null;
        if (!(currentReceiverType.isAnonymous || InferEngine.isThis(receiver) || CharOperation.equals(currentReceiverType.name, varName) || this.isExpressionAType(receiver))) {
            boolean isGlobal = this.isGlobal(varName);
            newType = isGlobal ? (currentReceiverType.isFunction() ? this.addType(varName, true) : this.createAnonymousGlobalType(varName)) : this.createAnonymousType(receiver, currentReceiverType);
        }
        if (newType != null) {
            newType.setSuperType(currentReceiverType);
            this.setTypeOf(receiver, newType);
        } else {
            newType = currentReceiverType;
        }
        return newType;
    }

    private void clearBuiltInTypes() {
        this.fStringType = null;
        this.fNumberType = null;
        this.fBooleanType = null;
        this.fFunctionType = null;
        this.fArrayType = null;
        this.fVoidType = null;
        this.fObjectType = null;
    }

    protected InferredType getReceiverType(IExpression receiver, boolean defineRoot) {
        InferredType receiverType = null;
        IExpression current = receiver;
        ArrayList<IExpression> recievers = new ArrayList<IExpression>();
        InferredType rootType = null;
        while (current != null && !(current instanceof SingleNameReference) && rootType == null) {
            if (current instanceof FieldReference) {
                recievers.add(current);
                current = ((FieldReference)current).getReceiver();
                continue;
            }
            if (current instanceof ThisReference) {
                rootType = this.currentContext.currentType;
                ((ThisReference)current).setInferredType(rootType);
                current = null;
                continue;
            }
            current = null;
        }
        IAbstractVariableDeclaration rootVarDecl = null;
        IAssignment rootAssignment = null;
        if (rootType == null && current instanceof SingleNameReference) {
            IFunctionDeclaration func;
            char[] name = ((SingleNameReference)current).getToken();
            rootType = this.findDefinedType(name);
            if (rootType == null && (func = this.getDefinedFunction(current)) != null) {
                rootType = this.addType(name, true);
                rootType.setNameStart(current.sourceStart());
                rootType.setSourceEnd(current.sourceEnd());
            }
            if (rootType == null && (rootVarDecl = this.getVariable(current)) != null && ((rootType = rootVarDecl.getInferredType()) == null || !rootType.isAnonymous && !rootVarDecl.isType())) {
                boolean isGlobal = this.isGlobal(name);
                if (isGlobal) {
                    InferredType globalType = this.createAnonymousGlobalType(name);
                    globalType.setSuperType(rootType);
                    rootType = globalType;
                    rootType.setIsDefinition(true);
                    rootVarDecl.setInferredType(rootType);
                } else if (defineRoot) {
                    rootType = this.createAnonymousType(current, rootType);
                    rootType.setIsDefinition(true);
                    rootVarDecl.setInferredType(rootType);
                }
            }
            if (rootType == null && this.inferredGlobal != null) {
                InferredAttribute attr = this.getInferredGlobal(false).findAttribute(name);
                if (attr != null) {
                    if (attr.type == null) {
                        attr.type = this.createAnonymousGlobalType(attr.name);
                    }
                    rootType = attr.type;
                } else {
                    InferredMethod meth = this.getInferredGlobal(false).findMethod(name, null);
                    if (meth != null) {
                        rootType = this.addType(name, true);
                        rootType.setNameStart(current.sourceStart());
                        rootType.setSourceEnd(current.sourceEnd());
                    }
                }
            }
            if (rootType == null && (rootAssignment = this.getAssignment(current)) != null) {
                rootType = rootAssignment.getInferredType();
            }
            if (rootType == null && defineRoot) {
                rootType = this.createAnonymousGlobalType(name);
            }
        }
        if (rootType != null) {
            if (defineRoot && (recievers.isEmpty() || rootVarDecl != null || rootAssignment != null)) {
                rootType.setIsDefinition(true);
            }
            InferredType currentType = rootType;
            int i = recievers.size() - 1;
            while (i >= 0) {
                FieldReference ref = (FieldReference)recievers.get(i);
                InferredAttribute attr = currentType.findAttribute(ref.getToken());
                if (attr != null) {
                    currentType = attr.type != null ? attr.type : (attr.type = this.createAnonymousType(attr, null));
                } else {
                    InferredMethod meth = currentType.findMethod(ref.getToken(), null);
                    if (meth != null) {
                        char[] typeName = CharOperation.concatWith(ref.asQualifiedName(), '.');
                        currentType = this.addType(typeName, true);
                    } else {
                        attr = currentType.addAttribute(ref.getToken(), ref, ref.sourceStart);
                        if (currentType == this.getInferredGlobal(false)) {
                            attr.type = this.createAnonymousGlobalType(attr.name);
                            attr.type.setIsDefinition(true);
                        } else {
                            attr.type = this.createAnonymousType(attr, null);
                        }
                        currentType = attr.type;
                    }
                }
                --i;
            }
            receiverType = currentType;
        }
        return receiverType;
    }

    protected InferredType getInferredGlobal(boolean define) {
        if (this.inferredGlobal == null && define) {
            this.inferredGlobal = this.addType(IIndexConstants.GLOBAL_SYMBOL, true);
            this.inferredGlobal.isAnonymous = true;
            this.inferredGlobal.setIsGlobal(true);
        }
        return this.inferredGlobal;
    }

    private boolean isRootGlobal(IExpression expr) {
        boolean isGlobal = false;
        IReference root = null;
        if (expr instanceof SingleNameReference) {
            root = (SingleNameReference)expr;
        } else if (expr instanceof FieldReference) {
            root = InferEngine.getRoot((FieldReference)expr);
        }
        if (root != null && root instanceof ISingleNameReference) {
            isGlobal = this.isGlobal(((ISingleNameReference)root).getToken());
        } else if (root != null && root instanceof IThisReference) {
            isGlobal = this.currentContext.currentType == this.getInferredGlobal(false);
        } else if (root == null) {
            isGlobal = true;
        }
        return isGlobal;
    }

    protected boolean isGlobal(char[] name) {
        boolean isGlobal = false;
        if (name == null) {
            return isGlobal;
        }
        Object currentContextMember = this.currentContext.getMember(name);
        Object globalMember = this.contexts[0] != null ? this.contexts[0].getMember(name) : currentContextMember;
        boolean bl = isGlobal = globalMember != null && currentContextMember == globalMember;
        if (!isGlobal) {
            isGlobal = currentContextMember instanceof Assignment;
        }
        if (!isGlobal) {
            globalMember = null;
            InferredType inferredGlobal = this.getInferredGlobal(false);
            if (inferredGlobal != null && (globalMember = inferredGlobal.findAttribute(name)) == null) {
                globalMember = inferredGlobal.findMethod(name, null);
            }
            boolean bl2 = isGlobal = globalMember != null;
        }
        if (!isGlobal && globalMember == null && currentContextMember == null) {
            isGlobal = true;
        }
        return isGlobal;
    }

    private static IReference getRoot(IFieldReference ref) {
        IReference root = null;
        IExpression current = ref;
        while (root == null && current != null) {
            if (current instanceof IFieldReference) {
                current = current.getReceiver();
                continue;
            }
            if (current instanceof SingleNameReference) {
                root = (SingleNameReference)current;
                continue;
            }
            if (current instanceof IThisReference) {
                root = (IThisReference)current;
                continue;
            }
            current = null;
        }
        return root;
    }

    private static boolean expressionContains(IExpression parent, IExpression needle) {
        boolean contains = false;
        LinkedList<IExpression> expressions = new LinkedList<IExpression>();
        expressions.add(parent);
        while (expressions.size() > 0 && !contains) {
            IExpression current = (IExpression)expressions.removeFirst();
            boolean bl = contains = needle == current;
            if (contains) continue;
            if (current instanceof IBinaryExpression) {
                expressions.add(((IBinaryExpression)current).getLeft());
                expressions.add(((IBinaryExpression)current).getRight());
                continue;
            }
            if (!(current instanceof Assignment)) continue;
            expressions.add(((Assignment)current).getLeftHandSide());
            expressions.add(((Assignment)current).getExpression());
        }
        return contains;
    }

    private boolean isExpressionAType(IExpression expr) {
        boolean isType = false;
        if (expr instanceof IAssignment) {
            isType = ((IAssignment)expr).isType();
        } else if (expr instanceof IAbstractVariableDeclaration) {
            isType = ((IAbstractVariableDeclaration)((Object)expr)).isType();
        } else if (expr instanceof IFieldReference) {
            IExpression receiver = ((IFieldReference)expr).getReceiver();
            InferredType receiverType = this.getTypeOf(receiver);
            if (receiverType != null) {
                InferredAttribute attr = receiverType.findAttribute(((IFieldReference)expr).getToken());
                isType = attr != null && attr.isType();
            }
        } else if (expr instanceof ISingleNameReference) {
            IAbstractFunctionDeclaration funcDecl;
            IAssignment assign;
            IAbstractVariableDeclaration varDecl = this.getVariable(expr);
            if (varDecl != null) {
                isType = varDecl.isType();
            }
            if (!isType && (assign = this.getAssignment(expr)) != null) {
                isType = assign.isType();
            }
            if (!isType && (funcDecl = this.getFunction(expr)) != null && funcDecl.getName() != null) {
                InferredType typeDefinedByFunc = this.findDefinedType(funcDecl.getName());
                boolean bl = isType = typeDefinedByFunc != null;
            }
            if (!isType) {
                InferredType existingType = this.compUnit.findInferredType(((ISingleNameReference)expr).getToken());
                isType = existingType != null;
            }
        } else if (expr instanceof IThisReference) {
            isType = true;
        }
        return isType;
    }

    protected InferredType createAnonymousTypeForMixin(IExpression mixInto, InferredType parentType) {
        InferredType mixIntoType;
        IAbstractVariableDeclaration localVar = this.getVariable(mixInto);
        char[] varName = this.getName(mixInto);
        if (mixInto instanceof ISingleNameReference && (localVar == null || this.isGlobal(varName))) {
            mixIntoType = this.createAnonymousGlobalType(varName);
            mixIntoType.setSuperType(parentType);
        } else {
            mixIntoType = this.createAnonymousType(mixInto, parentType);
        }
        mixIntoType.isObjectLiteral = false;
        return mixIntoType;
    }

    protected InferredType getAttributeType(char[] attName, IExpression receiver, boolean defineRoot) {
        InferredAttribute attr;
        InferredType attrType = null;
        InferredType receiverType = this.getReceiverType(receiver, defineRoot);
        if (receiverType != null && (attr = receiverType.findAttribute(attName)) != null && attr.type != null) {
            attrType = attr.type;
        }
        return attrType;
    }

    protected ASTVisitor getVisitor(CompilationUnitDeclaration compilationUnit) {
        return this;
    }

    static class Context {
        InferredType currentType;
        IFunctionDeclaration currentMethod;
        IAssignment currentAssignment;
        ILocalDeclaration currentLocalDeclaration;
        IReturnStatement currentReturn;
        boolean isJsDocClass;
        private HashtableOfObject definedMembers;
        private Context parent = null;

        Context() {
        }

        Context(Context parent) {
            this.parent = parent;
            this.currentType = parent.currentType;
            this.currentMethod = parent.currentMethod;
            this.currentAssignment = parent.currentAssignment;
            this.currentLocalDeclaration = parent.currentLocalDeclaration;
            this.currentReturn = parent.currentReturn;
            this.isJsDocClass = parent.isJsDocClass;
        }

        public Object getMember(char[] key) {
            Object value = null;
            if (this.definedMembers != null) {
                value = this.definedMembers.get(key);
            }
            if (value == null && this.parent != null) {
                value = this.parent.getMember(key);
            }
            return value;
        }

        public void addMember(char[] key, Object member) {
            if (key == null) {
                return;
            }
            if (this.definedMembers == null) {
                this.definedMembers = new HashtableOfObject();
            }
            this.definedMembers.put(key, member);
        }

        public void setCurrentType(InferredType type) {
            this.currentType = type;
            Context parentContext = this.parent;
            while (parentContext != null && parentContext.currentMethod == this.currentMethod) {
                parentContext.currentType = type;
                parentContext = parentContext.parent;
            }
        }
    }
}

