/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.clone;

import java.io.File;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.clone.AbstractGitCloneWizard;
import org.eclipse.egit.ui.internal.clone.CloneDestinationPage;
import org.eclipse.egit.ui.internal.clone.GitCloneSourceProviderExtension;
import org.eclipse.egit.ui.internal.clone.GitSelectRepositoryPage;
import org.eclipse.egit.ui.internal.provisional.wizards.GitRepositoryInfo;
import org.eclipse.egit.ui.internal.provisional.wizards.NoRepositoryInfoException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.wizards.datatransfer.EasymportJob;
import org.eclipse.ui.internal.wizards.datatransfer.EasymportJobReportDialog;
import org.eclipse.ui.internal.wizards.datatransfer.SelectImportRootWizardPage;

public class EasymportGitWizard
extends AbstractGitCloneWizard
implements IImportWizard {
    private SelectImportRootWizardPage selectRootPage = new SelectImportRootWizardPage((IWizard)this, null, null){

        public void setVisible(boolean visible) {
            if (visible) {
                if (EasymportGitWizard.this.existingRepo != null) {
                    this.setInitialSelectedDirectory(EasymportGitWizard.this.existingRepo.getWorkTree());
                } else if (EasymportGitWizard.this.needToCloneRepository()) {
                    this.setInitialSelectedDirectory(EasymportGitWizard.this.doClone());
                }
            }
            super.setVisible(visible);
        }
    };
    private GitSelectRepositoryPage selectRepoPage = new GitSelectRepositoryPage();
    private Repository existingRepo;

    public EasymportGitWizard() {
        IDialogSettings dialogSettings = super.getDialogSettings();
        if (dialogSettings == null) {
            dialogSettings = org.eclipse.ui.internal.wizards.datatransfer.Activator.getDefault().getDialogSettings();
            this.setDialogSettings(dialogSettings);
        }
        this.setDefaultPageImageDescriptor(UIIcons.WIZBAN_IMPORT_REPO);
    }

    protected void addPreClonePages() {
        if (!this.hasSearchResult()) {
            this.addPage((IWizardPage)this.selectRepoPage);
        }
    }

    protected void addPostClonePages() {
        this.addPage((IWizardPage)this.selectRootPage);
    }

    public boolean performFinish() {
        EasymportJob job = new EasymportJob(this.selectRootPage.getSelectedRootDirectory(), this.selectRootPage.getSelectedWorkingSets(), this.selectRootPage.isConfigureAndDetectNestedProject());
        EasymportJobReportDialog dialog = new EasymportJobReportDialog(this.getShell(), job);
        job.schedule();
        if (this.selectRootPage.isConfigureAndDetectNestedProject()) {
            dialog.open();
        }
        return true;
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this.selectRootPage && this.selectRootPage.isPageComplete();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    protected List<GitCloneSourceProviderExtension.CloneSourceProvider> getCloneSourceProviders() {
        List cloneSourceProvider = super.getCloneSourceProviders();
        cloneSourceProvider.add(0, GitCloneSourceProviderExtension.CloneSourceProvider.LOCAL);
        return cloneSourceProvider;
    }

    public CloneDestinationPage getCloneDestinationPage() {
        return this.cloneDestination;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.selectRepoPage) {
            this.existingRepo = this.selectRepoPage.getRepository();
            return this.selectRootPage;
        }
        return super.getNextPage(page);
    }

    public boolean needsClone() {
        return this.cloneDestination.cloneSettingsChanged();
    }

    private boolean needToCloneRepository() {
        return this.cloneDestination.cloneSettingsChanged();
    }

    private File doClone() {
        this.setCallerRunsCloneOperation(true);
        try {
            final GitRepositoryInfo repositoryInfo = this.currentSearchResult.getGitRepositoryInfo();
            this.performClone(repositoryInfo);
            this.getContainer().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    EasymportGitWizard.this.runCloneOperation(EasymportGitWizard.this.getContainer(), repositoryInfo);
                    EasymportGitWizard.this.cloneDestination.saveSettingsForClonedRepo();
                }
            });
        }
        catch (URISyntaxException e) {
            Activator.error((String)UIText.GitImportWizard_errorParsingURI, (Throwable)e);
        }
        catch (NoRepositoryInfoException e) {
            Activator.error((String)UIText.GitImportWizard_noRepositoryInfo, (Throwable)e);
        }
        catch (Exception e) {
            Activator.error((String)e.getMessage(), (Throwable)e);
        }
        return this.getCloneDestinationPage().getDestinationFile();
    }
}

