/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.style;

import java.util.Collection;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ColorHelper;
import org.eclipse.wst.sse.ui.internal.provisional.style.AbstractLineStyleProvider;
import org.eclipse.wst.sse.ui.internal.provisional.style.Highlighter;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.sse.ui.internal.provisional.style.ReconcilerHighlighter;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xsl.ui.internal.XSLUIPlugin;
import org.eclipse.wst.xsl.ui.internal.style.XMLRegionMap;
import org.eclipse.wst.xsl.ui.internal.style.XMLTextAttributeMap;
import org.eclipse.wst.xsl.ui.internal.style.XSLRegionMap;
import org.eclipse.wst.xsl.ui.internal.style.XSLTextAttributeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class LineStyleProviderForXSL
extends AbstractLineStyleProvider
implements LineStyleProvider {
    protected IStructuredDocument structuredDocument;
    protected Highlighter highlighter;
    private boolean initialized;
    protected ReconcilerHighlighter recHighlighter = null;
    private IPreferenceStore xmlPreferenceStore = null;
    private IPreferenceStore xslPreferenceStore = null;
    private IPreferenceStore combinedPreferenceStore = null;
    private IPropertyChangeListener preferenceListener = new PropertyChangeListener();

    protected void commonInit(IStructuredDocument document, Highlighter highlighter) {
        this.structuredDocument = document;
        this.highlighter = highlighter;
    }

    public boolean prepareRegions(ITypedRegion typedRegion, int lineRequestStart, int lineRequestLength, Collection holdResults) {
        int partitionStartOffset = typedRegion.getOffset();
        int partitionLength = typedRegion.getLength();
        IStructuredDocumentRegion structuredDocumentRegion = this.getDocument().getRegionAtCharacterOffset(partitionStartOffset);
        boolean handled = false;
        handled = this.prepareTextRegions(structuredDocumentRegion, partitionStartOffset, partitionLength, holdResults);
        return handled;
    }

    protected boolean prepareTextRegion(ITextRegionCollection blockedRegion, int partitionStartOffset, int partitionLength, Collection holdResults) {
        boolean handled = false;
        int partitionEndOffset = partitionStartOffset + partitionLength - 1;
        ITextRegion region = null;
        ITextRegionList regions = blockedRegion.getRegions();
        StyleRange styleRange = null;
        int i = 0;
        while (i < regions.size()) {
            region = regions.get(i);
            TextAttribute attr = null;
            TextAttribute previousAttr = null;
            if (blockedRegion.getStartOffset(region) > partitionEndOffset) break;
            if (blockedRegion.getEndOffset(region) > partitionStartOffset) {
                if (region instanceof ITextRegionCollection) {
                    handled = this.prepareTextRegion((ITextRegionCollection)region, partitionStartOffset, partitionLength, holdResults);
                } else {
                    attr = this.getAttributeFor(blockedRegion, region);
                    if (attr != null) {
                        handled = true;
                        styleRange = this.applyStyleRange(blockedRegion, partitionStartOffset, partitionLength, holdResults, region, styleRange, attr, previousAttr);
                    } else {
                        previousAttr = null;
                    }
                }
            }
            ++i;
        }
        return handled;
    }

    private StyleRange applyStyleRange(ITextRegionCollection blockedRegion, int partitionStartOffset, int partitionLength, Collection holdResults, ITextRegion region, StyleRange styleRange, TextAttribute attr, TextAttribute previousAttr) {
        if (this.equalsPreviousAttribute(styleRange, attr, previousAttr)) {
            styleRange.length += region.getLength();
        } else {
            styleRange = this.createStyleRange(blockedRegion, region, attr, partitionStartOffset, partitionLength);
            holdResults.add(styleRange);
            previousAttr = attr;
        }
        return styleRange;
    }

    private boolean equalsPreviousAttribute(StyleRange styleRange, TextAttribute attr, TextAttribute previousAttr) {
        return styleRange != null && previousAttr != null && previousAttr.equals((Object)attr);
    }

    protected boolean prepareTextRegions(IStructuredDocumentRegion structuredDocumentRegion, int partitionStartOffset, int partitionLength, Collection holdResults) {
        boolean handled = false;
        int partitionEndOffset = partitionStartOffset + partitionLength - 1;
        while (structuredDocumentRegion != null && structuredDocumentRegion.getStartOffset() <= partitionEndOffset) {
            ITextRegion region = null;
            ITextRegionList regions = structuredDocumentRegion.getRegions();
            StyleRange styleRange = null;
            int i = 0;
            while (i < regions.size()) {
                region = regions.get(i);
                TextAttribute attr = null;
                TextAttribute previousAttr = null;
                if (structuredDocumentRegion.getStartOffset(region) > partitionEndOffset) break;
                if (structuredDocumentRegion.getEndOffset(region) > partitionStartOffset) {
                    if (region instanceof ITextRegionCollection) {
                        boolean handledCollection = this.prepareTextRegion((ITextRegionCollection)region, partitionStartOffset, partitionLength, holdResults);
                        handled = !handled ? handledCollection : handled;
                    } else {
                        attr = this.getAttributeFor((ITextRegionCollection)structuredDocumentRegion, region);
                        if (attr == null) {
                            previousAttr = null;
                        } else {
                            handled = true;
                            styleRange = this.applyStyleRange((ITextRegionCollection)structuredDocumentRegion, partitionStartOffset, partitionLength, holdResults, region, styleRange, attr, previousAttr);
                        }
                    }
                }
                ++i;
            }
            structuredDocumentRegion = structuredDocumentRegion.getNext();
        }
        return handled;
    }

    private StyleRange createStyleRange(ITextRegionCollection textRegionCollection, ITextRegion textRegion, TextAttribute attr, int startOffset, int length) {
        int startingOffset = textRegionCollection.getStartOffset(textRegion);
        if (startingOffset < startOffset) {
            startingOffset = startOffset;
        }
        int textEnd = startingOffset + textRegionCollection.getText(textRegion).length();
        int maxOffset = startOffset + length;
        int endingOffset = textRegionCollection.getEndOffset(textRegion);
        if (textEnd < endingOffset) {
            endingOffset = textEnd;
        }
        if (endingOffset > maxOffset) {
            endingOffset = maxOffset;
        }
        StyleRange result = new StyleRange(startingOffset, endingOffset - startingOffset, attr.getForeground(), attr.getBackground(), attr.getStyle());
        if ((attr.getStyle() & 0x20000000) != 0) {
            result.strikeout = true;
        }
        if ((attr.getStyle() & 0x40000000) != 0) {
            result.underline = true;
        }
        return result;
    }

    protected TextAttribute getAttributeFor(ITextRegionCollection collection, ITextRegion textRegion) {
        if (textRegion == null) {
            return XMLTextAttributeMap.getInstance().getTextAttributeMap().get("cdataText");
        }
        String type = textRegion.getType();
        if (collection.getText().contains("xsl:")) {
            return this.getXSLAttribute(type);
        }
        return this.getXMLAttribute(type);
    }

    private TextAttribute getXSLAttribute(String type) {
        Map<String, String> regionMap = XSLRegionMap.getInstance().getRegionMap();
        Map<String, TextAttribute> textAttributes = XSLTextAttributeMap.getInstance().getTextAttributeMap();
        return this.getTextAttribute(type, regionMap, textAttributes);
    }

    private TextAttribute getXMLAttribute(String type) {
        Map<String, String> regionMap = XMLRegionMap.getInstance().getRegionMap();
        Map<String, TextAttribute> textAttributes = XMLTextAttributeMap.getInstance().getTextAttributeMap();
        return this.getTextAttribute(type, regionMap, textAttributes);
    }

    private TextAttribute getTextAttribute(String type, Map<String, String> regionMap, Map<String, TextAttribute> textAttrMap) {
        return textAttrMap.get(regionMap.get(type));
    }

    protected void handlePropertyChange(PropertyChangeEvent event) {
        String styleKey = null;
        if (event == null) {
            return;
        }
        String prefKey = event.getProperty();
        if ("xsltagName".equals(prefKey)) {
            styleKey = "xsltagName";
        }
        if ("xsltagBorder".equals(prefKey)) {
            styleKey = "xsltagBorder";
        }
        if ("xsltagAttributeName".equals(prefKey)) {
            styleKey = "xsltagAttributeName";
        }
        if ("xsltagAttributeValue".equals(prefKey)) {
            styleKey = "xsltagAttributeValue";
        }
        if (styleKey == null) {
            return;
        }
        if (styleKey != null) {
            this.addTextAttribute(styleKey);
        }
        if (this.recHighlighter != null) {
            this.recHighlighter.refreshDisplay();
        }
    }

    protected void addTextAttribute(String colorKey) {
        String prefString;
        String[] stylePrefs;
        if (this.getColorPreferences() != null && (stylePrefs = ColorHelper.unpackStylePreferences((String)(prefString = this.getColorPreferences().getString(colorKey)))) != null) {
            RGB foreground = ColorHelper.toRGB((String)stylePrefs[0]);
            RGB background = ColorHelper.toRGB((String)stylePrefs[1]);
            boolean bold = Boolean.valueOf(stylePrefs[2]);
            boolean italic = Boolean.valueOf(stylePrefs[3]);
            boolean strikethrough = Boolean.valueOf(stylePrefs[4]);
            boolean underline = Boolean.valueOf(stylePrefs[5]);
            int style = 0;
            if (bold) {
                style |= 1;
            }
            if (italic) {
                style |= 2;
            }
            if (strikethrough) {
                style |= 0x20000000;
            }
            if (underline) {
                style |= 0x40000000;
            }
            this.updateTextAttribute(colorKey, foreground, background, style);
        }
    }

    private void updateTextAttribute(String colorKey, RGB foreground, RGB background, int style) {
        TextAttribute createTextAttribute = this.createTextAttribute(foreground, background, style);
        TextAttribute textAttribute = XSLTextAttributeMap.getInstance().getTextAttributeMap().get(colorKey);
        if (textAttribute != null) {
            XSLTextAttributeMap.getInstance().getTextAttributeMap().put(colorKey, createTextAttribute);
            return;
        }
        textAttribute = XMLTextAttributeMap.getInstance().getTextAttributeMap().get(colorKey);
        if (textAttribute != null) {
            XMLTextAttributeMap.getInstance().getTextAttributeMap().put(colorKey, createTextAttribute);
        }
    }

    public void init(IStructuredDocument document, Highlighter highlighter) {
        this.commonInit(this.structuredDocument, highlighter);
        if (this.isInitialized()) {
            return;
        }
        this.registerPreferenceManager();
        this.setInitialized(true);
    }

    public void init(IStructuredDocument structuredDocument, ISourceViewer sourceViewer) {
        this.init(structuredDocument, (Highlighter)null);
    }

    public void init(IStructuredDocument structuredDocument, ReconcilerHighlighter highlighter) {
        this.structuredDocument = structuredDocument;
        this.recHighlighter = highlighter;
        if (this.isInitialized()) {
            return;
        }
        this.registerPreferenceManager();
        this.setInitialized(true);
    }

    public void release() {
        this.unRegisterPreferenceManager();
        this.setInitialized(false);
    }

    protected void unRegisterPreferenceManager() {
        IPreferenceStore pref = this.getColorPreferences();
        if (pref != null) {
            pref.removePropertyChangeListener(this.preferenceListener);
        }
    }

    protected void registerPreferenceManager() {
        IPreferenceStore pref = this.getColorPreferences();
        if (pref != null) {
            pref.addPropertyChangeListener(this.preferenceListener);
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    protected IStructuredDocument getDocument() {
        return this.structuredDocument;
    }

    protected Highlighter getHighlighter() {
        return this.highlighter;
    }

    protected IPreferenceStore getColorPreferences() {
        if (this.xmlPreferenceStore == null) {
            this.xmlPreferenceStore = XMLUIPlugin.getDefault().getPreferenceStore();
        }
        if (this.xslPreferenceStore == null) {
            this.xslPreferenceStore = XSLUIPlugin.getDefault().getPreferenceStore();
        }
        this.combinedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{this.xmlPreferenceStore, this.xslPreferenceStore});
        return this.combinedPreferenceStore;
    }

    protected TextAttribute createTextAttribute(RGB foreground, RGB background, boolean bold) {
        return new TextAttribute(foreground != null ? EditorUtility.getColor((RGB)foreground) : null, background != null ? EditorUtility.getColor((RGB)background) : null, bold ? 1 : 0);
    }

    protected TextAttribute createTextAttribute(RGB foreground, RGB background, int style) {
        return new TextAttribute(foreground != null ? EditorUtility.getColor((RGB)foreground) : null, background != null ? EditorUtility.getColor((RGB)background) : null, style);
    }

    protected TextAttribute getAttributeFor(ITextRegion region) {
        return null;
    }

    protected void loadColors() {
    }

    private class PropertyChangeListener
    implements IPropertyChangeListener {
        private PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            LineStyleProviderForXSL.this.handlePropertyChange(event);
        }
    }
}

