/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.io.File;
import java.util.Iterator;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ContainerDataVolumeDialog;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ContainerEnvironmentVariableDialog;
import org.eclipse.linuxtools.internal.docker.ui.wizards.DataVolumeModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.EnvironmentVariableModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunResourceVolumesVariablesModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ImageRunResourceVolumesVariablesPage
extends WizardPage {
    private final int COLUMNS = 2;
    private final DataBindingContext dbc = new DataBindingContext();
    private final ImageRunResourceVolumesVariablesModel model;

    public ImageRunResourceVolumesVariablesPage(IDockerConnection connection) throws DockerException {
        super("ImageSelectionPage", WizardMessages.getString("ImageRunResourceVolVarPage.title"), SWTImagesFactory.DESC_BANNER_REPOSITORY);
        this.setPageComplete(true);
        this.model = new ImageRunResourceVolumesVariablesModel(connection);
    }

    public ImageRunResourceVolumesVariablesModel getModel() {
        return this.model;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).applyTo(container);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)container);
        this.createVolumeSettingsContainer(container);
        this.createEnvironmentVariablesContainer(container);
        this.createSectionSeparator(container, true);
        this.createResourceSettingsContainer(container);
        this.setControl((Control)container);
    }

    private void createSectionSeparator(Composite container, boolean separator) {
        int SECTION_INDENT = 10;
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).indent(-1, 10).applyTo((Control)new Label(container, separator ? 258 : 0));
    }

    private void createResourceSettingsContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(2, 1).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().spacing(10, 2).applyTo(container);
        Button enableResourceLimitationButton = new Button(container, 32);
        enableResourceLimitationButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.enableLimitationButton"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)enableResourceLimitationButton);
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)enableResourceLimitationButton), BeanProperties.value(ImageRunResourceVolumesVariablesModel.class, (String)"enableResourceLimitations").observe((Object)this.model));
        int COLUMNS = 5;
        int INDENT = 20;
        Composite subContainer = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 4).indent(20, 0).span(5, 1).grab(true, false).applyTo((Control)subContainer);
        GridLayoutFactory.fillDefaults().numColumns(5).margins(6, 6).spacing(10, 2).applyTo(subContainer);
        Label cpuPriorityLabel = new Label(subContainer, 0);
        cpuPriorityLabel.setText(WizardMessages.getString("ImageRunResourceVolVarPage.cpuPriorityLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)cpuPriorityLabel);
        Button lowCPULimitationButton = new Button(subContainer, 16);
        lowCPULimitationButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.lowButton"));
        lowCPULimitationButton.addSelectionListener(this.onCpuShareWeighting(512));
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)lowCPULimitationButton);
        Button mediumCPULimitationButton = new Button(subContainer, 16);
        mediumCPULimitationButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.mediumButton"));
        mediumCPULimitationButton.addSelectionListener(this.onCpuShareWeighting(1024));
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)mediumCPULimitationButton);
        Button highCPULimitationButton = new Button(subContainer, 16);
        mediumCPULimitationButton.setSelection(true);
        highCPULimitationButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.highButton"));
        highCPULimitationButton.addSelectionListener(this.onCpuShareWeighting(2048));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).applyTo((Control)highCPULimitationButton);
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)enableResourceLimitationButton), BeanProperties.value(ImageRunResourceVolumesVariablesModel.class, (String)"enableResourceLimitations").observe((Object)this.model));
        Label memoryLimitLabel = new Label(subContainer, 0);
        memoryLimitLabel.setText(WizardMessages.getString("ImageRunResourceVolVarPage.memoryLimit"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)memoryLimitLabel);
        Scale memoryLimitSpinner = new Scale(subContainer, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(2, 1).applyTo((Control)memoryLimitSpinner);
        memoryLimitSpinner.setBackground(Display.getDefault().getSystemColor(37));
        memoryLimitSpinner.setMinimum(0);
        memoryLimitSpinner.setMaximum(this.model.getTotalMemory());
        memoryLimitSpinner.setSelection(512);
        memoryLimitSpinner.setPageIncrement(64);
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)memoryLimitSpinner), BeanProperties.value(ImageRunResourceVolumesVariablesModel.class, (String)"memoryLimit").observe((Object)this.model));
        Text memoryLimitValueText = new Text(subContainer, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).hint(50, -1).applyTo((Control)memoryLimitValueText);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)memoryLimitValueText), BeanProperties.value(ImageRunResourceVolumesVariablesModel.class, (String)"memoryLimit").observe((Object)this.model));
        Label memoryLimitValueLabel = new Label(subContainer, 0);
        memoryLimitValueLabel.setText("MB");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)memoryLimitValueLabel);
        enableResourceLimitationButton.addSelectionListener(this.onEnableResourceLimitation(subContainer));
        this.toggleResourceLimitationControls(subContainer);
    }

    private SelectionListener onCpuShareWeighting(final int cpuShareWeigth) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageRunResourceVolumesVariablesPage.this.model.setCpuShareWeight(cpuShareWeigth);
            }
        };
    }

    private SelectionListener onEnableResourceLimitation(final Composite container) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageRunResourceVolumesVariablesPage.this.toggleResourceLimitationControls(container);
            }
        };
    }

    private void toggleResourceLimitationControls(Composite container) {
        Control[] controlArray = container.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control childControl = controlArray[n2];
            if (this.model.isEnableResourceLimitations()) {
                childControl.setEnabled(true);
            } else {
                childControl.setEnabled(false);
            }
            ++n2;
        }
    }

    private void createVolumeSettingsContainer(Composite container) {
        Label volumesLabel = new Label(container, 0);
        volumesLabel.setText(WizardMessages.getString("ImageRunResourceVolVarPage.dataVolumesLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)volumesLabel);
        CheckboxTableViewer dataVolumesTableViewer = this.createVolumesTable(container);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).hint(200, 100).applyTo((Control)dataVolumesTableViewer.getTable());
        Composite buttonsContainers = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)buttonsContainers);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(-1, 0).applyTo(buttonsContainers);
        Button addButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)addButton);
        addButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.addButton"));
        addButton.addSelectionListener(this.onAddDataVolume(dataVolumesTableViewer));
        Button editButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)editButton);
        editButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.editButton"));
        editButton.addSelectionListener(this.onEditDataVolume(dataVolumesTableViewer));
        editButton.setEnabled(false);
        Button removeButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)removeButton);
        removeButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.removeButton"));
        removeButton.addSelectionListener(this.onRemoveDataVolumes((TableViewer)dataVolumesTableViewer));
        removeButton.setEnabled(false);
        this.bind((StructuredViewer)dataVolumesTableViewer, (IObservableList)this.model.getDataVolumes(), BeanProperties.values(DataVolumeModel.class, (String[])new String[]{"containerPath", "mount", "readOnly"}));
        this.dbc.bindSet((IObservableSet)ViewersObservables.observeCheckedElements((CheckboxTableViewer)dataVolumesTableViewer, DataVolumeModel.class), BeanProperties.set((String)"selectedDataVolumes").observe((Object)this.model));
        dataVolumesTableViewer.addSelectionChangedListener(this.onSelectionChanged(editButton, removeButton));
    }

    private void bind(StructuredViewer viewer, IObservableList input, IBeanValueProperty[] labelProperties) {
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        if (viewer.getInput() != null) {
            viewer.setInput(null);
        }
        viewer.setContentProvider((IContentProvider)contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new DataVolumesLabelProvider(Properties.observeEach((IObservableSet)contentProvider.getKnownElements(), (IValueProperty[])labelProperties)));
        if (input != null) {
            viewer.setInput((Object)input);
        }
    }

    private ISelectionChangedListener onSelectionChanged(final Button ... targetButtons) {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                if (e.getSelection().isEmpty()) {
                    ImageRunResourceVolumesVariablesPage.setControlsEnabled((Control[])targetButtons, false);
                } else {
                    ImageRunResourceVolumesVariablesPage.setControlsEnabled((Control[])targetButtons, true);
                }
            }
        };
    }

    private SelectionListener onAddDataVolume(final CheckboxTableViewer dataVolumesTableViewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContainerDataVolumeDialog dialog = new ContainerDataVolumeDialog(ImageRunResourceVolumesVariablesPage.this.getShell(), ImageRunResourceVolumesVariablesPage.this.model.getConnection());
                dialog.create();
                if (dialog.open() == 0) {
                    ImageRunResourceVolumesVariablesPage.this.model.getDataVolumes().add((Object)dialog.getDataVolume());
                    ImageRunResourceVolumesVariablesPage.this.model.getSelectedDataVolumes().add(dialog.getDataVolume());
                    dataVolumesTableViewer.setChecked((Object)dialog.getDataVolume(), true);
                }
            }
        };
    }

    private SelectionListener onEditDataVolume(final CheckboxTableViewer dataVolumesTableViewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)dataVolumesTableViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                DataVolumeModel selectedDataVolume = (DataVolumeModel)selection.getFirstElement();
                ContainerDataVolumeDialog dialog = new ContainerDataVolumeDialog(ImageRunResourceVolumesVariablesPage.this.getShell(), ImageRunResourceVolumesVariablesPage.this.model.getConnection(), selectedDataVolume);
                dialog.create();
                if (dialog.open() == 0) {
                    DataVolumeModel dialogDataVolume = dialog.getDataVolume();
                    selectedDataVolume.setContainerMount(dialogDataVolume.getContainerMount());
                    selectedDataVolume.setMountType(dialogDataVolume.getMountType());
                    selectedDataVolume.setHostPathMount(dialogDataVolume.getHostPathMount());
                    selectedDataVolume.setContainerMount(dialogDataVolume.getContainerMount());
                    selectedDataVolume.setReadOnly(dialogDataVolume.isReadOnly());
                    ImageRunResourceVolumesVariablesPage.this.model.getSelectedDataVolumes().add(selectedDataVolume);
                    dataVolumesTableViewer.setChecked((Object)selectedDataVolume, true);
                }
            }
        };
    }

    private SelectionListener onRemoveDataVolumes(final TableViewer dataVolumesTableViewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = dataVolumesTableViewer.getStructuredSelection();
                for (DataVolumeModel volume : selection) {
                    ImageRunResourceVolumesVariablesPage.this.model.removeDataVolume(volume);
                    ImageRunResourceVolumesVariablesPage.this.model.getSelectedDataVolumes().remove(volume);
                }
            }
        };
    }

    private CheckboxTableViewer createVolumesTable(Composite container) {
        Table table = new Table(container, 68384);
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.dbc.bindSet((IObservableSet)ViewersObservables.observeCheckedElements((CheckboxTableViewer)tableViewer, DataVolumeModel.class), BeanProperties.set((String)"selectedDataVolumes").observe((Object)this.model));
        this.addTableViewerColum((TableViewer)tableViewer, WizardMessages.getString("ImageRunResourceVolVarPage.containerPathColumn"), 150);
        this.addTableViewerColum((TableViewer)tableViewer, WizardMessages.getString("ImageRunResourceVolVarPage.mountColumn"), 150);
        this.addTableViewerColum((TableViewer)tableViewer, WizardMessages.getString("ImageRunResourceVolVarPage.readonlyColumn"), 60);
        return tableViewer;
    }

    private TableViewerColumn addTableViewerColum(TableViewer tableViewer, String title, int width) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        if (title != null) {
            column.setText(title);
        }
        column.setWidth(width);
        return viewerColumn;
    }

    private void createEnvironmentVariablesContainer(Composite container) {
        Label envVarLabel = new Label(container, 0);
        envVarLabel.setText(WizardMessages.getString("ImageRunResourceVolVarPage.envVarLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)envVarLabel);
        TableViewer environmentVariablesTableViewer = this.createEnvironmentVariablesTable(container);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).hint(200, 100).applyTo((Control)environmentVariablesTableViewer.getTable());
        Composite buttonsContainers = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)buttonsContainers);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(-1, 0).applyTo(buttonsContainers);
        Button addButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)addButton);
        addButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.addButton"));
        addButton.setEnabled(true);
        addButton.addSelectionListener(this.onAddEnvironmentVariable());
        Button editButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)editButton);
        editButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.editButton"));
        editButton.setEnabled(true);
        editButton.addSelectionListener(this.onEditEnvironmentVariable(environmentVariablesTableViewer));
        editButton.setEnabled(false);
        Button removeButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)removeButton);
        removeButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.removeButton"));
        removeButton.addSelectionListener(this.onRemoveEnvironmentVariables(environmentVariablesTableViewer));
        removeButton.setEnabled(false);
        ViewerSupport.bind((StructuredViewer)environmentVariablesTableViewer, (IObservableList)this.model.getEnvironmentVariables(), (IValueProperty[])BeanProperties.values(EnvironmentVariableModel.class, (String[])new String[]{"name", "value"}));
        environmentVariablesTableViewer.addSelectionChangedListener(this.onSelectionChanged(editButton, removeButton));
    }

    private TableViewer createEnvironmentVariablesTable(Composite container) {
        Table table = new Table(container, 68352);
        TableViewer tableViewer = new TableViewer(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.addTableViewerColum(tableViewer, WizardMessages.getString("ImageRunResourceVolVarPage.nameColumn"), 200);
        this.addTableViewerColum(tableViewer, WizardMessages.getString("ImageRunResourceVolVarPage.valueColumn"), 200);
        return tableViewer;
    }

    private SelectionListener onAddEnvironmentVariable() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContainerEnvironmentVariableDialog dialog = new ContainerEnvironmentVariableDialog(ImageRunResourceVolumesVariablesPage.this.getShell());
                dialog.create();
                if (dialog.open() == 0) {
                    ImageRunResourceVolumesVariablesPage.this.model.getEnvironmentVariables().add((Object)dialog.getEnvironmentVariable());
                }
            }
        };
    }

    private SelectionListener onEditEnvironmentVariable(final TableViewer environmentVariablesTableViewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnvironmentVariableModel selectedVariable = (EnvironmentVariableModel)environmentVariablesTableViewer.getStructuredSelection().getFirstElement();
                ContainerEnvironmentVariableDialog dialog = new ContainerEnvironmentVariableDialog(ImageRunResourceVolumesVariablesPage.this.getShell(), selectedVariable);
                dialog.create();
                if (dialog.open() == 0) {
                    selectedVariable.setName(dialog.getEnvironmentVariable().getName());
                    selectedVariable.setValue(dialog.getEnvironmentVariable().getValue());
                    environmentVariablesTableViewer.refresh();
                }
            }
        };
    }

    private SelectionListener onRemoveEnvironmentVariables(final TableViewer linksTableViewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = linksTableViewer.getStructuredSelection();
                Iterator iterator = selection.iterator();
                while (iterator.hasNext()) {
                    ImageRunResourceVolumesVariablesPage.this.model.removeEnvironmentVariable((EnvironmentVariableModel)iterator.next());
                }
            }
        };
    }

    private static void setControlsEnabled(Control[] controls, boolean enabled) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(enabled);
            ++n2;
        }
    }

    private static final class DataVolumesLabelProvider
    extends ObservableMapLabelProvider {
        public DataVolumesLabelProvider(IObservableMap[] attributeMaps) {
            super(attributeMaps);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            DataVolumeModel dataVolume = (DataVolumeModel)element;
            if (dataVolume.getMountType() != null && columnIndex == 1) {
                switch (dataVolume.getMountType()) {
                    case CONTAINER: {
                        return SWTImagesFactory.DESC_CONTAINER.createImage();
                    }
                    case HOST_FILE_SYSTEM: {
                        File hostFile = new File(dataVolume.getMount());
                        if (!hostFile.exists() || hostFile.isDirectory()) {
                            return SWTImagesFactory.DESC_FOLDER_CLOSED.createImage();
                        }
                        return SWTImagesFactory.DESC_FILE.createImage();
                    }
                }
                return null;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            DataVolumeModel dataVolume = (DataVolumeModel)element;
            switch (columnIndex) {
                case 0: {
                    return dataVolume.getContainerPath();
                }
                case 1: {
                    return dataVolume.getMount();
                }
                case 2: {
                    if (dataVolume.getMountType() != ImageRunResourceVolumesVariablesModel.MountType.HOST_FILE_SYSTEM) {
                        return null;
                    }
                    if (dataVolume.isReadOnly()) {
                        return WizardMessages.getString("ImageRunResourceVolVarPage.true");
                    }
                    return WizardMessages.getString("ImageRunResourceVolVarPage.false");
                }
            }
            return null;
        }
    }
}

