/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnectionInfo;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerImageInfo;
import org.eclipse.linuxtools.internal.docker.ui.databinding.BaseDatabindingModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.DataVolumeModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.EnvironmentVariableModel;

public class ImageRunResourceVolumesVariablesModel
extends BaseDatabindingModel {
    public static final int LOW = 512;
    public static final int MEDIUM = 1024;
    public static final int HIGH = 2048;
    public static final String ENABLE_RESOURCE_LIMITATIONS = "enableResourceLimitations";
    public static final String CPU_SHARE_WEIGHT = "cpuShareWeight";
    public static final String MEMORY_LIMIT = "memoryLimit";
    public static final String DATA_VOLUMES = "dataVolumes";
    public static final String SELECTED_DATA_VOLUMES = "selectedDataVolumes";
    public static final String ENVIRONMENT_VARIABLES = "environmentVariables";
    private boolean enableResourceLimitations = false;
    private final IDockerConnection connection;
    private final IDockerConnectionInfo info;
    private IDockerImageInfo imageInfo = null;
    private int memoryLimit = 512;
    private int cpuShareWeighting = 1024;
    private Set<DataVolumeModel> selectedDataVolumes = new HashSet<DataVolumeModel>();
    private WritableList dataVolumes = new WritableList();
    private WritableList environmentVariables = new WritableList();

    public ImageRunResourceVolumesVariablesModel(IDockerConnection connection) throws DockerException {
        this.connection = connection;
        this.info = connection.getInfo();
    }

    public IDockerConnection getConnection() {
        return this.connection;
    }

    public void setSelectedImage(IDockerImage selectedImage) {
        WritableList newDataVolumes = new WritableList();
        if (selectedImage != null) {
            this.imageInfo = selectedImage.getConnection().getImageInfo(selectedImage.id());
            if (this.imageInfo.config().volumes() != null) {
                for (String volume : this.imageInfo.config().volumes()) {
                    newDataVolumes.add((Object)new DataVolumeModel(volume));
                }
            }
        }
        this.setDataVolumes(newDataVolumes);
    }

    public IDockerImageInfo getSelectedImageInfo() {
        return this.imageInfo;
    }

    public WritableList getDataVolumes() {
        return this.dataVolumes;
    }

    public void setDataVolumes(WritableList dataVolumes) {
        this.dataVolumes.clear();
        this.dataVolumes.addAll((Collection)dataVolumes);
    }

    public void removeDataVolume(DataVolumeModel dataVolume) {
        this.dataVolumes.remove((Object)dataVolume);
    }

    public Set<DataVolumeModel> getSelectedDataVolumes() {
        return this.selectedDataVolumes;
    }

    public void setSelectedDataVolumes(Set<DataVolumeModel> selectedDataVolumes) {
        this.selectedDataVolumes = selectedDataVolumes;
        this.firePropertyChange(SELECTED_DATA_VOLUMES, this.selectedDataVolumes, this.selectedDataVolumes);
    }

    public WritableList getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(WritableList environmentVariables) {
        this.environmentVariables.clear();
        this.environmentVariables.addAll((Collection)environmentVariables);
    }

    public void removeEnvironmentVariable(EnvironmentVariableModel variable) {
        this.environmentVariables.remove((Object)variable);
    }

    public int getTotalMemory() {
        return (int)(this.info.getTotalMemory() / 0x100000L);
    }

    public boolean isEnableResourceLimitations() {
        return this.enableResourceLimitations;
    }

    public void setEnableResourceLimitations(boolean enableResourceLimitations) {
        this.enableResourceLimitations = enableResourceLimitations;
        this.firePropertyChange(ENABLE_RESOURCE_LIMITATIONS, this.enableResourceLimitations, this.enableResourceLimitations);
    }

    public int getMemoryLimit() {
        return this.memoryLimit;
    }

    public long getMemory() {
        return this.memoryLimit * 0x100000;
    }

    public void setMemoryLimit(int memoryLimit) {
        this.memoryLimit = memoryLimit;
        this.firePropertyChange(MEMORY_LIMIT, this.memoryLimit, this.memoryLimit);
    }

    public int getCpuShareWeight() {
        return this.cpuShareWeighting;
    }

    public void setCpuShareWeight(int cpuShareWeighting) {
        this.cpuShareWeighting = cpuShareWeighting;
        this.firePropertyChange(CPU_SHARE_WEIGHT, this.cpuShareWeighting, this.cpuShareWeighting);
    }

    public static enum MountType {
        NONE,
        HOST_FILE_SYSTEM,
        CONTAINER;

    }
}

