/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.ui.wizards.ImageSearch;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImagePullPageModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ImagePullPage
extends WizardPage {
    private final ImagePullPageModel model;
    private final DataBindingContext dbc;
    private final IDockerConnection connection;
    private static final String REGISTRY_HOST = "[a-zA-Z0-9]+([._-][a-zA-Z0-9]+)*";
    private static final String REGISTRY_PORT = "[0-9]+";
    private static final String REPOSITORY = "[a-z0-9]+([._-][a-z0-9]+)*";
    private static final String NAME = "[a-z0-9]+([._-][a-z0-9]+)*";
    private static final String TAG = "[a-zA-Z0-9]+([._-][a-zA-Z0-9]+)*";
    private static final Pattern imageNamePattern = Pattern.compile("([a-zA-Z0-9]+([._-][a-zA-Z0-9]+)*(\\:[0-9]+)?/)?([a-z0-9]+([._-][a-z0-9]+)*/)?[a-z0-9]+([._-][a-z0-9]+)*(?<tag>\\:[a-zA-Z0-9]+([._-][a-zA-Z0-9]+)*)?");

    public ImagePullPage(IDockerConnection connection) {
        super("ImagePullPage", WizardMessages.getString("ImagePull.label"), SWTImagesFactory.DESC_BANNER_REPOSITORY);
        this.setMessage(WizardMessages.getString("ImagePull.desc"));
        this.model = new ImagePullPageModel();
        this.dbc = new DataBindingContext();
        this.connection = connection;
    }

    public void dispose() {
        this.dbc.dispose();
        super.dispose();
    }

    public String getImageName() {
        Matcher matcher = imageNamePattern.matcher(this.model.getImageName());
        if (matcher.matches() && matcher.group("tag") == null) {
            return String.valueOf(this.model.getImageName()) + ":latest";
        }
        return this.model.getImageName();
    }

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(6, 6).applyTo(container);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(1, 1).grab(true, false).applyTo((Control)container);
        Label imageNameLabel = new Label(container, 0);
        imageNameLabel.setText(WizardMessages.getString("ImagePull.name.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)imageNameLabel);
        Text imageNameText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)imageNameText);
        imageNameText.setToolTipText(WizardMessages.getString("ImagePull.name.tooltip"));
        IObservableValue imgeNameObservable = BeanProperties.value(ImagePullPageModel.class, (String)"imageName").observe((Object)this.model);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)imageNameText), imgeNameObservable, new UpdateValueStrategy().setAfterConvertValidator((IValidator)new ImageNameValidator()), null);
        Button searchButton = new Button(container, 0);
        searchButton.setText(WizardMessages.getString("ImagePull.search.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)searchButton);
        searchButton.addSelectionListener(this.onSearchImage());
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
        this.setControl((Control)container);
    }

    private SelectionListener onSearchImage() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageSearch imageSearchWizard = new ImageSearch(ImagePullPage.this.connection, ImagePullPage.this.model.getImageName());
                boolean completed = CommandUtils.openWizard((IWizard)imageSearchWizard, ImagePullPage.this.getShell());
                if (completed) {
                    ImagePullPage.this.model.setImageName(imageSearchWizard.getSelectedImage());
                }
            }
        };
    }

    public static class ImageNameValidator
    implements IValidator {
        public IStatus validate(Object value) {
            String imageName = (String)value;
            if (imageName.isEmpty()) {
                return ValidationStatus.cancel((String)WizardMessages.getString("ImagePull.desc"));
            }
            Matcher matcher = imageNamePattern.matcher(imageName);
            if (!matcher.matches()) {
                return ValidationStatus.warning((String)WizardMessages.getString("ImagePull.name.invalidformat.msg"));
            }
            if (matcher.group("tag") == null) {
                return ValidationStatus.warning((String)WizardMessages.getString("ImagePull.assumeLatest.msg"));
            }
            return Status.OK_STATUS;
        }
    }
}

