/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.util.UUID;
import org.eclipse.linuxtools.internal.docker.ui.databinding.BaseDatabindingModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunResourceVolumesVariablesModel;

public class DataVolumeModel
extends BaseDatabindingModel
implements Comparable<DataVolumeModel> {
    public static final String CONTAINER_PATH = "containerPath";
    public static final String MOUNT_TYPE = "mountType";
    public static final String MOUNT = "mount";
    public static final String HOST_PATH_MOUNT = "hostPathMount";
    public static final String READ_ONLY_VOLUME = "readOnly";
    public static final String CONTAINER_MOUNT = "containerMount";
    private final String id = UUID.randomUUID().toString();
    private String containerPath;
    private ImageRunResourceVolumesVariablesModel.MountType mountType;
    private String mount;
    private String hostPathMount;
    private String containerMount;
    private boolean readOnly = false;

    public DataVolumeModel() {
    }

    public DataVolumeModel(String containerPath) {
        this.containerPath = containerPath;
        this.mountType = ImageRunResourceVolumesVariablesModel.MountType.NONE;
    }

    public DataVolumeModel(DataVolumeModel selectedDataVolume) {
        this.containerPath = selectedDataVolume.getContainerPath();
        this.mountType = selectedDataVolume.getMountType();
        if (this.mountType != null) {
            switch (this.mountType) {
                case CONTAINER: {
                    this.containerMount = selectedDataVolume.getMount();
                    break;
                }
                case HOST_FILE_SYSTEM: {
                    this.hostPathMount = selectedDataVolume.getMount();
                    this.readOnly = selectedDataVolume.isReadOnly();
                    break;
                }
            }
        } else {
            this.mountType = ImageRunResourceVolumesVariablesModel.MountType.NONE;
        }
    }

    public String getContainerPath() {
        return this.containerPath;
    }

    public void setContainerPath(String containerPath) {
        this.containerPath = containerPath;
        this.firePropertyChange(CONTAINER_PATH, this.containerPath, this.containerPath);
    }

    public String getMount() {
        return this.mount;
    }

    public void setMount(String mount) {
        this.mount = mount;
        this.firePropertyChange(MOUNT, this.mount, this.mount);
    }

    public ImageRunResourceVolumesVariablesModel.MountType getMountType() {
        return this.mountType;
    }

    public void setMountType(ImageRunResourceVolumesVariablesModel.MountType mountType) {
        if (mountType == null) {
            return;
        }
        this.mountType = mountType;
        this.firePropertyChange(MOUNT_TYPE, (Object)this.mountType, (Object)this.mountType);
        if (this.mountType == ImageRunResourceVolumesVariablesModel.MountType.NONE) {
            this.setMount("");
        }
    }

    public String getHostPathMount() {
        return this.hostPathMount;
    }

    public void setHostPathMount(String hostPathMount) {
        this.hostPathMount = hostPathMount;
        this.firePropertyChange(HOST_PATH_MOUNT, this.hostPathMount, this.hostPathMount);
        if (this.mountType == ImageRunResourceVolumesVariablesModel.MountType.HOST_FILE_SYSTEM) {
            this.setMount(this.hostPathMount);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.firePropertyChange(READ_ONLY_VOLUME, this.readOnly, this.readOnly);
    }

    public String getContainerMount() {
        return this.containerMount;
    }

    public void setContainerMount(String containerMount) {
        this.containerMount = containerMount;
        this.firePropertyChange(CONTAINER_MOUNT, this.containerMount, this.containerMount);
        if (this.mountType == ImageRunResourceVolumesVariablesModel.MountType.CONTAINER) {
            this.setMount(this.containerMount);
        }
    }

    @Override
    public int compareTo(DataVolumeModel other) {
        return this.getContainerPath().compareTo(other.getContainerPath());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataVolumeModel other = (DataVolumeModel)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

